/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scala.cpd;

import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import org.sonar.plugins.scala.compiler.Lexer;
import org.sonar.plugins.scala.compiler.Token;

public final class ScalaTokenizer
implements Tokenizer {
    public void tokenize(SourceCode source, Tokens cpdTokens) {
        String filename = source.getFileName();
        try {
            Lexer lexer = new Lexer();
            List<Token> tokens = lexer.getTokensOfFile(filename);
            for (Token token : tokens) {
                String tokenVal = token.tokenVal() != null ? token.tokenVal() : Integer.toString(token.tokenType());
                TokenEntry cpdToken = new TokenEntry(tokenVal, filename, token.line());
                cpdTokens.add(cpdToken);
            }
            cpdTokens.add(TokenEntry.getEOF());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new TokenMgrError("Lexical error in file " + filename + ". The scala tokenizer exited with error: " + e.getMessage(), 0);
        }
    }
}

