/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.migrating;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;

public class JUnitUseExpectedRule
extends AbstractJUnitRule {
    @Override
    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        boolean inAnnotation = false;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTName annotationName;
            Node child = node.jjtGetChild(i);
            if (child instanceof ASTAnnotation && "Test".equals((annotationName = (ASTName)child.getFirstDescendantOfType(ASTName.class)).getImage())) {
                inAnnotation = true;
                continue;
            }
            if (child instanceof ASTMethodDeclaration) {
                boolean isJUnitMethod = this.isJUnitMethod((ASTMethodDeclaration)child, data);
                if (inAnnotation || isJUnitMethod) {
                    ArrayList found = new ArrayList();
                    found.addAll((List)this.visit((ASTMethodDeclaration)child, data));
                    for (Node name : found) {
                        this.addViolation(data, name);
                    }
                }
            }
            inAnnotation = false;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        List catches = node.findDescendantsOfType(ASTTryStatement.class);
        ArrayList<AbstractJavaNode> found = new ArrayList<AbstractJavaNode>();
        if (catches.isEmpty()) {
            return found;
        }
        for (ASTTryStatement trySt : catches) {
            List blocks;
            ASTBlock block;
            ASTCatchStatement cStatement = this.getCatch((Node)trySt);
            if (cStatement == null || (block = (ASTBlock)cStatement.jjtGetChild(1)).jjtGetNumChildren() != 0 || (blocks = trySt.jjtGetChild(0).findDescendantsOfType(ASTBlockStatement.class)).isEmpty()) continue;
            ASTBlockStatement st = (ASTBlockStatement)blocks.get(blocks.size() - 1);
            ASTName name = (ASTName)st.getFirstDescendantOfType(ASTName.class);
            if (name != null && st.equals(name.getNthParent(5)) && "fail".equals(name.getImage())) {
                found.add(name);
                continue;
            }
            ASTThrowStatement th = (ASTThrowStatement)st.getFirstDescendantOfType(ASTThrowStatement.class);
            if (th == null || !st.equals(th.getNthParent(2))) continue;
            found.add(th);
        }
        return found;
    }

    private ASTCatchStatement getCatch(Node n) {
        for (int i = 0; i < n.jjtGetNumChildren(); ++i) {
            if (!(n.jjtGetChild(i) instanceof ASTCatchStatement)) continue;
            return (ASTCatchStatement)n.jjtGetChild(i);
        }
        return null;
    }
}

