/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.codesize;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTGlobal;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.OracleObject;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.codesize.AbstractNcssCountRule;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NcssObjectCountRule
extends AbstractNcssCountRule {
    private static final String CLASS_NAME = NcssObjectCountRule.class.getName();
    private static final Logger LOGGER = Logger.getLogger(NcssObjectCountRule.class.getName());

    public NcssObjectCountRule() {
        super(OracleObject.class);
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 1500.0);
    }

    public Object visit(OracleObject node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(NcssObjectCountRule)");
        if (node.jjtGetParent() instanceof ASTGlobal) {
            LOGGER.fine("Schema-level");
            return super.visit(node, data);
        }
        LOGGER.fine("not Schema-level");
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTProgramUnit node, Object data) {
        int numNodes = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.jjtGetChild(i);
            Integer treeSize = (Integer)n.jjtAccept(this, data);
            numNodes += treeSize.intValue();
        }
        if (node instanceof OracleObject && node.jjtGetParent() instanceof ASTGlobal) {
            DataPoint point = new DataPoint();
            point.setNode((Node)node);
            point.setScore(1.0 * (double)(++numNodes));
            point.setMessage(this.getMessage());
            this.addDataPoint(point);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Running score is " + point.getScore());
            }
        }
        return numNodes;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTFieldDeclaration)");
        return NumericConstants.ONE;
    }

    @Override
    public Object[] getViolationParameters(DataPoint point) {
        LOGGER.entering(CLASS_NAME, "visit(getViolationParameters)");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Node Count ==" + point.getScore());
        }
        return new String[]{String.valueOf((int)point.getScore())};
    }
}

