/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.plsql.ast.ASTName;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.symboltable.Applier;
import net.sourceforge.pmd.lang.plsql.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.plsql.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractScope;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class LocalScope
extends AbstractScope {
    public NameDeclaration addNameOccurrence(NameOccurrence occ) {
        PLSQLNameOccurrence occurrence = (PLSQLNameOccurrence)occ;
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && !occurrence.isThisOrSuper()) {
            List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
            nameOccurrences.add(occurrence);
            PLSQLNode n = occurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public void addDeclaration(NameDeclaration declaration) {
        if (declaration instanceof VariableNameDeclaration && this.getDeclarations().keySet().contains(declaration)) {
            throw new RuntimeException(declaration + " is already in the symbol table");
        }
        super.addDeclaration(declaration);
    }

    public NameDeclaration findVariableHere(PLSQLNameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return null;
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply(finder, this.getVariableDeclarations().keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        return "LocalScope:" + this.getVariableDeclarations().keySet();
    }
}

