/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitorAdapter;
import net.sourceforge.pmd.lang.plsql.symboltable.NameFinder;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.plsql.symboltable.Search;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class OccurrenceFinder
extends PLSQLParserVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(OccurrenceFinder.class.getName());

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        NameFinder nameFinder = new NameFinder(node);
        NameDeclaration decl = null;
        List<PLSQLNameOccurrence> names = nameFinder.getNames();
        for (PLSQLNameOccurrence occ : names) {
            Search search = new Search(occ);
            if (decl == null) {
                search.execute();
                decl = search.getResult();
                if (decl != null) continue;
                break;
            }
            Scope scope = decl.getScope();
            if (null == scope) {
                if (!LOGGER.isLoggable(Level.FINEST)) break;
                LOGGER.finest("NameOccurrence has no Scope:" + decl.getClass().getCanonicalName() + "=>" + decl.getImage());
                break;
            }
            search.execute(scope);
            decl = search.getResult();
            if (decl != null) continue;
            break;
        }
        return super.visit(node, data);
    }
}

