/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class UndoableOperation2ChangeAdapter
implements IUndoableOperation,
IAdvancedUndoableOperation {
    private String fLabel;
    private String fDescription;
    private Change fExecuteChange;
    private Change fUndoChange;
    private Change fRedoChange;
    private Change fActiveChange;
    private List fContexts = new ArrayList();
    static /* synthetic */ Class class$0;

    public UndoableOperation2ChangeAdapter(Change change) {
        this.fExecuteChange = change;
        this.fActiveChange = change;
    }

    public void setUndoChange(Change undoChange) {
        this.fActiveChange = this.fUndoChange = undoChange;
        this.fExecuteChange = null;
        this.fRedoChange = null;
    }

    public Change getChange() {
        return this.fActiveChange;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public String getLabel() {
        if (this.fLabel != null) {
            return this.fLabel;
        }
        return this.fActiveChange.getName();
    }

    public String getDescription() {
        if (this.fDescription != null) {
            return this.fDescription;
        }
        return this.fActiveChange.getName();
    }

    public Object[] getAffectedObjects() {
        if (this.fActiveChange == null) {
            return null;
        }
        return this.fActiveChange.getAffectedObjects();
    }

    public void addContext(IUndoContext context) {
        if (!this.fContexts.contains(context)) {
            this.fContexts.add(context);
        }
    }

    public boolean hasContext(IUndoContext context) {
        if (context == null) {
            return false;
        }
        int i = 0;
        while (i < this.fContexts.size()) {
            IUndoContext otherContext = (IUndoContext)this.fContexts.get(i);
            if (context.matches(otherContext) || otherContext.matches(context)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeContext(IUndoContext context) {
        this.fContexts.remove(context);
    }

    public IUndoContext[] getContexts() {
        return this.fContexts.toArray(new IUndoContext[this.fContexts.size()]);
    }

    public boolean canExecute() {
        return this.fExecuteChange != null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ExecuteResult result = this.executeChange(this.getQuery(info, RefactoringCoreMessages.Refactoring_execute_label), monitor);
            if (!result.changeExecuted) {
                return this.createStatus(result);
            }
            this.fActiveChange = this.fUndoChange = result.reverseChange;
            this.fExecuteChange = null;
            return new Status(0, RefactoringCorePlugin.getPluginId(), 0, "", null);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public boolean canUndo() {
        return this.fUndoChange != null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ExecuteResult result = this.executeChange(this.getQuery(info, RefactoringCoreMessages.Refactoring_undo_label), monitor);
            if (!result.changeExecuted) {
                this.fUndoChange = null;
                this.fRedoChange = null;
                this.clearActiveChange();
                return this.createStatus(result);
            }
            this.fActiveChange = this.fRedoChange = result.reverseChange;
            this.fUndoChange = null;
            return new Status(0, RefactoringCorePlugin.getPluginId(), 0, "", null);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) throws ExecutionException {
        if (this.fUndoChange == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoableOperation2ChangeAdapter_no_undo_available, null);
        }
        try {
            RefactoringStatus status;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((status = this.fUndoChange.isValid(monitor)).hasFatalError()) {
                this.fUndoChange = null;
                this.clearActiveChange();
                return this.asStatus(status);
            }
            return new Status(0, RefactoringCorePlugin.getPluginId(), 0, "", null);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public boolean canRedo() {
        return this.fRedoChange != null;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ExecuteResult result = this.executeChange(this.getQuery(info, RefactoringCoreMessages.Refactoring_redo_label), monitor);
            if (!result.changeExecuted) {
                this.fUndoChange = null;
                this.fRedoChange = null;
                this.clearActiveChange();
                return this.createStatus(result);
            }
            this.fActiveChange = this.fUndoChange = result.reverseChange;
            this.fRedoChange = null;
            return new Status(0, RefactoringCorePlugin.getPluginId(), 0, "", null);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) throws ExecutionException {
        if (this.fRedoChange == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoableOperation2ChangeAdapter_no_redo_available, null);
        }
        try {
            RefactoringStatus status;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((status = this.fRedoChange.isValid(monitor)).hasFatalError()) {
                this.fRedoChange = null;
                this.clearActiveChange();
                return this.asStatus(status);
            }
            return new Status(0, RefactoringCorePlugin.getPluginId(), 0, "", null);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getStatus().getMessage(), (Throwable)e);
        }
    }

    public void aboutToNotify(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                ResourcesPlugin.getWorkspace().checkpoint(false);
            }
        }
    }

    public void dispose() {
        if (this.fActiveChange != null) {
            this.fActiveChange.dispose();
        }
    }

    private ExecuteResult executeChange(final IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException {
        final ExecuteResult result = new ExecuteResult();
        if (this.fActiveChange == null || !this.fActiveChange.isEnabled()) {
            return result;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                boolean reverseIsInitialized = false;
                try {
                    try {
                        block16: {
                            block15: {
                                block14: {
                                    monitor.beginTask("", 11);
                                    result.validationStatus = UndoableOperation2ChangeAdapter.this.fActiveChange.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                    if (!result.validationStatus.hasFatalError()) break block14;
                                    query.stopped(result.validationStatus);
                                    break block15;
                                }
                                if (result.validationStatus.isOK() || query.proceed(result.validationStatus)) break block16;
                            }
                            Object var5_3 = null;
                            monitor.done();
                            return;
                        }
                        try {
                            result.changeExecutionFailed = true;
                            result.reverseChange = UndoableOperation2ChangeAdapter.this.fActiveChange.perform((IProgressMonitor)new SubProgressMonitor(monitor, 9));
                            result.changeExecutionFailed = false;
                            result.changeExecuted = true;
                            Object var3_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_9 = null;
                            ResourcesPlugin.getWorkspace().checkpoint(false);
                            throw throwable;
                        }
                        ResourcesPlugin.getWorkspace().checkpoint(false);
                        UndoableOperation2ChangeAdapter.this.fActiveChange.dispose();
                        if (result.reverseChange != null) {
                            result.reverseChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                            reverseIsInitialized = true;
                        }
                    }
                    catch (CoreException e) {
                        Change ch = result.reverseChange;
                        result.reverseChange = null;
                        if (ch == null) throw e;
                        if (!reverseIsInitialized) throw e;
                        ch.dispose();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        Change ch = result.reverseChange;
                        result.reverseChange = null;
                        if (ch == null) throw e;
                        if (!reverseIsInitialized) throw e;
                        ch.dispose();
                        throw e;
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, pm);
        return result;
    }

    private IStatus createStatus(ExecuteResult result) {
        if (!result.validationStatus.isOK()) {
            return result.validationStatus.getEntryWithHighestSeverity().toStatus();
        }
        return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoableOperation2ChangeAdapter_error_message, null);
    }

    private IStatus asStatus(RefactoringStatus status) {
        if (status.isOK()) {
            return new Status(0, RefactoringCorePlugin.getPluginId(), 0, "", null);
        }
        return status.getEntryWithHighestSeverity().toStatus();
    }

    private IValidationCheckResultQuery getQuery(IAdaptable info, String title) {
        IValidationCheckResultQuery result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (IValidationCheckResultQuery)info.getAdapter((Class)clazz)) != null) {
            return result;
        }
        ContextAdapter context = new ContextAdapter(info, title);
        return RefactoringCore.getQueryFactory().create(context);
    }

    private void clearActiveChange() {
        if (this.fLabel == null) {
            this.fLabel = this.fActiveChange.getName();
        }
        if (this.fDescription == null) {
            this.fDescription = this.fActiveChange.getName();
        }
        this.fActiveChange.dispose();
        this.fActiveChange = null;
    }

    private static class ContextAdapter
    implements IAdaptable {
        private IAdaptable fInfoAdapter;
        private String fTitle;
        static /* synthetic */ Class class$0;

        public ContextAdapter(IAdaptable infoAdapter, String title) {
            this.fInfoAdapter = infoAdapter;
            this.fTitle = title;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(adapter)) {
                return this.fTitle;
            }
            return this.fInfoAdapter.getAdapter(adapter);
        }
    }

    private static class ExecuteResult {
        boolean changeExecuted;
        boolean changeExecutionFailed;
        Change reverseChange;
        RefactoringStatus validationStatus = new RefactoringStatus();
    }
}

