/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.search.LazyProgressMonitor;
import org.eclipse.help.internal.search.PluginIndex;
import org.eclipse.help.internal.search.PrebuiltIndexes;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.search.LuceneSearchParticipant;

class IndexingOperation {
    private int numAdded;
    private int numRemoved;
    private SearchIndex index = null;

    public IndexingOperation(SearchIndex ix) {
        this.index = ix;
    }

    private void checkCancelled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void execute(IProgressMonitor pm) throws OperationCanceledException, IndexingException {
        this.checkCancelled(pm);
        Collection staleDocs = this.getRemovedDocuments(this.index);
        this.numRemoved = staleDocs.size();
        Collection newDocs = this.getAddedDocuments(this.index);
        this.numAdded = newDocs.size();
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("IndexingOperation.execute: " + this.numRemoved + " documents in deleted plug-ins, " + this.numAdded + " documents in added plug-ins.");
        }
        if (this.numRemoved + this.numAdded <= 0) {
            pm.done();
            BaseHelpSystem.getSearchManager().clearSearchParticipants();
            return;
        }
        pm.beginTask(HelpBaseResources.UpdatingIndex, this.numRemoved + 10 * this.numAdded);
        this.removeStaleDocuments((IProgressMonitor)new SubProgressMonitor(pm, this.numRemoved), staleDocs);
        this.checkCancelled(pm);
        this.addNewDocuments((IProgressMonitor)new SubProgressMonitor(pm, 10 * this.numAdded), newDocs, staleDocs.size() == 0);
        pm.done();
        BaseHelpSystem.getSearchManager().clearSearchParticipants();
    }

    private Map calculateNewToRemove(Collection newDocs, Map prebuiltDocs) {
        Map docsToDelete = prebuiltDocs;
        ArrayList prebuiltHrefs = new ArrayList(prebuiltDocs.keySet());
        int i = 0;
        while (i < prebuiltHrefs.size()) {
            String href = (String)prebuiltHrefs.get(i);
            URL u = SearchIndex.getIndexableURL(this.index.getLocale(), href);
            if (u == null) {
                docsToDelete.put(href, null);
            }
            if (newDocs.contains(u)) {
                if (docsToDelete.get(href) == null) {
                    docsToDelete.remove(href);
                }
            } else {
                docsToDelete.put(href, null);
            }
            ++i;
        }
        return docsToDelete;
    }

    private Map addNewDocuments(IProgressMonitor pm, Collection newDocs, boolean opened) throws IndexingException {
        Map prebuiltDocs = this.mergeIndexes(pm, opened);
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("IndexOperation.addNewDocuments: " + prebuiltDocs.size() + " different documents merged.");
        }
        this.checkCancelled(pm);
        Collection docsToIndex = this.calculateDocsToAdd(newDocs, prebuiltDocs);
        this.checkCancelled(pm);
        Map docsToDelete = this.calculateNewToRemove(newDocs, prebuiltDocs);
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("IndexOperation.addNewDocuments: " + docsToIndex.size() + " documents not yet indexed.");
            System.out.println("IndexOperation.addNewDocuments: " + docsToDelete.size() + " documents have more than one copy indexed.");
        }
        pm.beginTask("", 10 * docsToIndex.size() + docsToDelete.size());
        this.checkCancelled(pm);
        this.addDocuments((IProgressMonitor)new SubProgressMonitor(pm, 10 * docsToIndex.size()), docsToIndex, docsToDelete.size() == 0);
        this.checkCancelled(pm);
        this.removeNewDocuments((IProgressMonitor)new SubProgressMonitor(pm, docsToDelete.size()), docsToDelete);
        pm.done();
        return docsToDelete;
    }

    private Collection calculateDocsToAdd(Collection newDocs, Map prebuiltDocs) {
        HashSet docsToIndex = null;
        if (prebuiltDocs.size() > 0) {
            docsToIndex = new HashSet(newDocs);
            Iterator it = prebuiltDocs.keySet().iterator();
            while (it.hasNext()) {
                String href = (String)it.next();
                URL u = SearchIndex.getIndexableURL(this.index.getLocale(), href);
                if (u == null) continue;
                docsToIndex.remove(u);
            }
        } else {
            docsToIndex = newDocs;
        }
        return docsToIndex;
    }

    private void removeNewDocuments(IProgressMonitor pm, Map docsToDelete) throws IndexingException {
        pm = new LazyProgressMonitor((IProgressMonitor)pm);
        pm.beginTask("", docsToDelete.size());
        this.checkCancelled((IProgressMonitor)pm);
        Set keysToDelete = docsToDelete.keySet();
        if (keysToDelete.size() > 0) {
            if (!this.index.beginRemoveDuplicatesBatch()) {
                throw new IndexingException();
            }
            MultiStatus multiStatus = null;
            Iterator it = keysToDelete.iterator();
            while (it.hasNext()) {
                String href = (String)it.next();
                String[] indexIds = (String[])docsToDelete.get(href);
                if (indexIds == null) {
                    this.index.removeDocument(href);
                    continue;
                }
                IStatus status = this.index.removeDuplicates(href, indexIds);
                if (status.getCode() != 0) {
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus("org.eclipse.help.base", 2, "Some help documents could not removed from index.", null);
                    }
                    multiStatus.add(status);
                }
                this.checkCancelled((IProgressMonitor)pm);
                pm.worked(1);
                if (multiStatus == null) continue;
                HelpBasePlugin.logStatus((IStatus)multiStatus);
            }
            if (!this.index.endRemoveDuplicatesBatch()) {
                throw new IndexingException();
            }
        }
        pm.done();
    }

    private void addDocuments(IProgressMonitor pm, Collection addedDocs, boolean lastOperation) throws IndexingException {
        pm = new LazyProgressMonitor((IProgressMonitor)pm);
        pm.beginTask("", addedDocs.size());
        this.checkCancelled((IProgressMonitor)pm);
        pm.subTask(HelpBaseResources.UpdatingIndex);
        MultiStatus multiStatus = null;
        Iterator it = addedDocs.iterator();
        while (it.hasNext()) {
            URL doc = (URL)it.next();
            String file = doc.getFile();
            file = String.valueOf(file) + (file.indexOf(63) == -1 ? (char)'?' : '&');
            file = String.valueOf(file) + "filter=false";
            try {
                doc = new URL("help", null, -1, file, HelpURLStreamHandler.getDefault());
            }
            catch (MalformedURLException e) {
                HelpBasePlugin.logError("Error occured while adding filter parameter to URL of document to be indexed", e);
            }
            IStatus status = this.index.addDocument(this.getName(doc), doc);
            if (status.getCode() != 0) {
                if (multiStatus == null) {
                    multiStatus = new MultiStatus("org.eclipse.help.base", 4, "Help documentation could not be indexed completely.", null);
                }
                multiStatus.add(status);
            }
            this.checkCancelled((IProgressMonitor)pm);
            pm.worked(1);
        }
        if (multiStatus != null) {
            HelpBasePlugin.logStatus(multiStatus);
        }
        pm.subTask(HelpBaseResources.Writing_index);
        if (!this.index.endAddBatch(addedDocs.size() > 0, lastOperation)) {
            throw new IndexingException();
        }
        pm.done();
    }

    private void removeStaleDocuments(IProgressMonitor pm, Collection removedDocs) throws IndexingException {
        pm = new LazyProgressMonitor((IProgressMonitor)pm);
        pm.beginTask("", removedDocs.size());
        pm.subTask(HelpBaseResources.Preparing_for_indexing);
        this.checkCancelled((IProgressMonitor)pm);
        if (this.numRemoved > 0) {
            if (HelpBasePlugin.DEBUG_SEARCH) {
                System.out.println("SearchIndex.removeStaleDocuments");
            }
            if (!this.index.beginDeleteBatch()) {
                throw new IndexingException();
            }
            this.checkCancelled((IProgressMonitor)pm);
            pm.subTask(HelpBaseResources.UpdatingIndex);
            MultiStatus multiStatus = null;
            Iterator it = removedDocs.iterator();
            while (it.hasNext()) {
                URL doc = (URL)it.next();
                IStatus status = this.index.removeDocument(this.getName(doc));
                if (status.getCode() != 0) {
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus("org.eclipse.help.base", 2, "Uninstalled or updated help documents could not be removed from index.", null);
                    }
                    multiStatus.add(status);
                }
                this.checkCancelled((IProgressMonitor)pm);
                pm.worked(1);
            }
            if (multiStatus != null) {
                HelpBasePlugin.logStatus(multiStatus);
            }
            if (!this.index.endDeleteBatch()) {
                throw new IndexingException();
            }
        }
        pm.done();
    }

    private String getName(URL doc) {
        String name = doc.getFile();
        int i = name.indexOf(63);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private Collection getAddedPlugins(SearchIndex index) {
        Collection addedPlugins = index.getDocPlugins().getAdded();
        if (addedPlugins == null || addedPlugins.isEmpty()) {
            return new ArrayList(0);
        }
        return addedPlugins;
    }

    private Collection getAddedDocuments(SearchIndex index) {
        Collection addedPlugins = this.getAddedPlugins(index);
        Set urls = this.getAllDocuments(index.getLocale());
        HashSet<URL> addedDocs = new HashSet<URL>(urls.size());
        Iterator docs = urls.iterator();
        while (docs.hasNext()) {
            URL url;
            String plugin;
            String doc = (String)docs.next();
            int i = doc.indexOf(47, 1);
            String string = plugin = i == -1 ? "" : doc.substring(1, i);
            if (!addedPlugins.contains(plugin) || (url = SearchIndex.getIndexableURL(index.getLocale(), doc)) == null) continue;
            addedDocs.add(url);
        }
        LuceneSearchParticipant[] participants = BaseHelpSystem.getSearchManager().getGlobalParticipants();
        int j = 0;
        while (j < participants.length) {
            block8: {
                Set set;
                String participantId;
                try {
                    participantId = participants[j].getId();
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Failed to get help search participant id for: " + participants[j].getClass().getName() + "; skipping this one.", t);
                    break block8;
                }
                try {
                    set = participants[j].getAllDocuments(index.getLocale());
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Failed to retrieve documents from one of the help search participants: " + participants[j].getClass().getName() + "; skipping this one.", t);
                    break block8;
                }
                Iterator docs2 = set.iterator();
                while (docs2.hasNext()) {
                    URL url;
                    int i;
                    String plugin;
                    String doc = (String)docs2.next();
                    String id = null;
                    int qloc = doc.indexOf(63);
                    if (qloc != -1) {
                        String query = doc.substring(qloc + 1);
                        doc = doc.substring(0, qloc);
                        HashMap arguments = new HashMap();
                        HelpURLConnection.parseQuery((String)query, arguments);
                        id = (String)arguments.get("id");
                    }
                    String string = plugin = (i = doc.indexOf(47, 1)) == -1 ? "" : doc.substring(1, i);
                    if (!addedPlugins.contains(plugin) || (url = SearchIndex.getIndexableURL(index.getLocale(), doc, id, participantId)) == null) continue;
                    addedDocs.add(url);
                }
            }
            ++j;
        }
        return addedDocs;
    }

    private Collection getRemovedDocuments(SearchIndex index) {
        Collection removedPlugins = index.getDocPlugins().getRemoved();
        if (removedPlugins == null || removedPlugins.isEmpty()) {
            return new ArrayList(0);
        }
        HelpProperties indexedDocs = index.getIndexedDocs();
        HashSet<URL> removedDocs = new HashSet<URL>(indexedDocs.size());
        Iterator<Object> docs = indexedDocs.keySet().iterator();
        while (docs.hasNext()) {
            URL url;
            String plugin;
            String doc = (String)docs.next();
            int i = doc.indexOf(47, 1);
            String string = plugin = i == -1 ? "" : doc.substring(1, i);
            if (!removedPlugins.contains(plugin) || (url = SearchIndex.getIndexableURL(index.getLocale(), doc)) == null) continue;
            removedDocs.add(url);
        }
        return removedDocs;
    }

    private void add(ITopic topic, Set hrefs) {
        String href = topic.getHref();
        if (!(href == null || href.equals("") || href.startsWith("http://") || href.startsWith("https://"))) {
            hrefs.add(href);
        }
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            this.add(subtopics[i], hrefs);
            ++i;
        }
    }

    private Set getAllDocuments(String locale) {
        HashSet hrefs = new HashSet();
        ITocElement[] tocs = this.index.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic tocDescriptionTopic;
            ITopic[] topics = tocs[i].getTopics();
            int j = 0;
            while (j < topics.length) {
                this.add(topics[j], hrefs);
                ++j;
            }
            if (tocs[i] instanceof Toc) {
                topics = ((Toc)tocs[i]).getExtraTopics();
                j = 0;
                while (j < topics.length) {
                    this.add(topics[j], hrefs);
                    ++j;
                }
            }
            if ((tocDescriptionTopic = tocs[i].getTopic(null)) != null) {
                this.add(tocDescriptionTopic, hrefs);
            }
            ++i;
        }
        return hrefs;
    }

    private PrebuiltIndexes getIndexesToAdd(Collection pluginIds) {
        PrebuiltIndexes indexes = new PrebuiltIndexes(this.index);
        Iterator it = pluginIds.iterator();
        while (it.hasNext()) {
            String pluginId = (String)it.next();
            String indexPath = HelpPlugin.getTocManager().getIndexPath(pluginId);
            if (indexPath == null) continue;
            indexes.add(pluginId, indexPath);
        }
        return indexes;
    }

    private Map mergeIndexes(IProgressMonitor monitor, boolean opened) throws IndexingException {
        Collection addedPluginIds = this.getAddedPlugins(this.index);
        PrebuiltIndexes indexes = this.getIndexesToAdd(addedPluginIds);
        PluginIndex[] pluginIndexes = indexes.getIndexes();
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("IndexingOperation.mergeIndexes: " + pluginIndexes.length + " plugins with prebuilt index.");
        }
        Map mergedDocs = null;
        if (!this.index.beginAddBatch(opened)) {
            throw new IndexingException();
        }
        if (pluginIndexes.length > 0) {
            mergedDocs = this.index.merge(pluginIndexes, monitor);
        }
        if (mergedDocs == null) {
            return Collections.EMPTY_MAP;
        }
        return mergedDocs;
    }

    public class IndexingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

