/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ExtensionsHandler;
import org.osgi.framework.BundleException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PDEStateHelper {
    private static SAXParser parser;

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEStateHelper.getImportedBundles(root);
        BundleDescription[] required = PDEStateHelper.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEStateHelper.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEStateHelper.getImportedByFragments(root);
        BundleDescription[] required = PDEStateHelper.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEStateHelper.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                PDEStateHelper.merge(importedByFragments, PDEStateHelper.getImportedBundles(fragments[i]));
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                PDEStateHelper.merge(importedByFragments, PDEStateHelper.getRequiredBundles(fragments[i]));
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List source, BundleDescription[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (!source.contains(toAdd[i])) {
                source.add(toAdd[i]);
            }
            ++i;
        }
    }

    public static String[] getClasspath(Dictionary manifest) {
        String fullClasspath = (String)manifest.get("Bundle-ClassPath");
        String[] result = new String[]{};
        try {
            if (fullClasspath != null) {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath);
                result = new String[classpathEntries.length];
                int i = 0;
                while (i < classpathEntries.length) {
                    result[i] = classpathEntries[i].getValue();
                    ++i;
                }
            }
        }
        catch (BundleException bundleException) {}
        return result;
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        int i = 0;
        while (i < packages.length) {
            if (!root.getLocation().equals(packages[i].getExporter().getLocation()) && !resolvedImports.contains(packages[i].getExporter())) {
                resolvedImports.add(packages[i].getExporter());
            }
            ++i;
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void parseExtensions(BundleDescription desc, Element parent) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            try {
                File manifest;
                String filename = desc.getHost() == null ? "plugin.xml" : "fragment.xml";
                String path = desc.getLocation();
                File file = new File(path);
                if (file.isFile()) {
                    jarFile = new ZipFile(file, 1);
                    ZipEntry manifestEntry = jarFile.getEntry(filename);
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else if (file.isDirectory() && (manifest = new File(file, filename)).exists() && manifest.isFile()) {
                    stream = new FileInputStream(manifest);
                }
                if (stream != null) {
                    PDEStateHelper.getParser().parse(stream, (DefaultHandler)new ExtensionsHandler(parent));
                }
            }
            catch (IOException iOException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (FactoryConfigurationError factoryConfigurationError) {}
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (jarFile == null) throw throwable;
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (stream != null) {
            stream.close();
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (jarFile == null) return;
        jarFile.close();
    }

    private static SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (parser == null) {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        return parser;
    }
}

