/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import java.util.Properties;
import org.eclipse.pde.internal.core.bundle.BundleObject;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;

public class Bundle
extends BundleObject
implements IBundle {
    private static final long serialVersionUID = 1L;
    private Properties fProperties;

    public void setHeader(String key, String value) {
        if (this.fProperties == null) {
            this.fProperties = new Properties();
        }
        Object oldValue = this.fProperties.get(key);
        if (value == null || value.trim().length() == 0) {
            this.fProperties.remove(key);
        } else {
            this.fProperties.put(key, value);
        }
        this.getModel().fireModelObjectChanged(this, key, oldValue, value);
    }

    public String getHeader(String key) {
        if (this.fProperties == null) {
            return null;
        }
        return (String)this.fProperties.get(key);
    }

    public void load(Properties properties) {
        this.fProperties = properties;
    }

    public String getLocalization() {
        return this.getHeader("Bundle-Localization");
    }

    public void setLocalization(String localization) {
        this.setHeader("Bundle-Localization", localization);
    }

    public void renameHeader(String key, String newKey) {
        if (this.fProperties == null) {
            this.fProperties = new Properties();
        }
        if (this.fProperties.containsKey(key)) {
            this.fProperties.put(newKey, this.fProperties.remove(key));
        }
    }

    public IManifestHeader getManifestHeader(String key) {
        return new ManifestHeader(key, this.getHeader(key), this, System.getProperty("line.separator"));
    }
}

