/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArgumentsInfo
extends TargetObject
implements IArgumentsInfo {
    private static final long serialVersionUID = 1L;
    private String fProgramArgs = "";
    private String fVMArgs = "";

    public ArgumentsInfo(ITargetModel model) {
        super(model);
    }

    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    public String getVMArguments() {
        return this.fVMArgs;
    }

    public void setProgramArguments(String args) {
        String oldValue = this.fProgramArgs;
        this.fProgramArgs = args;
        if (this.isEditable()) {
            this.firePropertyChanged("programArgs", oldValue, this.fProgramArgs);
        }
    }

    public void setVMArguments(String args) {
        String oldValue = this.fVMArgs;
        this.fVMArgs = args;
        if (this.isEditable()) {
            this.firePropertyChanged("vmArgs", oldValue, this.fVMArgs);
        }
    }

    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("programArgs")) {
                    this.fProgramArgs = this.getText(child);
                } else if (child.getNodeName().equals("vmArgs")) {
                    this.fVMArgs = this.getText(child);
                }
            }
            ++i;
        }
    }

    private String getText(Node node) {
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3) {
            return text.getNodeValue();
        }
        return "";
    }

    public void write(String indent, PrintWriter writer) {
        if (!(this.fProgramArgs != null && this.fProgramArgs.length() != 0 || this.fVMArgs != null && this.fVMArgs.length() != 0)) {
            return;
        }
        writer.println();
        writer.println(String.valueOf(indent) + "<launcherArgs>");
        if (this.fProgramArgs.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "programArgs" + ">" + this.getWritableString(this.fProgramArgs) + "</" + "programArgs" + ">");
        }
        if (this.fVMArgs.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "vmArgs" + ">" + this.getWritableString(this.fVMArgs) + "</" + "vmArgs" + ">");
        }
        writer.println(String.valueOf(indent) + "</launcherArgs>");
    }
}

