/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.XMLWriter;
import org.eclipse.pde.internal.build.site.PDEState;

public class FeatureGenerator
extends AbstractScriptGenerator {
    private static final String LAUNCHER_FEATURE_NAME = "org.eclipse.platform.launchers";
    private String featureId = null;
    private String productFile = null;
    private String[] pluginList = null;
    private String[] fragmentList = null;
    private String[] featureList = null;
    private ProductFile product = null;
    private boolean verify = false;

    public void generate() throws CoreException {
        List<Object> fragments;
        this.initialize();
        List<Object> plugins = this.pluginList != null ? Arrays.asList(this.pluginList) : new ArrayList();
        List<Object> features = this.featureList != null ? Arrays.asList(this.featureList) : new ArrayList();
        List<Object> list = fragments = this.fragmentList != null ? Arrays.asList(this.fragmentList) : new ArrayList();
        if (this.product != null) {
            if (this.product.useFeatures()) {
                features.addAll(this.product.getFeatures());
            } else {
                plugins.addAll(this.product.getPlugins(false));
                fragments.addAll(this.product.getFragments());
            }
        }
        try {
            this.createFeature(this.featureId, plugins, fragments, features);
        }
        catch (FileNotFoundException e) {
            Status status = new Status(4, "org.eclipse.pde.build", 23, NLS.bind((String)Messages.error_creatingFeature, (Object)e.getLocalizedMessage()), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void setProductFile(String productFile) {
        this.productFile = productFile;
    }

    public void setPluginList(String[] pluginList) {
        this.pluginList = pluginList;
    }

    public void setFeatureList(String[] featureList) {
        this.featureList = featureList;
    }

    public void setFragmentList(String[] fragmentList) {
        this.fragmentList = fragmentList;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    private void initialize() throws CoreException {
        if (this.productFile != null && !this.productFile.startsWith("${")) {
            File f;
            String productPath = this.findFile(this.productFile, false);
            if (productPath == null) {
                productPath = this.productFile;
            }
            if ((f = new File(productPath)).exists() && f.isFile()) {
                this.product = new ProductFile(productPath, null);
            } else {
                Status error = new Status(4, "org.eclipse.pde.build", 24, NLS.bind((String)Messages.exception_missingElement, (Object)this.productFile), null);
                throw new CoreException((IStatus)error);
            }
        }
    }

    protected void createFeature(String feature, List plugins, List fragments, List features) throws CoreException, FileNotFoundException {
        block27: {
            String location = "features/" + feature;
            File directory = new File(FeatureGenerator.getWorkingDirectory(), location);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            PDEState state = this.verify ? this.getSite(false).getRegistry() : null;
            BundleHelper helper = BundleHelper.getDefault();
            File file = new File(directory, "feature.xml");
            FileOutputStream output = new FileOutputStream(file);
            XMLWriter writer = null;
            try {
                writer = new XMLWriter(output);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            Hashtable<String, String> environment = new Hashtable<String, String>(3);
            parameters.put("id", feature);
            parameters.put("version", "1.0.0");
            writer.startTag("feature", parameters, true);
            boolean fragment = false;
            List configs = FeatureGenerator.getConfigInfos();
            configs.remove(Config.genericConfig());
            Iterator configIterator = configs.iterator();
            ListIterator listIter = plugins.listIterator();
            Config currentConfig = Config.genericConfig();
            while (currentConfig != null) {
                ((Dictionary)environment).put("osgi.os", currentConfig.getOs());
                ((Dictionary)environment).put("osgi.ws", currentConfig.getWs());
                ((Dictionary)environment).put("osgi.arch", currentConfig.getArch());
                while (listIter.hasNext()) {
                    boolean writeBundle;
                    String name = (String)listIter.next();
                    boolean unpack = true;
                    boolean bl = writeBundle = !this.verify;
                    if (this.verify) {
                        BundleDescription bundle = state.getResolvedBundle(name);
                        if (bundle != null) {
                            String filterSpec = bundle.getPlatformFilter();
                            if (filterSpec == null || helper.createFilter(filterSpec).match(environment)) {
                                writeBundle = true;
                                unpack = this.guessUnpack(bundle, (String[])state.getExtraData().get(new Long(bundle.getBundleId())));
                                if (currentConfig.equals(Config.genericConfig())) {
                                    listIter.remove();
                                }
                            }
                        } else {
                            BundleDescription[] bundles = state.getState().getBundles(name);
                            boolean error = true;
                            if (bundles != null && bundles.length > 0) {
                                ResolverError[] errors = state.getState().getResolverErrors(bundles[0]);
                                int i = 0;
                                while (i < errors.length) {
                                    if ((errors[i].getType() & 0x2000) != 0) {
                                        error = false;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (error) {
                                String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)name);
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
                            }
                        }
                    }
                    if (writeBundle) {
                        parameters.clear();
                        parameters.put("id", name);
                        parameters.put("version", "0.0.0");
                        parameters.put("unpack", unpack ? "true" : "false");
                        if (!currentConfig.equals(Config.genericConfig())) {
                            parameters.put("os", currentConfig.getOs());
                            parameters.put("ws", currentConfig.getWs());
                            parameters.put("arch", currentConfig.getArch());
                        }
                        if (fragment) {
                            parameters.put("fragment", "true");
                        }
                        writer.printTag("plugin", parameters, true, true, true);
                    }
                    if (fragment || listIter.hasNext() || fragments.size() <= 0) continue;
                    fragment = true;
                    listIter = fragments.listIterator();
                }
                if (!this.verify || !configIterator.hasNext()) break;
                if (plugins.size() > 0) {
                    fragment = false;
                    listIter = plugins.listIterator();
                } else {
                    listIter = fragments.listIterator();
                }
                currentConfig = (Config)configIterator.next();
            }
            boolean hasLaunchers = false;
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (name.equals(LAUNCHER_FEATURE_NAME)) {
                    hasLaunchers = true;
                }
                if (this.verify) {
                    this.getSite(false).findFeature(name, null, true);
                }
                parameters.clear();
                parameters.put("id", name);
                parameters.put("version", "0.0.0");
                writer.printTag("includes", parameters, true, true, true);
            }
            if (!hasLaunchers) {
                parameters.clear();
                parameters.put("id", LAUNCHER_FEATURE_NAME);
                parameters.put("version", "0.0.0");
                parameters.put("optional", "true");
                writer.printTag("includes", parameters, true, true, true);
            }
            writer.endTag("feature");
            writer.close();
            file = new File(directory, "build.properties");
            Properties prop = new Properties();
            prop.put("pde", "marker");
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                prop.store(stream, "Marker File so that the file gets written");
                stream.flush();
            }
            catch (IOException iOException) {
                if (stream == null) break block27;
                try {
                    stream.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
        this.reportResolutionErrors = verify;
    }

    public boolean guessUnpack(BundleDescription bundle, String[] classpath) {
        if (bundle == null) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        if (classpath.length == 0) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

