/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.value;

import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IStaleListener;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;

public abstract class ComputedValue
extends AbstractObservableValue {
    private boolean dirty;
    private boolean stale;
    private Object cachedValue;
    private IObservable[] dependencies;
    private PrivateInterface privateInterface;
    private Object valueType;
    static /* synthetic */ Class class$0;

    public ComputedValue() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz);
    }

    public ComputedValue(Object valueType) {
        this.dirty = true;
        this.stale = false;
        this.cachedValue = null;
        this.dependencies = new IObservable[0];
        this.privateInterface = new PrivateInterface();
        this.valueType = valueType;
    }

    public final Object doGetValue() {
        if (this.dirty) {
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.privateInterface, this.privateInterface, null);
            this.stale = false;
            int i = 0;
            while (i < newDependencies.length) {
                IObservable observable = newDependencies[i];
                if (observable.isStale()) {
                    this.stale = true;
                } else {
                    observable.addStaleListener(this.privateInterface);
                }
                ++i;
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedValue;
    }

    protected abstract Object calculate();

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this.privateInterface);
                observable.removeStaleListener(this.privateInterface);
                ++i;
            }
            final Object oldValue = this.cachedValue;
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return ComputedValue.this.getValue();
                }
            });
        }
    }

    public boolean isStale() {
        this.getValue();
        return this.stale;
    }

    public Object getValueType() {
        return this.valueType;
    }

    private class PrivateInterface
    implements Runnable,
    IChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        public void run() {
            ComputedValue.this.cachedValue = ComputedValue.this.calculate();
        }

        public void handleStale(IObservable source) {
            if (!ComputedValue.this.dirty && !ComputedValue.this.stale) {
                ComputedValue.this.stale = true;
                ComputedValue.this.fireStale();
            }
        }

        public void handleChange(IObservable source) {
            ComputedValue.this.makeDirty();
        }
    }
}

