/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.BaseGradientPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class WaveGradientPainter
extends BaseGradientPainter {
    public String getDisplayName() {
        return "Wave";
    }

    public BufferedImage getContourBackground(int width, int height, Shape contour, boolean isDark, ColorScheme colorScheme1, ColorScheme colorScheme2, int cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        BufferedImage mixResult = this.getMixContourBackground(width, height, contour, isDark, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        if (mixResult != null) {
            return mixResult;
        }
        BufferedImage rectangular = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D rgraphics = (Graphics2D)rectangular.getGraphics();
        rgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme interpolationScheme1 = colorScheme1;
        ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topBorderColor = SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color midBorderColor = SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color bottomBorderColor = SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color darkFillColor = SubstanceColorUtilities.getTopFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midFillColor = SubstanceColorUtilities.getMidFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color lightFillColor = SubstanceColorUtilities.getBottomFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        if (!useCyclePosAsInterpolation) {
            lightFillColor = SubstanceColorUtilities.getInterpolatedColor(interpolationScheme1.getUltraLightColor(), interpolationScheme1.getExtraLightColor(), cycleCoef);
            midFillColor = SubstanceColorUtilities.getInterpolatedColor(interpolationScheme1.getLightColor(), interpolationScheme1.getMidColor(), cycleCoef);
            darkFillColor = SubstanceColorUtilities.getInterpolatedColor(interpolationScheme1.getMidColor(), interpolationScheme1.getMidColor(), cycleCoef);
        } else {
            lightFillColor = SubstanceColorUtilities.getInterpolatedColor(interpolationScheme1.getUltraLightColor(), interpolationScheme2.getUltraLightColor(), cycleCoef);
            midFillColor = SubstanceColorUtilities.getInterpolatedColor(interpolationScheme1.getLightColor(), interpolationScheme2.getLightColor(), cycleCoef);
            darkFillColor = SubstanceColorUtilities.getInterpolatedColor(interpolationScheme1.getMidColor(), interpolationScheme2.getMidColor(), cycleCoef);
        }
        GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, lightFillColor, width / 4, height / 2, midFillColor);
        GeneralPath clipTop = new GeneralPath();
        clipTop.moveTo(0.0f, 0.0f);
        clipTop.lineTo(width, 0.0f);
        clipTop.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipTop.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipTop.lineTo(0.0f, 0.0f);
        rgraphics.setClip(clipTop);
        rgraphics.setPaint(gradientTop);
        rgraphics.fillRect(0, 0, width, height);
        GradientPaint gradientBottom = new GradientPaint(2 * width / 3, 2 * height / 3, darkFillColor, width, height, midFillColor);
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipBottom.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipBottom.lineTo(0.0f, height);
        rgraphics.setClip(clipBottom);
        rgraphics.setPaint(gradientBottom);
        rgraphics.fillRect(0, 0, width, height);
        rgraphics.setClip(null);
        GeneralPath mid = new GeneralPath();
        mid.moveTo(width, 0.0f);
        mid.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        mid.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        rgraphics.draw(mid);
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setClip(contour);
        graphics.drawImage((Image)rectangular, 0, 0, null);
        graphics.setClip(null);
        GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
        graphics.setPaint(gradientBorderTop);
        graphics.setClip(0, 0, width, height / 2);
        graphics.draw(contour);
        GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
        graphics.setPaint(gradientBorderBottom);
        graphics.setClip(0, height / 2, width, 1 + height / 2);
        graphics.draw(contour);
        return image;
    }
}

