/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetMBean;
import mx4j.loading.MLetParseException;
import mx4j.loading.MLetParser;
import mx4j.loading.MLetTag;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration {
    private String m_libraryDirectory;
    private ObjectName m_objectName;
    private MBeanServer m_server;
    private String m_defaultCodeBase;
    private ThreadLocal m_loadingOnlyLocally = new ThreadLocal();
    private ThreadLocal m_loadingWithRepository = new ThreadLocal();
    private static ThreadLocal m_loadClassOriginator = new ThreadLocal();

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] urls) {
        super(urls);
        this.m_loadingWithRepository.set(Boolean.FALSE);
        this.m_loadingOnlyLocally.set(Boolean.FALSE);
    }

    public MLet(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.m_loadingWithRepository.set(Boolean.FALSE);
        this.m_loadingOnlyLocally.set(Boolean.FALSE);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.m_loadingWithRepository.set(Boolean.FALSE);
        this.m_loadingOnlyLocally.set(Boolean.FALSE);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_server = server;
        this.m_objectName = name == null ? new ObjectName(this.m_server.getDefaultDomain(), "service", "MLet") : name;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("MLet service " + this.m_objectName + " preRegistered successfully");
        }
        return this.m_objectName;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            this.m_server = null;
            logger.warn("MLet service " + this.m_objectName + " was not registered");
        } else if (logger.isEnabledFor(0)) {
            logger.trace("MLet service " + this.m_objectName + " postRegistered successfully");
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug("MLet service " + this.m_objectName + " preDeregistered successfully");
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug("MLet service " + this.m_objectName + " postDeregistered successfully");
        }
    }

    public void addURL(String url) throws ServiceNotFoundException {
        this.addURL(this.createURL(url));
    }

    public void addURL(URL url) {
        Logger logger = this.getLogger();
        if (!Arrays.asList(this.getURLs()).contains(url)) {
            if (logger.isEnabledFor(20)) {
                logger.info("Adding URL to this MLet (" + this.m_objectName + ") classpath: " + url);
            }
            super.addURL(url);
        } else if (logger.isEnabledFor(20)) {
            logger.info("URL already present in this MLet (" + this.m_objectName + ") classpath: " + url);
        }
    }

    public Class loadClass(String name, ClassLoaderRepository repository) throws ClassNotFoundException {
        if (repository == null) {
            Class cls = this.loadClassLocally(name);
            return cls;
        }
        try {
            Class cls = this.loadClassLocally(name);
            return cls;
        }
        catch (ClassNotFoundException x) {
            Class cls = this.findClassInRepository(name, repository);
            return cls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassLocally(String name) throws ClassNotFoundException {
        try {
            this.m_loadingOnlyLocally.set(Boolean.TRUE);
            Class<?> clazz = this.loadClass(name);
            Object var4_3 = null;
            this.m_loadingOnlyLocally.set(Boolean.FALSE);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_loadingOnlyLocally.set(Boolean.FALSE);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.m_loadingWithRepository.get() == Boolean.TRUE) {
            throw new ClassNotFoundException(name);
        }
        MLet originator = (MLet)m_loadClassOriginator.get();
        if (originator == null) {
            originator = this;
            m_loadClassOriginator.set(originator);
        }
        try {
            try {
                Class clazz;
                Logger logger = this.getLogger();
                if (logger.isEnabledFor(20)) {
                    logger.info("Finding class " + name + "...");
                }
                try {
                    Class cls = this.findClassLocally(name);
                    if (logger.isEnabledFor(20)) {
                        logger.info("Class " + name + " found in this MLet (" + this.m_objectName + ") classpath: " + this);
                    }
                    clazz = cls;
                }
                catch (ClassNotFoundException x) {
                    Class clazz2;
                    if (this.m_loadingOnlyLocally.get() == Boolean.TRUE) {
                        throw x;
                    }
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Class " + name + " not found in this MLet (" + this.m_objectName + ") classpath: " + this + ", trying the ClassLoaderRepository...", x);
                    }
                    try {
                        this.m_loadingWithRepository.set(Boolean.TRUE);
                        ClassLoaderRepository repository = MBeanServerFactory.getClassLoaderRepository(this.m_server);
                        Class cls = this.findClassInRepository(name, repository);
                        if (logger.isEnabledFor(20)) {
                            logger.info("Class " + name + " found with the ClassLoaderRepository " + repository);
                        }
                        clazz2 = cls;
                        Object var10_19 = null;
                        this.m_loadingWithRepository.set(Boolean.FALSE);
                    }
                    catch (ClassNotFoundException xx) {
                        if (logger.isEnabledFor(10)) {
                            logger.debug("Class " + name + " not found in the ClassLoaderRepository, trying the DefaultLoaderRepository...", xx);
                        }
                        ClassLoaderRepository repository = MBeanServerFactory.getClassLoaderRepository(null);
                        Class cls = this.findClassInRepository(name, repository);
                        if (logger.isEnabledFor(20)) {
                            logger.info("Class " + name + " found with the DefaultLoaderRepository " + repository);
                        }
                        Class clazz3 = cls;
                        Object var10_20 = null;
                        this.m_loadingWithRepository.set(Boolean.FALSE);
                        Object var12_12 = null;
                        if (originator == this) {
                            m_loadClassOriginator.set(null);
                        }
                        return clazz3;
                        {
                            catch (ClassNotFoundException xxx) {
                                try {
                                    if (logger.isEnabledFor(10)) {
                                        logger.debug("Class " + name + " not found in the DefaultLoaderRepository, giving up", xxx);
                                    }
                                    throw new MLetClassNotFoundError();
                                }
                                catch (Throwable throwable) {
                                    Object var10_21 = null;
                                    this.m_loadingWithRepository.set(Boolean.FALSE);
                                    throw throwable;
                                }
                            }
                        }
                    }
                    Object var12_11 = null;
                    if (originator == this) {
                        m_loadClassOriginator.set(null);
                    }
                    return clazz2;
                }
                Object var12_10 = null;
                if (originator == this) {
                    m_loadClassOriginator.set(null);
                }
                return clazz;
            }
            catch (MLetClassNotFoundError x) {
                if (originator == this) {
                    throw new ClassNotFoundException(name);
                }
                throw x;
            }
        }
        catch (Throwable throwable) {
            block27: {
                Object var12_13 = null;
                if (originator != this) break block27;
                m_loadClassOriginator.set(null);
            }
            throw throwable;
        }
    }

    private Class findClassLocally(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private Class findClassInRepository(String name, ClassLoaderRepository repository) throws ClassNotFoundException {
        return repository.loadClassWithout(this, name);
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        return this.getMBeansFromURL(this.createURL(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        Set set;
        if (url == null) {
            throw new ServiceNotFoundException("Cannot load MBeans from null URL");
        }
        Logger logger = this.getLogger();
        String urlString = url.toString();
        this.m_defaultCodeBase = urlString.substring(0, urlString.lastIndexOf(47) + 1);
        InputStream is = null;
        try {
            try {
                is = url.openStream();
                if (logger.isEnabledFor(20)) {
                    logger.info("MLet " + this.m_objectName + ", parsing MLET URL " + url);
                }
                set = this.getMBeansFromURL(is);
                Object var7_7 = null;
                if (is == null) return set;
            }
            catch (IOException x) {
                if (!logger.isEnabledFor(10)) throw new ServiceNotFoundException(x.toString());
                logger.debug("MLet " + this.m_objectName + ", cannot open MLET URL", x);
                throw new ServiceNotFoundException(x.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return set;
        }
        is.close();
        return set;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private String getDefaultCodeBase() {
        block2: {
            if (this.m_defaultCodeBase != null) break block2;
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir);
            try {
                String url = f.toURL().toString();
                this.m_defaultCodeBase = url.substring(0, url.lastIndexOf(47) + 1);
            }
            catch (MalformedURLException ignored) {
                this.m_defaultCodeBase = "";
            }
        }
        return this.m_defaultCodeBase;
    }

    /*
     * Loose catch block
     */
    private Set getMBeansFromURL(InputStream is) throws ServiceNotFoundException {
        ByteArrayOutputStream baos;
        block11: {
            Logger logger = this.getLogger();
            baos = new ByteArrayOutputStream();
            BufferedOutputStream os = new BufferedOutputStream(baos);
            this.readFromAndWriteTo(is, os);
            Object var7_5 = null;
            try {
                os.close();
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (IOException x) {
                    logger.error("Cannot read input stream", x);
                    throw new ServiceNotFoundException(x.toString());
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    os.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            HashSet<Object> mbeans = new HashSet<Object>();
            MLetParser parser = new MLetParser();
            List tags = parser.parse(new String(baos.toByteArray()));
            int i = 0;
            while (i < tags.size()) {
                MLetTag tag = (MLetTag)tags.get(i);
                URL[] urls = tag.getURLs(this.getDefaultCodeBase());
                int j = 0;
                while (j < urls.length) {
                    this.addURL(urls[j]);
                    ++j;
                }
                Object obj = this.createMBean(tag);
                mbeans.add(obj);
                ++i;
            }
            return mbeans;
        }
        catch (MLetParseException x) {
            throw new ServiceNotFoundException(x.toString());
        }
    }

    protected String findLibrary(String libraryName) {
        InputStream is;
        String sysLibraryName = System.mapLibraryName(libraryName);
        String path = this.loadResource(sysLibraryName, is = this.getResourceAsStream(sysLibraryName.replace(File.separatorChar, '/')));
        if (path != null) {
            return path;
        }
        StringBuffer sysBuff = new StringBuffer();
        sysBuff.append(this.removeWhiteSpace(System.getProperty("os.name").trim())).append(File.separator);
        sysBuff.append(this.removeWhiteSpace(System.getProperty("os.arch").trim())).append(File.separator);
        sysBuff.append(this.removeWhiteSpace(System.getProperty("os.version").trim())).append(File.separator);
        sysBuff.append("lib").append(File.separator).append(sysLibraryName);
        path = this.loadResource(sysBuff.toString(), is);
        if (path != null) {
            return path;
        }
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.library.path").trim(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String filePath = tokenizer.nextToken().trim() + File.separator + sysLibraryName;
            try {
                path = this.loadResource(filePath, new FileInputStream(filePath));
                if (path == null) continue;
                return path;
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadResource(String sysLibraryName, InputStream is) {
        block10: {
            String string;
            BufferedOutputStream os;
            block9: {
                if (is == null) break block10;
                File file = null;
                file = this.getLibraryDirectory() == null ? new File(sysLibraryName) : new File(this.getLibraryDirectory(), sysLibraryName);
                os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(file));
                    is = new BufferedInputStream(is);
                    if (file.exists()) {
                        file.delete();
                    }
                    this.readFromAndWriteTo(is, os);
                    string = file.getCanonicalPath();
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {}
                }
                is.close();
            }
            if (os != null) {
                ((OutputStream)os).close();
            }
            return string;
        }
        return null;
    }

    private void readFromAndWriteTo(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[65536];
        int read = -1;
        while ((read = is.read(buffer)) >= 0) {
            os.write(buffer, 0, read);
        }
        Object var3_3 = null;
    }

    private String removeWhiteSpace(String word) {
        int j = word.indexOf(32);
        if (j < 0) {
            return word;
        }
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (j >= 0) {
            j = (word = word.substring(i)).indexOf(32);
            temp = j >= 0 ? temp.append(word.substring(0, j)) : temp.append(word.substring(0));
            i = j + 1;
        }
        return temp.toString();
    }

    public String getLibraryDirectory() {
        return this.m_libraryDirectory;
    }

    public void setLibraryDirectory(String libdir) {
        this.m_libraryDirectory = libdir;
    }

    private Object createMBean(MLetTag tag) throws ServiceNotFoundException {
        if (this.m_server == null) {
            throw new ServiceNotFoundException("MLet not registered on the MBeanServer");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("MLet " + this.m_objectName + ", creating MBean from\n" + tag);
        }
        try {
            Object mbean = null;
            if (tag.getObject() != null) {
                String name = tag.getObject();
                InputStream is = this.getResourceAsStream(name);
                if (is == null) {
                    throw new ServiceNotFoundException("Cannot find MBean " + name + " in this MLet (" + this.m_objectName + ") classpath");
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedOutputStream os = new BufferedOutputStream(baos);
                this.readFromAndWriteTo(bis, os);
                ObjectInputStream ois = this.m_server.deserialize(this.m_objectName, baos.toByteArray());
                mbean = ois.readObject();
            } else {
                String clsName = tag.getCode();
                Object[] args = tag.getArguments();
                String[] params = tag.getSignature();
                mbean = this.m_server.instantiate(clsName, this.m_objectName, args, params);
            }
            ObjectName objectName = tag.getObjectName();
            ObjectInstance instance = this.m_server.registerMBean(mbean, objectName);
            return instance;
        }
        catch (Throwable t) {
            return t;
        }
    }

    private URL createURL(String urlString) throws ServiceNotFoundException {
        try {
            URL url = new URL(urlString);
            return url;
        }
        catch (MalformedURLException x) {
            throw new ServiceNotFoundException(x.toString());
        }
    }

    private static class MLetClassNotFoundError
    extends Error {
        private MLetClassNotFoundError() {
        }
    }
}

