/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.SashFormData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

class SashFormLayout
extends Layout {
    SashFormLayout() {
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl) {
        int n4;
        SashForm sashForm = (SashForm)composite;
        Control[] controlArray = sashForm.getControls(true);
        int n5 = 0;
        int n6 = 0;
        if (controlArray.length == 0) {
            if (n2 != -1) {
                n5 = n2;
            }
            if (n3 != -1) {
                n6 = n3;
            }
            return new Point(n5, n6);
        }
        boolean bl2 = sashForm.getOrientation() == 512;
        int n7 = 0;
        int n8 = 0;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Point point;
            if (bl2) {
                point = controlArray[i2].computeSize(n2, -1, bl);
                if (point.y > n8) {
                    n7 = i2;
                    n8 = point.y;
                }
                n5 = Math.max(n5, point.x);
                continue;
            }
            point = controlArray[i2].computeSize(-1, n3, bl);
            if (point.x > n8) {
                n7 = i2;
                n8 = point.x;
            }
            n6 = Math.max(n6, point.y);
        }
        long[] lArray = new long[controlArray.length];
        long l2 = 0L;
        for (n4 = 0; n4 < controlArray.length; ++n4) {
            Object object = controlArray[n4].getLayoutData();
            if (object != null && object instanceof SashFormData) {
                lArray[n4] = ((SashFormData)object).weight;
            } else {
                object = new SashFormData();
                controlArray[n4].setLayoutData(object);
                lArray[n4] = 13108L;
                ((SashFormData)object).weight = 13108L;
            }
            l2 += lArray[n4];
        }
        if (lArray[n7] > 0L) {
            int n9 = n4 = sashForm.sashes.length > 0 ? sashForm.SASH_WIDTH + sashForm.sashes[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
            if (bl2) {
                n6 += (int)(l2 * (long)n8 / lArray[n7]) + (controlArray.length - 1) * n4;
            } else {
                n5 += (int)(l2 * (long)n8 / lArray[n7]) + (controlArray.length - 1) * n4;
            }
        }
        n5 += sashForm.getBorderWidth() * 2;
        n6 += sashForm.getBorderWidth() * 2;
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n6 = n3;
        }
        return new Point(n5, n6);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean bl) {
        int n2;
        int n3;
        Sash[] sashArray;
        SashForm sashForm = (SashForm)composite;
        Rectangle rectangle = sashForm.getClientArea();
        if (rectangle.width <= 1 || rectangle.height <= 1) {
            return;
        }
        Control[] controlArray = sashForm.getControls(true);
        if (sashForm.controls.length == 0 && controlArray.length == 0) {
            return;
        }
        Control[] controlArray2 = sashForm.controls = controlArray;
        if (sashForm.maxControl != null && !sashForm.maxControl.isDisposed()) {
            for (int i2 = 0; i2 < controlArray2.length; ++i2) {
                if (controlArray2[i2] != sashForm.maxControl) {
                    controlArray2[i2].setBounds(-200, -200, 0, 0);
                    continue;
                }
                controlArray2[i2].setBounds(rectangle);
            }
            return;
        }
        if (sashForm.sashes.length < controlArray2.length - 1) {
            sashArray = new Sash[controlArray2.length - 1];
            System.arraycopy(sashForm.sashes, 0, sashArray, 0, sashForm.sashes.length);
            for (n3 = sashForm.sashes.length; n3 < sashArray.length; ++n3) {
                sashArray[n3] = new Sash(sashForm, sashForm.sashStyle);
                sashArray[n3].setBackground(sashForm.background);
                sashArray[n3].setForeground(sashForm.foreground);
                sashArray[n3].addListener(13, sashForm.sashListener);
            }
            sashForm.sashes = sashArray;
        }
        if (sashForm.sashes.length > controlArray2.length - 1) {
            if (controlArray2.length == 0) {
                for (int i3 = 0; i3 < sashForm.sashes.length; ++i3) {
                    sashForm.sashes[i3].dispose();
                }
                sashForm.sashes = new Sash[0];
            } else {
                sashArray = new Sash[controlArray2.length - 1];
                System.arraycopy(sashForm.sashes, 0, sashArray, 0, sashArray.length);
                for (n3 = controlArray2.length - 1; n3 < sashForm.sashes.length; ++n3) {
                    sashForm.sashes[n3].dispose();
                }
                sashForm.sashes = sashArray;
            }
        }
        if (controlArray2.length == 0) {
            return;
        }
        Sash[] sashArray2 = sashForm.sashes;
        long[] lArray = new long[controlArray2.length];
        long l2 = 0L;
        for (n2 = 0; n2 < controlArray2.length; ++n2) {
            Object object = controlArray2[n2].getLayoutData();
            if (object != null && object instanceof SashFormData) {
                lArray[n2] = ((SashFormData)object).weight;
            } else {
                object = new SashFormData();
                controlArray2[n2].setLayoutData(object);
                lArray[n2] = 13108L;
                ((SashFormData)object).weight = 13108L;
            }
            l2 += lArray[n2];
        }
        int n4 = n2 = sashArray2.length > 0 ? sashForm.SASH_WIDTH + sashArray2[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
        if (sashForm.getOrientation() == 256) {
            int n5 = (int)(lArray[0] * (long)(rectangle.width - sashArray2.length * n2) / l2);
            int n6 = rectangle.x;
            controlArray2[0].setBounds(n6, rectangle.y, n5, rectangle.height);
            n6 += n5;
            for (int i4 = 1; i4 < controlArray2.length - 1; ++i4) {
                sashArray2[i4 - 1].setBounds(n6, rectangle.y, n2, rectangle.height);
                n5 = (int)(lArray[i4] * (long)(rectangle.width - sashArray2.length * n2) / l2);
                controlArray2[i4].setBounds(n6 += n2, rectangle.y, n5, rectangle.height);
                n6 += n5;
            }
            if (controlArray2.length > 1) {
                sashArray2[sashArray2.length - 1].setBounds(n6, rectangle.y, n2, rectangle.height);
                n5 = rectangle.width - (n6 += n2);
                controlArray2[controlArray2.length - 1].setBounds(n6, rectangle.y, n5, rectangle.height);
            }
        } else {
            int n7 = (int)(lArray[0] * (long)(rectangle.height - sashArray2.length * n2) / l2);
            int n8 = rectangle.y;
            controlArray2[0].setBounds(rectangle.x, n8, rectangle.width, n7);
            n8 += n7;
            for (int i5 = 1; i5 < controlArray2.length - 1; ++i5) {
                sashArray2[i5 - 1].setBounds(rectangle.x, n8, rectangle.width, n2);
                n7 = (int)(lArray[i5] * (long)(rectangle.height - sashArray2.length * n2) / l2);
                controlArray2[i5].setBounds(rectangle.x, n8 += n2, rectangle.width, n7);
                n8 += n7;
            }
            if (controlArray2.length > 1) {
                sashArray2[sashArray2.length - 1].setBounds(rectangle.x, n8, rectangle.width, n2);
                n7 = rectangle.height - (n8 += n2);
                controlArray2[controlArray2.length - 1].setBounds(rectangle.x, n8, rectangle.width, n7);
            }
        }
    }
}

