/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;

public class Path
extends Resource {
    public GeneralPath handle;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = new GeneralPath();
        if (this.handle == null) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f5 < 0.0f) {
            f3 += f5;
            f5 = -f5;
        }
        if (f4 == 0.0f || f5 == 0.0f || f7 == 0.0f) {
            return;
        }
        this.handle.append(new Arc2D.Float(f2, f3, f4, f5, f6, f7, 0), true);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.handle.append(path.handle, true);
    }

    public void addRectangle(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.append(new Rectangle2D.Float(f2, f3, f4, f5), true);
    }

    public void addString(String string, float f2, float f3, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = font.handle.createGlyphVector(fontRenderContext, string);
        LineMetrics lineMetrics = font.handle.getLineMetrics(string, fontRenderContext);
        this.handle.append(glyphVector.getOutline(f2, f3 + lineMetrics.getAscent()), true);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.closePath();
    }

    public boolean contains(float f2, float f3, GC gC, boolean bl) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return this.handle.contains(f2, f3);
    }

    public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.curveTo(f2, f3, f4, f5, f6, f7);
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getBounds(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        Rectangle2D rectangle2D = this.handle.getBounds2D();
        fArray[0] = (float)rectangle2D.getX();
        fArray[1] = (float)rectangle2D.getY();
        fArray[2] = (float)rectangle2D.getWidth();
        fArray[3] = (float)rectangle2D.getHeight();
    }

    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        Point2D point2D = this.handle.getCurrentPoint();
        fArray[0] = (float)point2D.getX();
        fArray[1] = (float)point2D.getY();
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        float[] fArray = new float[6];
        Object object = this.handle.getPathIterator(null);
        while (!object.isDone()) {
            switch (object.currentSegment(fArray)) {
                case 0: {
                    arrayList.add(new Byte(1));
                    break;
                }
                case 1: {
                    arrayList.add(new Byte(2));
                    arrayList2.add(new Float(fArray[0]));
                    arrayList2.add(new Float(fArray[1]));
                    break;
                }
                case 2: {
                    arrayList.add(new Byte(3));
                    arrayList2.add(new Float(fArray[0]));
                    arrayList2.add(new Float(fArray[1]));
                    arrayList2.add(new Float(fArray[2]));
                    arrayList2.add(new Float(fArray[3]));
                    break;
                }
                case 3: {
                    arrayList.add(new Byte(4));
                    arrayList2.add(new Float(fArray[0]));
                    arrayList2.add(new Float(fArray[1]));
                    arrayList2.add(new Float(fArray[2]));
                    arrayList2.add(new Float(fArray[3]));
                    arrayList2.add(new Float(fArray[4]));
                    arrayList2.add(new Float(fArray[5]));
                    break;
                }
                case 4: {
                    arrayList.add(new Byte(5));
                }
            }
            object.next();
        }
        object = new byte[arrayList.size()];
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            object[i2] = (Byte)arrayList.get(i2);
        }
        float[] fArray2 = new float[arrayList2.size()];
        for (int i3 = arrayList2.size() - 1; i3 >= 0; --i3) {
            fArray2[i3] = ((Float)arrayList.get(i3)).floatValue();
        }
        PathData pathData = new PathData();
        pathData.types = (byte[])object;
        pathData.points = fArray2;
        return pathData;
    }

    public void lineTo(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.lineTo(f2, f3);
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public void moveTo(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.moveTo(f2, f3);
    }

    public void quadTo(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.quadTo(f2, f3, f4, f5);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

