/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.internal.swing.JExpandPaneLayout;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;

public class JExpandPane
extends JPanel {
    protected JExpandPaneLayout expandPaneLayout = new JExpandPaneLayout();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JExpandPane() {
        this.setBackground(UIManager.getColor("desktop"));
        this.setLayout(this.expandPaneLayout);
    }

    public void addExpandPaneItem(String string, Icon icon, Component component) {
        this.add((Component)new JExpandPaneItem(string, icon, component), this.getComponentCount());
    }

    public void insertExpandPaneItem(String string, Icon icon, Component component, int n2) {
        this.add((Component)new JExpandPaneItem(string, icon, component), n2);
    }

    public void removeExpandPaneItem(Component component) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((JExpandPaneItem)this.getComponent(i2)).getComponent() != component) continue;
            this.remove(i2);
            this.revalidate();
            this.repaint();
            break;
        }
    }

    public void setComponentExpanded(Component component, boolean bl) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JExpandPaneItem jExpandPaneItem = (JExpandPaneItem)this.getComponent(i2);
            if (jExpandPaneItem.getComponent() != component) continue;
            jExpandPaneItem.setExpanded(bl);
            break;
        }
    }

    public void setIndexExpanded(int n2, boolean bl) {
        if (n2 < 0 || n2 >= this.getComponentCount()) {
            return;
        }
        ((JExpandPaneItem)this.getComponent(n2)).setExpanded(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JExpandPane.class$((String)"javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JExpandPane.class$((String)"javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JExpandPane.class$((String)"javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public JExpandPaneItem getExpandItem(int n2) {
        return (JExpandPaneItem)this.getComponent(n2);
    }

    public JExpandPaneItem getExpandItem(Component component) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JExpandPaneItem jExpandPaneItem = (JExpandPaneItem)this.getComponent(i2);
            if (jExpandPaneItem.getComponent() != component) continue;
            return jExpandPaneItem;
        }
        return null;
    }

    public void setSpacing(int n2) {
        this.expandPaneLayout.setSpacing(n2);
    }

    public int getSpacing() {
        return this.expandPaneLayout.getSpacing();
    }

    public static class JExpandPaneItem
    extends JPanel {
        protected Component component;
        protected JToolBar titleBar;
        protected JSeparator separator;
        protected JLabel titleLabel;
        protected JLabel expansionLabel;
        protected JComponent contentPane;
        protected static final Icon EXPANDED_ICON = UIManager.getIcon("Tree.expandedIcon");
        protected static final Icon COLLAPSED_ICON = UIManager.getIcon("Tree.collapsedIcon");
        protected MouseListener expansionMouseListener = new MouseAdapter(this){
            final /* synthetic */ JExpandPaneItem this$1;
            {
                this.this$1 = jExpandPaneItem;
            }

            public void mouseReleased(MouseEvent e2) {
                if (!new Rectangle(new Point(0, 0), e2.getComponent().getSize()).contains(e2.getPoint())) {
                    return;
                }
                this.this$1.setExpanded(!this.this$1.isExpanded());
            }
        };

        public boolean isOpaque() {
            return this.getParent().isOpaque();
        }

        public JExpandPaneItem(String title, Icon icon, Component component) {
            super(new BorderLayout(0, 0));
            this.component = component;
            this.setBorder(LookAndFeelUtils.getStandardBorder());
            this.titleBar = new JToolBar();
            this.titleBar.setFloatable(false);
            this.titleBar.setLayout(new BorderLayout(0, 0));
            this.expansionLabel = new JLabel(COLLAPSED_ICON);
            this.expansionLabel.setBorder(new EmptyBorder(2, 5, 2, 5));
            this.titleBar.add((Component)this.expansionLabel, this.getComponentOrientation().isLeftToRight() ? "West" : "East");
            this.titleLabel = new JLabel(title, icon, 10);
            this.titleBar.add((Component)this.titleLabel, "Center");
            this.titleBar.addMouseListener(this.expansionMouseListener);
            this.titleBar.setCursor(Cursor.getPredefinedCursor(12));
            this.add((Component)this.titleBar, "North");
            this.separator = new JSeparator();
            this.add((Component)this.separator, "Center");
            this.contentPane = new JPanel(new BorderLayout(0, 0));
            this.contentPane.setOpaque(false);
            this.contentPane.add(component, "Center");
            this.separator.setVisible(false);
            this.contentPane.setVisible(false);
            this.add((Component)this.contentPane, "South");
        }

        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
        }

        public Component getComponent() {
            return this.component;
        }

        public void setIcon(Icon icon) {
            this.titleLabel.setIcon(icon);
        }

        public Icon getIcon() {
            return this.titleLabel.getIcon();
        }

        public void setExpanded(boolean isExpanded) {
            this.expansionLabel.setIcon(isExpanded ? EXPANDED_ICON : COLLAPSED_ICON);
            this.separator.setVisible(isExpanded);
            this.contentPane.setVisible(isExpanded);
            this.contentPane.revalidate();
            this.repaint();
        }

        public boolean isExpanded() {
            return this.contentPane.isVisible();
        }

        public Dimension getTitleBarSize() {
            return this.titleBar.getSize();
        }

        public String getText() {
            return this.titleLabel.getText();
        }

        public void setText(String text) {
            this.titleLabel.setText(text);
        }
    }
}

