/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.swt.internal.swing.DefaultMutableTreeTableNode;
import org.eclipse.swt.internal.swing.DefaultTreeTableCellRenderer;
import org.eclipse.swt.internal.swing.JTreeTable;
import org.eclipse.swt.internal.swing.TreeTableCellRenderer;
import org.eclipse.swt.internal.swing.TreeTableNode;

public class JTreeTable
extends JPanel
implements Scrollable {
    protected JTable table;
    protected JTree tree;
    protected ListSelectionModel tableSelectionModel = new DefaultListSelectionModel(){

        public void addSelectionInterval(int index0, int index1) {
            boolean isReversed;
            super.addSelectionInterval(index0, index1);
            boolean bl = isReversed = index0 > index1;
            if (isReversed) {
                int tmp = index1;
                index1 = index0;
                index0 = tmp;
            }
            TreePath[] treePaths = new TreePath[index1 + 1 - index0];
            int i2 = index0;
            while (i2 <= index1) {
                treePaths[i2 - index0] = JTreeTable.this.tree.getPathForRow(isReversed ? index1 + index0 - i2 : i2);
                ++i2;
            }
            JTreeTable.this.tree.getSelectionModel().addSelectionPaths(treePaths);
        }

        public void clearSelection() {
            super.clearSelection();
            JTreeTable.this.tree.getSelectionModel().clearSelection();
        }

        public void setSelectionInterval(int index0, int index1) {
            boolean isReversed;
            super.setSelectionInterval(index0, index1);
            boolean bl = isReversed = index0 > index1;
            if (isReversed) {
                int tmp = index1;
                index1 = index0;
                index0 = tmp;
            }
            TreePath[] treePaths = new TreePath[index1 + 1 - index0];
            int i2 = index0;
            while (i2 <= index1) {
                treePaths[i2 - index0] = JTreeTable.this.tree.getPathForRow(isReversed ? index1 + index0 - i2 : i2);
                ++i2;
            }
            JTreeTable.this.tree.getSelectionModel().setSelectionPaths(treePaths);
        }

        public void removeSelectionInterval(int index0, int index1) {
            boolean isReversed;
            super.removeSelectionInterval(index0, index1);
            boolean bl = isReversed = index0 > index1;
            if (isReversed) {
                int tmp = index1;
                index1 = index0;
                index0 = tmp;
            }
            if (index1 + 1 - index0 < 0) {
                return;
            }
            TreePath[] treePaths = new TreePath[index1 + 1 - index0];
            int i2 = index0;
            while (i2 <= index1) {
                treePaths[i2 - index0] = JTreeTable.this.tree.getPathForRow(isReversed ? index1 + index0 - i2 : i2);
                ++i2;
            }
            JTreeTable.this.tree.getSelectionModel().removeSelectionPaths(treePaths);
        }

        public int getMinSelectionIndex() {
            return JTreeTable.this.tree.getSelectionModel().getMinSelectionRow();
        }

        public int getMaxSelectionIndex() {
            return JTreeTable.this.tree.getSelectionModel().getMaxSelectionRow();
        }

        public boolean isSelectedIndex(int index) {
            return JTreeTable.this.tree.getSelectionModel().isRowSelected(index);
        }
    };
    protected TreeTableModel tableModel = new TreeTableModel();
    protected TableCellRenderer tableCellRenderer = new TableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TreePath path = JTreeTable.this.tree.getPathForRow(row);
            if (column == 0) {
                class FirstColumnComponent
                extends JComponent
                implements DefaultTreeTableCellRenderer.CellPainter {
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ TreePath val$path;

                    FirstColumnComponent(2 var1_1, TreePath treePath) {
                        this.this$1 = var1_1;
                        this.val$path = treePath;
                    }

                    public void paintComponent(Graphics g2) {
                        if (2.access$0(this.this$1).renderer instanceof DefaultTreeTableCellRenderer) {
                            ((DefaultTreeTableCellRenderer)2.access$0(this.this$1).renderer).paintComponent(this, g2);
                        } else {
                            this.paintCell(g2);
                        }
                    }

                    public void paintCell(Graphics g2) {
                        int row = 2.access$0(this.this$1).tree.getRowForPath(this.val$path);
                        Rectangle rowBounds = 2.access$0(this.this$1).tree.getRowBounds(row);
                        rowBounds.width += rowBounds.x;
                        rowBounds.x = 0;
                        g2 = g2.create();
                        int width = 2.access$0(this.this$1).table.getColumnModel().getColumn(0).getWidth();
                        g2.clipRect(0, 0, width, rowBounds.height);
                        if (2.access$0(this.this$1).isFullLineSelection() && 2.access$0(this.this$1).table.isRowSelected(row)) {
                            g2.setColor(2.access$0(this.this$1).table.getSelectionBackground());
                            g2.fillRect(0, 0, width, rowBounds.height);
                        }
                        g2.translate(0, -rowBounds.y);
                        2.access$0(this.this$1).tree.paint(g2);
                        g2.dispose();
                    }
                }
                return new FirstColumnComponent(this, path);
            }
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (node instanceof TreeTableNode) {
                value = ((TreeTableNode)node).getUserObject(table.convertColumnIndexToModel(column));
            }
            hasFocus = false;
            if (!JTreeTable.this.isFullLineSelection()) {
                isSelected = false;
            }
            return JTreeTable.this.renderer.getTreeTableCellRendererComponent(JTreeTable.this, value, isSelected, JTreeTable.this.tree.isExpanded(row), node.isLeaf(), row, column, hasFocus);
        }

        static /* synthetic */ JTreeTable access$0(2 var0) {
            return var0.JTreeTable.this;
        }
    };
    protected boolean isGridVisible;
    protected TreeTableCellRenderer renderer = new DefaultTreeTableCellRenderer();
    protected volatile boolean isEnclosingScrollPaneConfigured;
    protected boolean isFullLineSelection = false;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;

    public JTreeTable(TreeModel treeModel) {
        this();
        this.setModel(treeModel);
    }

    public JTreeTable() {
        super(new BorderLayout(0, 0));
        this.table = new InternalTable();
        this.table.setTableHeader(this.createDefaultTableHeader());
        this.add((Component)this.table, "Center");
        this.tree = new JTree(){

            public boolean hasFocus() {
                if (JTreeTable.this == null) {
                    return false;
                }
                return JTreeTable.this.table.hasFocus();
            }
        };
        this.tree.setOpaque(false);
        this.tree.setCellRenderer(new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof TreeTableNode) {
                    if (JTreeTable.this.getColumnCount() > 0) {
                        value = ((TreeTableNode)value).getUserObject(JTreeTable.this.convertColumnIndexToModel(0));
                    }
                } else if (value instanceof DefaultMutableTreeNode) {
                    value = ((DefaultMutableTreeNode)value).getUserObject();
                }
                return JTreeTable.this.renderer.getTreeTableCellRendererComponent(JTreeTable.this, value, selected, expanded, leaf, row, 0, !JTreeTable.this.isFullLineSelection() && hasFocus);
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            protected int countNodeElements(TreePath treePath) {
                int count = 1;
                if (JTreeTable.this.tree.hasBeenExpanded(treePath)) {
                    TreeNode node = (TreeNode)treePath.getLastPathComponent();
                    Object[] path = treePath.getPath();
                    int i2 = 0;
                    while (i2 < node.getChildCount()) {
                        Object[] childPath = new Object[path.length + 1];
                        System.arraycopy(path, 0, childPath, 0, path.length);
                        childPath[path.length] = node.getChildAt(i2);
                        count += this.countNodeElements(new TreePath(childPath));
                        ++i2;
                    }
                }
                return count;
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                int collapsedCount = this.countNodeElements(path) - 1;
                if (collapsedCount != 0) {
                    int firstRow = JTreeTable.this.tree.getRowForPath(path);
                    JTreeTable.this.tableModel.fireTableChanged(new TableModelEvent(JTreeTable.this.tableModel, firstRow + 1, firstRow + collapsedCount, -1, -1));
                }
            }

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                int expandedCount = this.countNodeElements(path) - 1;
                if (expandedCount != 0) {
                    int firstRow = JTreeTable.this.tree.getRowForPath(path);
                    JTreeTable.this.tableModel.fireTableChanged(new TableModelEvent(JTreeTable.this.tableModel, firstRow + 1, firstRow + expandedCount, -1, 1));
                }
            }
        });
        this.table.setModel(this.tableModel);
        this.setGridVisible(true);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.getColumnModel());
    }

    public void setGridVisible(boolean bl) {
        this.isGridVisible = bl;
        this.table.setIntercellSpacing(bl ? new Dimension(1, 1) : new Dimension(0, 0));
        this.table.setShowHorizontalLines(bl);
        this.table.setShowVerticalLines(bl);
        this.repaint();
    }

    public boolean isGridVisible() {
        return this.isGridVisible;
    }

    public void setModel(TreeModel treeModel) {
        this.tree.setModel(treeModel);
    }

    public TreeModel getModel() {
        return this.tree.getModel();
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public void setCellRenderer(TreeTableCellRenderer treeTableCellRenderer) {
        this.renderer = treeTableCellRenderer;
    }

    public TreeTableCellRenderer getTreeTableCellRenderer() {
        return this.renderer;
    }

    public TreeTableCellRenderer getCellRenderer() {
        return this.renderer;
    }

    protected JTree getInnerTree() {
        return this.tree;
    }

    protected JTable getInnerTable() {
        return this.table;
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.table.getColumnModel();
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        this.table.setColumnModel(tableColumnModel);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.table.getPreferredScrollableViewportSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        return this.table.getScrollableUnitIncrement(rectangle, n2, n3);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        return this.table.getScrollableBlockIncrement(rectangle, n2, n3);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        if (this.isEnclosingScrollPaneConfigured) {
            return;
        }
        this.isEnclosingScrollPaneConfigured = true;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jViewport.setBackground(this.getBackground());
            JTableHeader jTableHeader = this.getTableHeader();
            jScrollPane.setColumnHeaderView(jTableHeader);
            jTableHeader.setVisible(false);
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(null);
        }
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    public void setFullLineSelection(boolean bl) {
        this.isFullLineSelection = bl;
        this.repaint();
    }

    public boolean isFullLineSelection() {
        return this.isFullLineSelection;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree.getSelectionModel();
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public void selectAll() {
        int n2 = this.tree.getRowCount();
        if (n2 > 0) {
            this.tree.setSelectionInterval(0, n2 - 1);
        }
    }

    public void expandPath(TreePath treePath) {
        this.tree.expandPath(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.tree.collapsePath(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        return this.tree.isExpanded(treePath);
    }

    public void setSelectionMode(int n2) {
        this.tree.getSelectionModel().setSelectionMode(n2);
        switch (n2) {
            case 1: {
                this.table.setSelectionMode(0);
                break;
            }
            case 2: {
                this.table.setSelectionMode(1);
                break;
            }
            case 4: {
                this.table.setSelectionMode(2);
            }
        }
    }

    public TreePath getPathForRow(int n2) {
        return this.tree.getPathForRow(n2);
    }

    public boolean isRowSelected(int n2) {
        return this.tree.isRowSelected(n2);
    }

    protected boolean processMouseOnTreeRenderer(int n2, MouseEvent mouseEvent, Dimension dimension) {
        return true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getTableHeader().isVisible()) {
            return dimension;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel.getColumnCount() > 0) {
            return new Dimension(dimension.width - tableColumnModel.getColumn(0).getPreferredWidth() + this.getPreferredColumnWidth(0), dimension.height);
        }
        return dimension;
    }

    public Rectangle getCellRect(int n2, int n3, boolean bl) {
        return this.table.getCellRect(n2, n3, bl);
    }

    public int getRowForPath(TreePath treePath) {
        return this.tree.getRowForPath(treePath);
    }

    public void setAutoResizeMode(int n2) {
        this.table.setAutoResizeMode(n2);
    }

    public int getAutoResizeMode() {
        return this.table.getAutoResizeMode();
    }

    public int convertColumnIndexToModel(int n2) {
        return this.table.convertColumnIndexToModel(n2);
    }

    public int convertColumnIndexToView(int n2) {
        return this.table.convertColumnIndexToView(n2);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.tree.addTreeExpansionListener(treeExpansionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.tree.addTreeWillExpandListener(treeWillExpandListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.tree.removeTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.tree.removeTreeWillExpandListener(treeWillExpandListener);
    }

    public int getRowForLocation(int n2, int n3) {
        Point point = new Point(n2, n3);
        int n4 = this.table.rowAtPoint(point);
        if (n4 == -1) {
            return -1;
        }
        int n5 = this.table.columnAtPoint(point);
        if (n5 == 0) {
            Rectangle rectangle = this.tree.getRowBounds(n4);
            return rectangle.x <= n2 && n2 < rectangle.x + rectangle.width ? n4 : -1;
        }
        return n4;
    }

    public TreePath getPathForLocation(int n2, int n3) {
        int n4 = this.getRowForLocation(n2, n3);
        if (n4 == -1) {
            return null;
        }
        return this.getPathForRow(n4);
    }

    public int getPreferredColumnWidth(int n2) {
        Serializable serializable;
        Serializable serializable2;
        if (n2 == 0) {
            return this.tree.getPreferredSize().width;
        }
        int n3 = this.getRowCount();
        int n4 = Math.max(this.getColumnModel().getColumn(n2).getMinWidth(), 10);
        TreeTableCellRenderer treeTableCellRenderer = this.getCellRenderer();
        for (int i2 = 0; i2 < n3; ++i2) {
            serializable2 = this.getPathForRow(i2);
            serializable = (DefaultMutableTreeTableNode)((TreePath)serializable2).getLastPathComponent();
            Object object = ((DefaultMutableTreeTableNode)serializable).getUserObject(n2);
            Component component = treeTableCellRenderer.getTreeTableCellRendererComponent(this, object, false, this.isExpanded((TreePath)serializable2), ((DefaultMutableTreeNode)serializable).isLeaf(), i2, n2, false);
            n4 = Math.max(n4, (int)component.getPreferredSize().getWidth());
        }
        JTableHeader jTableHeader = this.getTableHeader();
        serializable2 = jTableHeader.getColumnModel().getColumn(n2);
        serializable = jTableHeader.getDefaultRenderer().getTableCellRendererComponent(this.table, ((TableColumn)serializable2).getHeaderValue(), false, false, -1, n2);
        n4 = Math.max(n4, (int)((Component)serializable).getPreferredSize().getWidth());
        return n4;
    }

    public int getRowHeight() {
        return this.table.getRowHeight();
    }

    public int getRowHeight(int n2) {
        return this.table.getRowHeight(n2);
    }

    public void setRowHeight(int n2) {
        this.table.setRowHeight(n2);
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public int rowAtPoint(Point point) {
        return this.table.rowAtPoint(point);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
    }

    public void requestFocus() {
        this.table.requestFocus();
    }

    class InternalTable
    extends JTable {
        protected InternalTable() {
            this.enableEvents(48L);
            this.setSelectionModel(JTreeTable.this.tableSelectionModel);
            JTreeTable.this.setBackground(super.getBackground());
        }

        public Color getBackground() {
            return JTreeTable.this != null ? JTreeTable.this.getBackground() : super.getBackground();
        }

        public boolean isOpaque() {
            return JTreeTable.this.isOpaque();
        }

        public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
            Rectangle cellBounds = super.getCellRect(row, column, includeSpacing);
            Rectangle rowBounds = JTreeTable.this.tree.getRowBounds(row);
            if (rowBounds == null) {
                return cellBounds;
            }
            cellBounds.y = rowBounds.y;
            cellBounds.y += row * this.getIntercellSpacing().height;
            return cellBounds;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return JTreeTable.this.tableCellRenderer;
        }

        public int getRowHeight(int row) {
            return JTreeTable.this.tree.getRowBounds((int)row).height + this.getRowMargin();
        }

        public void reshape(int x, int y, int w2, int h2) {
            super.reshape(x, y, w2, h2);
            TableColumnModel columnModel = this.getColumnModel();
            if (columnModel.getColumnCount() > 0) {
                JTreeTable.this.tree.setSize(columnModel.getColumn(0).getWidth(), h2);
            } else {
                JTreeTable.this.tree.setSize(w2, h2);
            }
        }

        /*
         * Unable to fully structure code
         */
        public int rowAtPoint(Point point) {
            row = JTreeTable.this.tree.getClosestRowForLocation(0, point.y);
            if (row == -1) {
                return -1;
            }
            rect = this.getCellRect(this.getRowCount() - 1, 0, false);
            if (point.y <= rect.y + rect.height) ** GOTO lbl9
            return -1;
lbl-1000:
            // 1 sources

            {
                if (--row != -1) continue;
                return -1;
lbl9:
                // 2 sources

                ** while (this.getCellRect((int)row, (int)0, (boolean)false).y > point.y)
            }
lbl10:
            // 1 sources

            return row;
        }

        protected void processEvent(AWTEvent e2) {
            if (e2 instanceof MouseEvent) {
                MouseEvent me;
                Point point;
                int row;
                Rectangle treeRect;
                if (e2.getID() == 507) {
                    super.processEvent(e2);
                    return;
                }
                if (e2.getID() == 501 && this.isFocusable() && !this.hasFocus()) {
                    this.requestFocus();
                }
                if (!(treeRect = this.getCellRect(row = this.rowAtPoint(point = (me = (MouseEvent)e2).getPoint()), 0, false)).contains(point)) {
                    if (JTreeTable.this.isFullLineSelection()) {
                        super.processEvent(e2);
                    }
                    return;
                }
                int xOffset = treeRect.x;
                int yOffset = row * this.getIntercellSpacing().height;
                int x = me.getX() - xOffset;
                int y = me.getY() - yOffset;
                Rectangle rowBounds = JTreeTable.this.tree.getRowBounds(row);
                if (rowBounds != null) {
                    if (!rowBounds.contains(x, y)) {
                        me = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), x, y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                        boolean isExpanded = JTreeTable.this.tree.isExpanded(row);
                        JTreeTable.this.tree.dispatchEvent(me);
                        if (JTreeTable.this.isFullLineSelection() && JTreeTable.this.tree.isExpanded(row) == isExpanded) {
                            super.processEvent(e2);
                        }
                    } else if (JTreeTable.this.processMouseOnTreeRenderer(row, new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), x - rowBounds.x, y - rowBounds.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()), new Dimension(rowBounds.width, rowBounds.height))) {
                        super.processEvent(e2);
                    }
                } else {
                    super.processEvent(e2);
                }
            } else if (e2 instanceof KeyEvent) {
                JTreeTable.this.tree.dispatchEvent(e2);
                super.processEvent(e2);
            } else {
                super.processEvent(e2);
            }
            this.repaint();
        }
    }

    protected class TreeTableModel
    implements TableModel {
        protected EventListenerList listenerList = new EventListenerList();

        protected TreeTableModel() {
        }

        public int getRowCount() {
            return JTreeTable.this.tree.getRowCount();
        }

        public int getColumnCount() {
            return JTreeTable.this.getColumnModel().getColumnCount();
        }

        public String getColumnName(int columnIndex) {
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            TreePath path = JTreeTable.this.tree.getPathForRow(rowIndex);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (node instanceof TreeTableNode) {
                return ((TreeTableNode)node).getUserObject(columnIndex);
            }
            if (columnIndex == 0 && node instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)node).getUserObject();
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void addTableModelListener(TableModelListener l2) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.swing.event.TableModelListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listenerList.add(clazz, l2);
        }

        public void removeTableModelListener(TableModelListener l2) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.swing.event.TableModelListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listenerList.remove(clazz, l2);
        }

        public void fireTableChanged(TableModelEvent e2) {
            Object[] listeners = this.listenerList.getListenerList();
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                Object object = listeners[i2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("javax.swing.event.TableModelListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object == clazz) {
                    ((TableModelListener)listeners[i2 + 1]).tableChanged(e2);
                }
                i2 -= 2;
            }
        }
    }
}

