/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.TabFolderDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class TabItemDrawData
extends DrawData {
    public TabFolderDrawData parent;
    public int position;
    static final int TABITEM_INSET = 2;
    static final int TABITEM_INSET2 = 6;

    public TabItemDrawData() {
        this.state = new int[1];
    }

    Rectangle computeTrim(Theme theme, GC gC) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            int n3 = this.clientArea.x;
            int n4 = this.clientArea.y;
            int n5 = this.clientArea.width;
            int n6 = this.clientArea.height;
            if ((this.style & 0x4000) != 0) {
                n3 -= 2;
                n5 += 2;
            }
            RECT rECT = new RECT();
            rECT.left = n3;
            rECT.right = n3 + n5;
            rECT.top = n4 -= 2;
            rECT.bottom = n4 + (n6 += 2);
            RECT rECT2 = new RECT();
            int[] nArray = this.getPartId(0);
            OS.GetThemeBackgroundExtent((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, (RECT)rECT2);
            rECT2.left -= 6;
            rECT2.top -= 6;
            rECT2.right += 6;
            OS.CloseThemeData((int)n2);
            return new Rectangle(rECT2.left, rECT2.top, rECT2.right - rECT2.left, rECT2.bottom - rECT2.top);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = this.state[0];
            int n3 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            int n4 = rectangle.x;
            int n5 = rectangle.y;
            int n6 = rectangle.width;
            int n7 = rectangle.height;
            if ((this.position & 0x4000) != 0) {
                n4 += 2;
                n6 -= 2;
            }
            n5 += 2;
            n7 -= 2;
            if ((n2 & 2) != 0) {
                n4 -= 2;
                n5 -= 2;
                n6 += 4;
                n7 += 4;
            }
            RECT rECT = new RECT();
            rECT.left = n4;
            rECT.right = n4 + n6;
            rECT.top = n5;
            rECT.bottom = n5 + n7;
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground((int)n3, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
            OS.CloseThemeData((int)n3);
            Rectangle rectangle2 = this.clientArea;
            if (rectangle2 != null) {
                RECT rECT2 = new RECT();
                OS.GetThemeBackgroundContentRect((int)n3, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, (RECT)rECT2);
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
        }
    }

    char[] getClassId() {
        return TAB;
    }

    int[] getPartId(int n2) {
        int n3 = this.state[n2];
        int n4 = 1;
        int n5 = 1;
        if ((this.style & 0x4000) != 0 && (this.style & 0x20000) != 0) {
            n4 = 2;
        } else if ((this.style & 0x4000) != 0) {
            n4 = 2;
        } else if ((this.style & 0x20000) != 0) {
            // empty if block
        }
        if ((n3 & 0x40) != 0) {
            n5 = 2;
        }
        if ((n3 & 4) != 0) {
            n5 = 5;
        }
        if ((n3 & 2) != 0) {
            n5 = 3;
        }
        if ((n3 & 0x20) != 0) {
            n5 = 4;
        }
        return new int[]{n4, n5};
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        Rectangle rectangle2;
        if (!rectangle.contains(point)) {
            return -1;
        }
        int n2 = this.style;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if ((n2 & 0x4000) != 0) {
            n3 += 2;
            n5 -= 2;
        }
        if (!(rectangle2 = new Rectangle(n3, n4 += 2, n5, n6 -= 2)).contains(point)) {
            return -1;
        }
        return 0;
    }
}

