/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean moved;
    boolean resized;
    boolean isVisible;
    Image image;
    org.eclipse.swt.graphics.Font font;
    Timer timer = new Timer(LookAndFeelUtils.getCaretBlinkRate(), new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            Caret.this.blink = !Caret.this.blink;
            if (Caret.this.parent != null && Caret.this.parent.caret == Caret.this) {
                Caret.this.parent.handle.repaint();
            } else {
                Caret.this.timer.stop();
            }
        }
    }){

        public void stop() {
            super.stop();
            Caret.this.blink = true;
            if (Caret.this.parent != null) {
                Caret.this.parent.handle.repaint();
            }
        }
    };
    private boolean blink;

    public Caret(Canvas canvas, int n2) {
        super(canvas, n2);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    void paintCaret(GC gC) {
        if (this.blink && this.isVisible()) {
            if (this.display == null) {
                return;
            }
            gC.setXORMode(true);
            gC.setBackground(this.display.getSystemColor(2));
            if (this.image != null) {
                gC.drawImage(this.image, this.x, this.y);
            }
            gC.fillRectangle(this.x, this.y, Math.max(1, this.width), this.height);
            gC.setXORMode(false);
        }
    }

    Font defaultFont() {
        return this.parent.handle.getFont();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public org.eclipse.swt.graphics.Font getFont() {
        this.checkWidget();
        if (this.font == null) {
            return org.eclipse.swt.graphics.Font.swing_new(this.display, this.defaultFont());
        }
        return this.font;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Point(rectangle.width, rectangle.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hasFocus() {
        return this.parent.isFocusControl();
    }

    boolean isFocusCaret() {
        return this.parent.caret == this && this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.hasFocus();
    }

    void killFocus() {
        this.timer.stop();
    }

    void move() {
        this.blink = true;
    }

    void resizeIME() {
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.image = null;
        this.font = null;
    }

    void resize() {
    }

    void restoreIMEFont() {
    }

    void saveIMEFont() {
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        boolean bl;
        this.checkWidget();
        boolean bl2 = this.x == n2 && this.y == n3;
        boolean bl3 = bl = this.width == n4 && this.height == n5;
        if (bl2 && bl) {
            return;
        }
        this.timer.stop();
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        if (bl) {
            this.moved = true;
            if (this.isVisible && this.hasFocus()) {
                this.move();
            }
        } else {
            this.resized = true;
            if (this.isVisible && this.hasFocus()) {
                this.resize();
            }
        }
        this.timer.start();
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        this.timer.start();
    }

    public void setFont(org.eclipse.swt.graphics.Font font) {
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    void setIMEFont(int n2) {
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        if (this.x == n2 && this.y == n3) {
            return;
        }
        this.timer.stop();
        this.x = n2;
        this.y = n3;
        this.moved = true;
        if (this.isVisible && this.hasFocus()) {
            this.move();
        }
        this.timer.start();
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setSize(int n2, int n3) {
        this.checkWidget();
        if (this.width == n2 && this.height == n3) {
            return;
        }
        this.width = n2;
        this.height = n3;
        this.resized = true;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
    }

    static /* synthetic */ boolean access$002(Caret caret, boolean bl) {
        caret.blink = bl;
        return caret.blink;
    }

    static /* synthetic */ boolean access$000(Caret caret) {
        return caret.blink;
    }
}

