/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.CTree;
import org.eclipse.swt.internal.swing.CTreeItem;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    CTreeItem handle;
    Tree parent;
    TreeItem parentItem;
    ArrayList itemList;
    Image[] images;
    boolean cached;

    public TreeItem(Tree tree, int n2) {
        super(tree, n2);
        this.parent = tree;
        this.handle = this.createHandle();
        tree.createItem(this, ((CTree)((Object)tree.handle)).getRoot().getChildCount());
    }

    public TreeItem(Tree tree, int n2, int n3) {
        super(tree, n2);
        if (n3 < 0) {
            this.error(6);
        }
        this.parent = tree;
        this.handle = this.createHandle();
        tree.createItem(this, n3);
    }

    public TreeItem(TreeItem treeItem, int n2) {
        super(TreeItem.checkNull((TreeItem)treeItem).parent, n2);
        this.parent = treeItem.parent;
        this.parentItem = treeItem;
        this.handle = this.createHandle();
        this.parent.createItem(this, treeItem, treeItem.handle.getChildCount());
    }

    public TreeItem(TreeItem treeItem, int n2, int n3) {
        super(TreeItem.checkNull((TreeItem)treeItem).parent, n2);
        if (n3 < 0) {
            this.error(6);
        }
        this.parent = treeItem.parent;
        this.parentItem = treeItem;
        this.handle = this.createHandle();
        this.parent.createItem(this, treeItem, n3);
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    CTreeItem createHandle() {
        return CTreeItem.Factory.newInstance(this, this.style);
    }

    public void clear(int n2, boolean bl) {
        this.checkWidget();
        CTreeItem.TreeItemObject treeItemObject = this.handle.getTreeItemObject(n2);
        treeItemObject.setText(null);
        treeItemObject.setBackground(null);
        treeItemObject.setForeground(null);
        treeItemObject.setFont(null);
        treeItemObject.setIcon(null);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        if (bl) {
            TreeItem[] treeItemArray = this.getItems();
            for (int i2 = 0; i2 < treeItemArray.length; ++i2) {
                treeItemArray[i2].clear(n2, bl);
            }
        }
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.text = "";
        this.image = null;
        this.images = null;
        this.handle.setBackground(null);
        this.handle.setForeground(null);
        this.handle.setFont(null);
        this.handle.setChecked(false);
        this.handle.setGrayed(false);
        int n2 = this.parent.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.clear(i2, bl);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
    }

    void destroyWidget() {
        this.parent.releaseItem(this, false);
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public org.eclipse.swt.graphics.Color getBackground() {
        Color color;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((color = this.handle.getBackground()) == null) {
            return this.parent.getBackground();
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public org.eclipse.swt.graphics.Color getBackground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return this.getBackground();
        }
        Color color = this.handle.getTreeItemObject(n2).getBackground();
        if (color == null) {
            if (n2 != 0) {
                return this.getBackground();
            }
            return org.eclipse.swt.graphics.Color.swing_new(this.display, this.parent.handle.getBackground());
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.getBounds(0);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds(int n2) {
        CTree cTree;
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = (cTree = (CTree)((Object)this.parent.handle)).getRowForPath(new TreePath(this.handle.getPath()))) == -1) {
            return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = cTree.getCellRect(n3, n2, false);
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.handle.isChecked();
    }

    public boolean getExpanded() {
        this.checkWidget();
        return ((CTree)((Object)this.parent.handle)).isExpanded(new TreePath(this.handle.getPath()));
    }

    public org.eclipse.swt.graphics.Font getFont() {
        return this.getFont(0);
    }

    public org.eclipse.swt.graphics.Font getFont(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return this.getFont();
        }
        Font font = this.handle.getTreeItemObject(n2).getFont();
        if (font == null) {
            if (n2 != 0) {
                return this.getFont();
            }
            return org.eclipse.swt.graphics.Font.swing_new(this.display, this.parent.handle.getFont());
        }
        return org.eclipse.swt.graphics.Font.swing_new(this.display, font);
    }

    public org.eclipse.swt.graphics.Color getForeground() {
        Color color;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((color = this.handle.getForeground()) == null) {
            return this.parent.getForeground();
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public org.eclipse.swt.graphics.Color getForeground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return this.getForeground();
        }
        Color color = this.handle.getTreeItemObject(n2).getForeground();
        if (color == null) {
            if (n2 != 0) {
                return this.getBackground();
            }
            return org.eclipse.swt.graphics.Color.swing_new(this.display, this.parent.handle.getForeground());
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.handle.isGrayed();
    }

    public TreeItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 < 0 || n2 >= this.getItemCount()) {
            this.error(6);
        }
        return (TreeItem)this.itemList.get(n2);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.itemList == null ? 0 : this.itemList.size();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.itemList == null ? new TreeItem[]{} : this.itemList.toArray(new TreeItem[0]);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getImage();
        }
        if (this.images != null && 0 <= n2 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    public org.eclipse.swt.graphics.Rectangle getImageBounds(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
        }
        CTree cTree = (CTree)((Object)this.parent.handle);
        int n4 = cTree.getRowForPath(new TreePath(this.handle.getPath()));
        Rectangle rectangle = ((CTree)((Object)this.parent.handle)).getImageBounds(n4, n2);
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return "";
        }
        return this.handle.getTreeItemObject(n2).getText();
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        return this.itemList == null ? -1 : this.itemList.indexOf(treeItem);
    }

    void releaseChildren(boolean bl) {
        if (bl) {
            this.parent.destroyItem(this);
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = null;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.images = null;
    }

    public void removeAll() {
        this.checkWidget();
        if (this.itemList != null) {
            for (int i2 = this.itemList.size() - 1; i2 >= 0; --i2) {
                TreeItem treeItem = (TreeItem)this.itemList.get(i2);
                if (treeItem != null && !treeItem.isDisposed()) {
                    treeItem.dispose();
                    continue;
                }
                this.itemList.remove(i2);
            }
        }
    }

    public void setBackground(org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setBackground(color == null ? null : color.handle);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.handle.repaint();
    }

    public void setBackground(int n2, org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        this.handle.getTreeItemObject(n2).setBackground(color == null ? null : color.handle);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.handle.repaint();
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        this.handle.setChecked(bl);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        CTree cTree = (CTree)((Object)this.parent.handle);
        if (bl) {
            cTree.expandPath(new TreePath(this.handle.getPath()));
        } else {
            cTree.collapsePath(new TreePath(this.handle.getPath()));
        }
    }

    public void setFont(org.eclipse.swt.graphics.Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setFont(font == null ? null : font.handle);
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.handle.repaint();
    }

    public void setFont(int n2, org.eclipse.swt.graphics.Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        this.handle.getTreeItemObject(n2).setFont(font == null ? null : font.handle);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.handle.repaint();
    }

    public void setForeground(org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setForeground(color == null ? null : color.handle);
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.handle.repaint();
    }

    public void setForeground(int n2, org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        this.handle.getTreeItemObject(n2).setForeground(color == null ? null : color.handle);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.handle.repaint();
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        this.handle.setGrayed(bl);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            this.setImage(i2, imageArray[i2]);
        }
    }

    public void setImage(int n2, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (n2 == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.images == null && n2 != 0) {
            this.images = new Image[n3];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n2])) {
                return;
            }
            this.images[n2] = image;
        }
        this.handle.getTreeItemObject(n2).setIcon(image != null ? new ImageIcon(image.handle) : null);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int n2) {
        this.checkWidget();
        n2 = Math.max(0, n2);
        this.parent.setItemCount(this, n2);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string == null) continue;
            this.setText(i2, string);
        }
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (n2 == 0) {
            super.setText(string);
        }
        this.handle.getTreeItemObject(n2).setText(string);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTree)((Object)this.parent.handle)).getModel().nodeChanged((TreeNode)((Object)this.handle));
        this.parent.adjustColumnWidth();
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

