/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.IHelpActivitySupport;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class HelpActivitySupport
implements IHelpActivitySupport {
    private static final String PREF_KEY_SHOW_DISABLED_ACTIVITIES = "showDisabledActivityTopics";
    private static final String SHOW_DISABLED_ACTIVITIES_NEVER = "never";
    private static final String SHOW_DISABLED_ACTIVITIES_OFF = "off";
    private static final String SHOW_DISABLED_ACTIVITIES_ON = "on";
    private Preferences pref;
    private IWorkbenchActivitySupport activitySupport;
    private boolean userCanToggleFiltering;
    private boolean filteringEnabled;
    private ActivityDescriptor activityDescriptor;

    public HelpActivitySupport(IWorkbench workbench) {
        this.activitySupport = workbench.getActivitySupport();
        this.activityDescriptor = new ActivityDescriptor();
        this.pref = HelpBasePlugin.getDefault().getPluginPreferences();
        String showDisabledActivities = this.pref.getString(PREF_KEY_SHOW_DISABLED_ACTIVITIES);
        this.userCanToggleFiltering = SHOW_DISABLED_ACTIVITIES_OFF.equalsIgnoreCase(showDisabledActivities) || SHOW_DISABLED_ACTIVITIES_ON.equalsIgnoreCase(showDisabledActivities);
        this.userCanToggleFiltering = this.userCanToggleFiltering && HelpActivitySupport.isWorkbenchFiltering();
        this.filteringEnabled = SHOW_DISABLED_ACTIVITIES_OFF.equalsIgnoreCase(showDisabledActivities) || SHOW_DISABLED_ACTIVITIES_NEVER.equalsIgnoreCase(showDisabledActivities);
        this.filteringEnabled = this.filteringEnabled && HelpActivitySupport.isWorkbenchFiltering();
    }

    public boolean isFilteringEnabled() {
        return this.filteringEnabled;
    }

    public void setFilteringEnabled(boolean enabled) {
        if (this.userCanToggleFiltering) {
            this.filteringEnabled = enabled;
            if (enabled) {
                this.pref.setValue(PREF_KEY_SHOW_DISABLED_ACTIVITIES, SHOW_DISABLED_ACTIVITIES_OFF);
            } else {
                this.pref.setValue(PREF_KEY_SHOW_DISABLED_ACTIVITIES, SHOW_DISABLED_ACTIVITIES_ON);
            }
        }
    }

    public boolean isUserCanToggleFiltering() {
        return this.userCanToggleFiltering;
    }

    public boolean isEnabled(String href) {
        if (!this.isFilteringEnabled()) {
            return true;
        }
        return this.isRoleEnabled(href);
    }

    public boolean isRoleEnabled(String href) {
        if (href.startsWith("/")) {
            href = href.substring(1);
        }
        return this.activitySupport.getActivityManager().getIdentifier(href).isEnabled();
    }

    public boolean isEnabledTopic(String href, String locale) {
        if (href == null) {
            return false;
        }
        if (!this.isFilteringEnabled()) {
            return true;
        }
        int ix = href.indexOf("?resultof=");
        if (ix >= 0) {
            href = href.substring(0, ix);
        }
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int t = 0;
        while (t < tocs.length) {
            String descriptionHref = tocs[t].getTocTopicHref();
            if (descriptionHref != null && descriptionHref.length() > 0 && descriptionHref.equals(href) && HelpBasePlugin.getActivitySupport().isEnabled(tocs[t].getHref())) {
                return true;
            }
            ++t;
        }
        return this.isInTocSubtree(href, Arrays.asList(tocs));
    }

    private boolean isInTocSubtree(String href, List tocList) {
        Iterator it = tocList.iterator();
        while (it.hasNext()) {
            ITocElement toc = (ITocElement)it.next();
            if (!HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref())) continue;
            if (toc.getOwnedTopic(href) != null) {
                return true;
            }
            if (toc.getOwnedExtraTopic(href) != null) {
                return true;
            }
            if (!this.isInTocSubtree(href, toc.getChildrenTocs())) continue;
            return true;
        }
        return false;
    }

    public void enableActivities(String href) {
        IIdentifier identifier;
        Set activitityIds;
        if (href.startsWith("/")) {
            href = href.substring(1);
        }
        if ((activitityIds = (identifier = this.activitySupport.getActivityManager().getIdentifier(href)).getActivityIds()).isEmpty()) {
            return;
        }
        HashSet enabledIds = new HashSet(this.activitySupport.getActivityManager().getEnabledActivityIds());
        enabledIds.addAll(activitityIds);
        this.activitySupport.setEnabledActivityIds(enabledIds);
    }

    private static boolean isWorkbenchFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    public String getShowAllMessage() {
        return this.activityDescriptor.getShowAllMessage();
    }

    public String getDocumentMessage(boolean embedded) {
        return this.activityDescriptor.getDocumentMessage(embedded);
    }

    public boolean getDocumentMessageUsesLiveHelp(boolean embedded) {
        return this.activityDescriptor.needsLiveHelp(embedded);
    }

    public String getLocalScopeCheckboxLabel() {
        return this.activityDescriptor.getLocalScopeCheckboxLabel();
    }

    class ActivityDescriptor {
        private IConfigurationElement config;
        private String documentMessage;
        private boolean needsLiveHelp;

        public ActivityDescriptor() {
            this.load();
        }

        private void load() {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.base.activitySupport");
            if (elements.length == 1 && elements[0].getName().equals("support")) {
                this.config = elements[0];
            } else if (elements.length > 0) {
                IProduct product = Platform.getProduct();
                if (product == null) {
                    return;
                }
                String productId = product.getId();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement element = elements[i];
                    if (element.getAttribute("productId").equals(productId)) {
                        this.config = element;
                        break;
                    }
                    ++i;
                }
            }
        }

        private IConfigurationElement getChild(String name) {
            IConfigurationElement[] children = this.config.getChildren(name);
            return children.length == 1 ? children[0] : null;
        }

        public String getShowAllMessage() {
            if (this.config == null) {
                return null;
            }
            IConfigurationElement child = this.getChild("showAllMessage");
            if (child != null) {
                return child.getValue();
            }
            return null;
        }

        public String getLocalScopeCheckboxLabel() {
            if (this.config == null) {
                return null;
            }
            IConfigurationElement child = this.getChild("localScopeCheckbox");
            if (child != null) {
                return child.getValue();
            }
            return null;
        }

        public boolean needsLiveHelp(boolean embedded) {
            this.getDocumentMessage(embedded);
            return this.needsLiveHelp;
        }

        public String getDocumentMessage(boolean embedded) {
            IConfigurationElement child;
            if (this.config != null && this.documentMessage == null && (child = this.getChild("documentMessage")) != null) {
                String value = child.getValue();
                String pluginId = child.getAttribute("pluginId");
                String className = child.getAttribute("class");
                int loc = value.indexOf("ACTIVITY_EDITOR");
                if (loc != -1 && className != null) {
                    this.needsLiveHelp = true;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(value.substring(0, loc));
                    buffer.append(this.getActivityEditorValue(pluginId, className, embedded));
                    buffer.append(value.substring(loc + 15));
                    this.documentMessage = buffer.toString();
                } else {
                    this.documentMessage = value;
                }
            }
            return this.documentMessage;
        }

        private String getActivityEditorValue(String pluginId, String className, boolean embedded) {
            String evalue = embedded ? "narrow" : "";
            return "javascript:liveAction(\"" + pluginId + "\", \"" + className + "\",\"" + evalue + "\")";
        }
    }
}

