/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.synchronize.MultiLabelDecorator;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;

public class SynchronizePageConfiguration
extends SynchronizePageActionGroup
implements ISynchronizePageConfiguration {
    public static final String P_MODEL = "org.eclipse.team.ui.P_MODEL";
    public static final String P_ADVISOR = "org.eclipse.team.ui.P_ADVISOR";
    public static final String P_NAVIGATOR = "org.eclipse.team.ui.P_NAVIGATOR";
    public static final String P_MODEL_MANAGER = "org.eclipse.team.ui.P_MODEL_MANAGER";
    public static final String P_WORKING_SET_SYNC_INFO_SET = "org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET";
    public static final String P_PARTICIPANT_SYNC_INFO_SET = "org.eclipse.team.ui.P_PARTICIPANT_SYNC_INFO_SET";
    public static final String P_OPEN_ACTION = "org.eclipse.team.ui.P_OPEN_ACTION";
    public static final String P_VIEWER_STYLE = "org.eclipse.team.ui.P_VIEWER_STYLE";
    public static final int CHECKBOX = 1;
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int DISPOSED = 2;
    private ISynchronizeParticipant participant;
    private ISynchronizePageSite site;
    private ListenerList propertyChangeListeners = new ListenerList(1);
    private ListenerList actionContributions = new ListenerList(1);
    private Map properties = new HashMap();
    private int actionState = 0;
    private ISynchronizePage page;
    private IRunnableContext context;

    public SynchronizePageConfiguration(ISynchronizeParticipant participant) {
        this.participant = participant;
        this.setProperty("org.eclipse.team.ui.P_CONTEXT_MENU", DEFAULT_CONTEXT_MENU);
        this.setProperty("org.eclipse.team.ui.P_TOOLBAR_MENU", DEFAULT_TOOLBAR_MENU);
        this.setProperty("org.eclipse.team.ui.P_VIEW_MENU", DEFAULT_VIEW_MENU);
        this.setProperty("org.eclipse.team.ui.P_COMPARISON_TYPE", "three-way");
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    public ISynchronizePageSite getSite() {
        return this.site;
    }

    public void setSite(ISynchronizePageSite site) {
        this.site = site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        ListenerList listenerList = this.propertyChangeListeners;
        synchronized (listenerList) {
            this.propertyChangeListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        ListenerList listenerList = this.propertyChangeListeners;
        synchronized (listenerList) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public void setProperty(String key, Object newValue) {
        Object oldValue = this.properties.get(key);
        if (this.page == null || this.page.aboutToChangeProperty(this, key, newValue)) {
            this.properties.put(key, newValue);
            if (oldValue == null || !oldValue.equals(newValue)) {
                this.firePropertyChange(key, oldValue, newValue);
            }
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionContribution(SynchronizePageActionGroup contribution) {
        int currentActionState;
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            currentActionState = this.actionState;
            if (currentActionState != 2) {
                this.actionContributions.add((Object)contribution);
            }
        }
        if (currentActionState == 1) {
            contribution.initialize(this);
            if (this.actionState == 2) {
                contribution.dispose();
            }
        } else if (currentActionState == 2) {
            contribution.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionContribution(SynchronizePageActionGroup contribution) {
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            this.actionContributions.remove((Object)contribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String key, Object oldValue, Object newValue) {
        Object[] listeners;
        ListenerList listenerList = this.propertyChangeListeners;
        synchronized (listenerList) {
            listeners = this.propertyChangeListeners.getListeners();
        }
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(final ISynchronizePageConfiguration configuration) {
        Object[] listeners;
        super.initialize(configuration);
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            if (this.actionState != 0) {
                return;
            }
            this.actionState = 1;
            listeners = this.actionContributions.getListeners();
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.initialize(configuration);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(final ActionContext context) {
        Object[] listeners;
        super.setContext(context);
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            listeners = this.actionContributions.getListeners();
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.setContext(context);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillContextMenu(final IMenuManager manager) {
        Object[] listeners;
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            listeners = this.actionContributions.getListeners();
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.fillContextMenu(manager);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillActionBars(final IActionBars actionBars) {
        Object[] listeners;
        if (this.actionState == 0) {
            this.initialize(this);
        }
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            listeners = this.actionContributions.getListeners();
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.fillActionBars(actionBars);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActionBars() {
        Object[] listeners;
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            listeners = this.actionContributions.getListeners();
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.updateActionBars();
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(final ISynchronizeModelElement root) {
        Object[] listeners;
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            listeners = this.actionContributions.getListeners();
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.modelChanged(root);
                }
            });
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object[] listeners;
        super.dispose();
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            listeners = this.actionContributions.getListeners();
            this.actionState = 2;
        }
        int i = 0;
        while (i < listeners.length) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.dispose();
                }
            });
            ++i;
        }
    }

    public void setMenuGroups(String menuPropertyId, String[] groups) {
        this.setProperty(menuPropertyId, groups);
    }

    public void addMenuGroup(String menuPropertyId, String groupId) {
        String[] menuGroups = (String[])this.getProperty(menuPropertyId);
        if (menuGroups == null) {
            menuGroups = this.getDefault(menuPropertyId);
        }
        String[] newGroups = new String[menuGroups.length + 1];
        System.arraycopy(menuGroups, 0, newGroups, 0, menuGroups.length);
        newGroups[menuGroups.length] = groupId;
        this.setProperty(menuPropertyId, newGroups);
    }

    public boolean hasMenuGroup(String menuPropertyId, String groupId) {
        String[] groups = (String[])this.getProperty(menuPropertyId);
        if (groups == null) {
            groups = this.getDefault(menuPropertyId);
        }
        int i = 0;
        while (i < groups.length) {
            String string = groups[i];
            if (string.equals(groupId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] getDefault(String menuPropertyId) {
        if (menuPropertyId.equals("org.eclipse.team.ui.P_CONTEXT_MENU")) {
            return DEFAULT_CONTEXT_MENU;
        }
        if (menuPropertyId.equals("org.eclipse.team.ui.P_VIEW_MENU")) {
            return DEFAULT_VIEW_MENU;
        }
        if (menuPropertyId.equals("org.eclipse.team.ui.P_TOOLBAR_MENU")) {
            return DEFAULT_TOOLBAR_MENU;
        }
        return new String[0];
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        ILabelDecorator[] decorators = (ILabelDecorator[])this.getProperty("org.eclipse.team.ui.P_LABEL_DECORATORS");
        if (decorators == null) {
            decorators = new ILabelDecorator[]{};
        }
        int i = 0;
        while (i < decorators.length) {
            ILabelDecorator d = decorators[i];
            if (d == decorator) {
                return;
            }
            ++i;
        }
        ILabelDecorator[] newDecorators = new ILabelDecorator[decorators.length + 1];
        System.arraycopy(decorators, 0, newDecorators, 0, decorators.length);
        newDecorators[decorators.length] = decorator;
        this.setProperty("org.eclipse.team.ui.P_LABEL_DECORATORS", newDecorators);
    }

    public String getGroupId(String group) {
        String id = this.getParticipant().getId();
        if (this.getParticipant().getSecondaryId() != null) {
            id = String.valueOf(id) + ".";
            id = String.valueOf(id) + this.getParticipant().getSecondaryId();
        }
        return String.valueOf(id) + "." + group;
    }

    public int getMode() {
        Object o = this.getProperty("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE");
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setMode(int mode) {
        if (this.isModeSupported(mode)) {
            this.setProperty("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE", new Integer(mode));
        }
    }

    public boolean isModeSupported(int mode) {
        return (this.getSupportedModes() & mode) > 0;
    }

    public int getSupportedModes() {
        Object o = this.getProperty("org.eclipse.team.ui.P_SUPPORTED_MODES");
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setSupportedModes(int modes) {
        this.setProperty("org.eclipse.team.ui.P_SUPPORTED_MODES", new Integer(modes));
    }

    public ISynchronizePage getPage() {
        return this.page;
    }

    public void setPage(ISynchronizePage page) {
        this.page = page;
    }

    public int getViewerStyle() {
        Object o = this.getProperty(P_VIEWER_STYLE);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setViewerStyle(int style) {
        this.setProperty(P_VIEWER_STYLE, new Integer(style));
    }

    public SyncInfoSet getSyncInfoSet() {
        Object o = this.getProperty("org.eclipse.team.ui.P_SYNC_INFO_SET");
        if (o instanceof SyncInfoSet) {
            return (SyncInfoSet)o;
        }
        return null;
    }

    public String getComparisonType() {
        return (String)this.getProperty("org.eclipse.team.ui.P_COMPARISON_TYPE");
    }

    public void setComparisonType(String type) {
        this.setProperty("org.eclipse.team.ui.P_COMPARISON_TYPE", type);
    }

    public void setRunnableContext(IRunnableContext context) {
        this.context = context;
    }

    public IRunnableContext getRunnableContext() {
        return this.context;
    }

    public String getViewerId() {
        String viewerId = (String)this.getProperty("org.eclipse.team.ui.P_VIEWER_ID");
        if (viewerId != null) {
            return viewerId;
        }
        return "org.eclipse.team.ui.navigatorViewer";
    }

    public boolean isVisible(IDiff node) {
        if (this.getComparisonType() == "three-way" && node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return this.includeDirection(twd.getDirection());
        }
        return this.getComparisonType() == "two-way" && node instanceof IResourceDiff;
    }

    public boolean includeDirection(int direction) {
        int mode = this.getMode();
        switch (mode) {
            case 4: {
                return true;
            }
            case 8: {
                return direction == 768;
            }
            case 1: {
                return direction == 768 || direction == 512;
            }
            case 2: {
                return direction == 768 || direction == 256;
            }
        }
        return true;
    }

    public ILabelDecorator getLabelDecorator() {
        ILabelDecorator[] decorators = (ILabelDecorator[])this.getProperty("org.eclipse.team.ui.P_LABEL_DECORATORS");
        if (decorators == null) {
            return null;
        }
        return new MultiLabelDecorator(decorators);
    }
}

