/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.part.EditorActionBarContributor;

public class WebBrowserEditorActionBarContributor
extends EditorActionBarContributor {
    protected WebBrowserEditor editor;
    protected Action back;
    protected Action forward;
    protected Updater updater = new Updater();

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof WebBrowserEditor) {
            this.editor = (WebBrowserEditor)targetEditor;
            WebBrowserEditorInput input = this.editor.getWebBrowserEditorInput();
            if (input == null || input.isLocationBarLocal()) {
                IActionBars actionBars = this.getActionBars();
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.editor.getCopyAction());
                actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.editor.getCutAction());
                actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.editor.getPasteAction());
            }
        } else {
            this.editor = null;
        }
    }

    protected BrowserViewer getWebBrowser() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.webBrowser;
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        if (this.editor == null) {
            return;
        }
    }

    class Updater
    implements BrowserViewer.IBackNextListener {
        Updater() {
        }

        public void updateBackNextBusy() {
            if (WebBrowserEditorActionBarContributor.this.back == null) {
                return;
            }
            WebBrowserEditorActionBarContributor.this.back.setEnabled(WebBrowserEditorActionBarContributor.this.getWebBrowser().isBackEnabled());
            WebBrowserEditorActionBarContributor.this.forward.setEnabled(WebBrowserEditorActionBarContributor.this.getWebBrowser().isForwardEnabled());
        }
    }
}

