/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import com.ibm.icu.text.DateFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSAnnotateBlock;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Annotate;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AnnotateListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AnnotateView;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitterColors;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ShowAnnotationOperation
extends CVSOperation {
    private final ICVSResource fCVSResource;
    private final String fRevision;
    private final boolean binary;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ShowAnnotationOperation(IWorkbenchPart part, ICVSResource cvsResource, String revision, boolean binary) {
        super(part);
        this.fCVSResource = cvsResource;
        this.fRevision = revision;
        this.binary = binary;
    }

    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 120);
        final AnnotateListener listener = new AnnotateListener();
        this.fetchAnnotation(listener, this.fCVSResource, this.fRevision, Policy.subMonitorFor(monitor, 80));
        this.fetchContents(listener, Policy.subMonitorFor(monitor, 20));
        final RevisionInformation information = this.createRevisionInformation(listener, Policy.subMonitorFor(monitor, 20));
        Display display = this.getPart().getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                boolean useQuickDiffAnnotate = false;
                if (!ShowAnnotationOperation.this.binary && !(ShowAnnotationOperation.this.fCVSResource instanceof ICVSRemoteFile)) {
                    useQuickDiffAnnotate = ShowAnnotationOperation.this.promptForQuickDiffAnnotate();
                }
                if (useQuickDiffAnnotate) {
                    AbstractDecoratedTextEditor editor = ShowAnnotationOperation.this.getEditor();
                    if (editor != null) {
                        editor.showRevisionInformation(information, "org.eclipse.quickdiff.providers.CVSReferenceProvider");
                        IWorkbenchPage page = ShowAnnotationOperation.this.getPart().getSite().getPage();
                        try {
                            ISelectionProvider provider;
                            Class<?> clazz;
                            GenericHistoryView historyView = (GenericHistoryView)page.showView("org.eclipse.team.ui.GenericHistoryView");
                            historyView.showHistoryFor((Object)ShowAnnotationOperation.this.fCVSResource.getIResource());
                            IHistoryPage historyPage = historyView.getHistoryPage();
                            if (historyPage instanceof CVSHistoryPage) {
                                CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)historyPage;
                                cvsHistoryPage.setMode(1);
                            }
                            if ((clazz = class$0) == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.jface.internal.text.revisions.RevisionSelectionProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((provider = (ISelectionProvider)editor.getAdapter((Class)clazz)) != null) {
                                ISelectionChangedListener selectionListener = new ISelectionChangedListener(this, page){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ IWorkbenchPage val$page;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$page = iWorkbenchPage;
                                    }

                                    public void selectionChanged(SelectionChangedEvent event) {
                                        GenericHistoryView historyView = (GenericHistoryView)this.val$page.findView("org.eclipse.team.ui.GenericHistoryView");
                                        if (historyView == null) {
                                            return;
                                        }
                                        ISelection selection = event.getSelection();
                                        Revision selected = null;
                                        if (selection instanceof IStructuredSelection) {
                                            selected = (Revision)((IStructuredSelection)selection).getFirstElement();
                                        }
                                        if (selected == null) {
                                            return;
                                        }
                                        IHistoryPage historyPage = historyView.getHistoryPage();
                                        if (historyPage instanceof CVSHistoryPage) {
                                            CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)historyPage;
                                            IPath fileInHistoryViewPath = cvsHistoryPage.getFilePath();
                                            IPath annotateFilePath = ShowAnnotationOperation.access$1(1.access$0(this.this$1)).getIResource().getFullPath();
                                            if (fileInHistoryViewPath != null && annotateFilePath != null && fileInHistoryViewPath.equals((Object)annotateFilePath)) {
                                                cvsHistoryPage.selectRevision(selected.getId());
                                            }
                                        }
                                    }
                                };
                                provider.addSelectionChangedListener(selectionListener);
                                page.addPartListener(new IPartListener(this, historyView, editor, page, provider, selectionListener){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ GenericHistoryView val$historyView;
                                    private final /* synthetic */ AbstractDecoratedTextEditor val$editor;
                                    private final /* synthetic */ IWorkbenchPage val$page;
                                    private final /* synthetic */ ISelectionProvider val$provider;
                                    private final /* synthetic */ ISelectionChangedListener val$selectionListener;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$historyView = genericHistoryView;
                                        this.val$editor = abstractDecoratedTextEditor;
                                        this.val$page = iWorkbenchPage;
                                        this.val$provider = iSelectionProvider;
                                        this.val$selectionListener = iSelectionChangedListener;
                                    }

                                    public void partOpened(IWorkbenchPart part) {
                                    }

                                    public void partDeactivated(IWorkbenchPart part) {
                                    }

                                    public void partClosed(IWorkbenchPart part) {
                                        if (part == this.val$historyView || part == this.val$editor) {
                                            this.val$page.removePartListener((IPartListener)this);
                                            this.val$provider.removeSelectionChangedListener(this.val$selectionListener);
                                        }
                                    }

                                    public void partBroughtToTop(IWorkbenchPart part) {
                                    }

                                    public void partActivated(IWorkbenchPart part) {
                                    }
                                });
                            }
                        }
                        catch (PartInitException e) {
                            CVSException.wrapException((CoreException)((Object)e));
                        }
                    }
                } else {
                    ShowAnnotationOperation.this.showView(listener);
                }
            }

            static /* synthetic */ ShowAnnotationOperation access$0(1 var0) {
                return var0.ShowAnnotationOperation.this;
            }
        });
        monitor.done();
    }

    protected String getTaskName() {
        return CVSUIMessages.ShowAnnotationOperation_taskName;
    }

    protected boolean hasCharset(ICVSResource cvsResource, InputStream contents) {
        try {
            return TeamPlugin.getCharset((String)cvsResource.getName(), (InputStream)contents) != null;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void showView(AnnotateListener listener) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        String defaultPerspectiveID = this.promptForPerspectiveSwitch();
        if (defaultPerspectiveID != null) {
            try {
                workbench.showPerspective(defaultPerspectiveID, window);
            }
            catch (WorkbenchException e) {
                Utils.handleError((Shell)window.getShell(), (Exception)((Object)e), (String)CVSUIMessages.ShowAnnotationOperation_0, (String)e.getMessage());
            }
        }
        try {
            AnnotateView view = AnnotateView.openInActivePerspective();
            view.showAnnotations(this.fCVSResource, listener.getCvsAnnotateBlocks(), listener.getContents());
        }
        catch (PartInitException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private AbstractDecoratedTextEditor getEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorReference[] references = window.getActivePage().getEditorReferences();
        IResource resource = this.fCVSResource.getIResource();
        if (resource == null) {
            return null;
        }
        int i = 0;
        while (i < references.length) {
            block16: {
                IEditorReference reference = references[i];
                try {
                    if (resource == null) break block16;
                    IEditorInput iEditorInput = reference.getEditorInput();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (resource.equals(iEditorInput.getAdapter((Class)clazz))) {
                        IEditorPart editor = reference.getEditor(false);
                        if (editor instanceof AbstractDecoratedTextEditor) {
                            return (AbstractDecoratedTextEditor)editor;
                        }
                        IEditorPart part = this.getPart().getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)resource), "org.eclipse.ui.DefaultTextEditor", true, 0);
                        if (part != null && part instanceof AbstractDecoratedTextEditor) {
                            return (AbstractDecoratedTextEditor)part;
                        }
                    }
                }
                catch (PartInitException partInitException) {}
            }
            ++i;
        }
        if (resource instanceof IFile) {
            try {
                IEditorPart part;
                IEditorDescriptor descrptr = IDE.getEditorDescriptor((IFile)((IFile)resource));
                if (descrptr.isInternal()) {
                    part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource));
                    if (part instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)part;
                    }
                    this.getPart().getSite().getPage().closeEditor(part, false);
                }
                if ((part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource), (String)"org.eclipse.ui.DefaultTextEditor")) != null && part instanceof AbstractDecoratedTextEditor) {
                    return (AbstractDecoratedTextEditor)part;
                }
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAnnotation(AnnotateListener listener, ICVSResource cvsResource, String revision, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        ICVSFolder folder = cvsResource.getParent();
        FolderSyncInfo info = folder.getFolderSyncInfo();
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
        Session session = new Session(location, folder, true);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
            try {
                IStatus status;
                CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                ArrayList<Object> localOptions = new ArrayList<Object>();
                if (revision != null) {
                    localOptions.add(Annotate.makeRevisionOption((String)revision));
                }
                if (this.binary) {
                    localOptions.add(Annotate.FORCE_BINARY_ANNOTATE);
                }
                if ((status = Command.ANNOTATE.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{cvsResource}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90))).getCode() == -10) {
                    throw new CVSServerException(status);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
                throw throwable;
            }
            {
                Object var12_14 = null;
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            session.close();
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        session.close();
    }

    private RevisionInformation createRevisionInformation(AnnotateListener listener, IProgressMonitor monitor) throws CVSException {
        HashMap<String, ILogEntry> logEntriesByRevision = new HashMap<String, ILogEntry>();
        if (this.fCVSResource instanceof ICVSFile) {
            try {
                ILogEntry[] logEntries = ((ICVSFile)this.fCVSResource).getLogEntries(Policy.subMonitorFor(monitor, 20));
                int i = 0;
                while (i < logEntries.length) {
                    ILogEntry entry = logEntries[i];
                    logEntriesByRevision.put(entry.getRevision(), entry);
                    ++i;
                }
            }
            catch (CVSException e) {
                throw e;
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        final CommitterColors colors = CommitterColors.getDefault();
        RevisionInformation info = new RevisionInformation();
        HashMap<String, Revision> sets = new HashMap<String, Revision>();
        List annotateBlocks = listener.getCvsAnnotateBlocks();
        Iterator blocks = annotateBlocks.iterator();
        while (blocks.hasNext()) {
            final CVSAnnotateBlock block = (CVSAnnotateBlock)blocks.next();
            final String revisionString = block.getRevision();
            Revision revision = (Revision)sets.get(revisionString);
            if (revision == null) {
                final ILogEntry entry = (ILogEntry)logEntriesByRevision.get(revisionString);
                if (entry == null) continue;
                revision = new Revision(){

                    public Object getHoverInfo() {
                        if (entry != null) {
                            return "<b>" + entry.getAuthor() + " " + entry.getRevision() + " " + DateFormat.getDateTimeInstance((int)2, (int)3).format(entry.getDate()) + "</b><p>" + entry.getComment() + "</p>";
                        }
                        return block.toString().substring(0, block.toString().indexOf(" ("));
                    }

                    private String getCommitterId() {
                        return block.toString().substring(0, block.toString().indexOf(32));
                    }

                    public String getId() {
                        return revisionString;
                    }

                    public Date getDate() {
                        return entry.getDate();
                    }

                    public RGB getColor() {
                        return colors.getCommitterRGB(this.getCommitterId());
                    }
                };
                sets.put(revisionString, revision);
                info.addRevision(revision);
            }
            revision.addRange((ILineRange)new LineRange(block.getStartLine(), block.getEndLine() - block.getStartLine() + 1));
        }
        return info;
    }

    private void fetchContents(AnnotateListener listener, IProgressMonitor monitor) {
        try {
            if (this.hasCharset(this.fCVSResource, listener.getContents())) {
                listener.setContents(this.getRemoteContents(this.fCVSResource, monitor));
            }
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
    }

    private InputStream getRemoteContents(ICVSResource resource, IProgressMonitor monitor) throws CoreException {
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)resource);
        if (remote == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        IStorage storage = ((IResourceVariant)remote).getStorage(monitor);
        if (storage == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return storage.getContents();
    }

    private String promptForPerspectiveSwitch() {
        IPerspectiveDescriptor current;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_change_perspective_on_show_annotations");
        String desiredID = store.getString("pref_default_perspective_for_show_annotations");
        if (option.equals("always")) {
            return desiredID;
        }
        if (option.equals("never")) {
            return null;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor desired = registry.findPerspectiveWithId(desiredID);
        IWorkbenchPage page = CVSUIPlugin.getActivePage();
        if (page != null && (current = page.getPerspective()) != null && current.getId().equals(desiredID)) {
            return null;
        }
        if (desired != null) {
            String desc = desired.getDescription();
            String message = desc == null ? NLS.bind((String)CVSUIMessages.ShowAnnotationOperation_2, (Object[])new String[]{desired.getLabel()}) : NLS.bind((String)CVSUIMessages.ShowAnnotationOperation_3, (Object[])new String[]{desired.getLabel(), desc});
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)CVSUIMessages.ShowAnnotationOperation_1, (String)message, (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_change_perspective_on_show_annotations");
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return desiredID;
                }
                case 3: {
                    return null;
                }
            }
        }
        return null;
    }

    private boolean promptForQuickDiffAnnotate() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_use_quickdiffannotate");
        if (option.equals("always")) {
            return true;
        }
        if (option.equals("never")) {
            return false;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)CVSUIMessages.ShowAnnotationOperation_QDAnnotateTitle, (String)CVSUIMessages.ShowAnnotationOperation_QDAnnotateMessage, (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_use_quickdiffannotate");
        int result = dialog.getReturnCode();
        switch (result) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return false;
    }
}

