/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.dialogs.EncodingFieldEditor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class RepositoryEncodingPropertyPage
extends PropertyPage
implements IPropertyChangeListener {
    private static final int LABEL_WIDTH_HINT = 400;
    private EncodingFieldEditor encoding;
    private ICVSRepositoryLocation location;
    private boolean valueChanged;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createWrappingLabel(composite, CVSUIMessages.RepositoryEncodingPropertyPage_2, 1);
        this.encoding = new EncodingFieldEditor("encoding", CVSUIMessages.RepositoryEncodingPropertyPage_3, composite);
        this.encoding.setPage((DialogPage)this);
        this.encoding.setPreferenceStore(this.getLocationPreferenceStore());
        this.encoding.load();
        this.encoding.setPropertyChangeListener((IPropertyChangeListener)this);
        this.createWrappingLabel(composite, CVSUIMessages.RepositoryEncodingPropertyPage_4, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.repository_encoding_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private IPreferenceStore getLocationPreferenceStore() {
        return new OSGIPreferenceStore(((CVSRepositoryLocation)this.location).getPreferences(), CVSRepositoryLocation.getDefaultPreferences());
    }

    private void initialize() {
        this.location = null;
        IAdaptable element = this.getElement();
        if (element instanceof ICVSRepositoryLocation) {
            this.location = (ICVSRepositoryLocation)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof ICVSRepositoryLocation) {
                this.location = (ICVSRepositoryLocation)adapter;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "field_editor_is_valid") {
            this.setValid((Boolean)event.getNewValue());
            return;
        }
        if (event.getProperty() == "field_editor_value") {
            this.valueChanged = true;
            return;
        }
    }

    public boolean performOk() {
        if (!KnownRepositories.getInstance().isKnownRepository(this.location.getLocation(false))) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)CVSUIMessages.RepositoryEncodingPropertyPage_0, (String)NLS.bind((String)CVSUIMessages.RepositoryEncodingPropertyPage_1, (Object[])new String[]{this.location.getLocation(true)}));
            return true;
        }
        this.encoding.store();
        try {
            ((CVSRepositoryLocation)this.location).getPreferences().flush();
        }
        catch (BackingStoreException e) {
            CVSUIPlugin.log((IStatus)new CVSStatus(4, CVSUIMessages.internal, (Throwable)e));
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.encoding.loadDefault();
    }

    private Label createWrappingLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    public class OSGIPreferenceStore
    implements IPreferenceStore {
        private Preferences preferences;
        private Preferences defaults;
        private boolean dirty;

        public OSGIPreferenceStore(Preferences preferences, Preferences defaults) {
            this.preferences = preferences;
            this.defaults = defaults;
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean contains(String name) {
            try {
                String[] keys = this.preferences.keys();
                int i = 0;
                while (true) {
                    if (i >= keys.length) {
                        return false;
                    }
                    String string = keys[i];
                    if (string.equals(name)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (BackingStoreException e) {
                CVSUIPlugin.log((IStatus)new CVSStatus(4, CVSUIMessages.internal, (Throwable)e));
                return false;
            }
        }

        public boolean getBoolean(String name) {
            return this.preferences.getBoolean(name, this.getDefaultBoolean(name));
        }

        public boolean getDefaultBoolean(String name) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(name, false);
            }
            return false;
        }

        public double getDefaultDouble(String name) {
            if (this.defaults != null) {
                return this.defaults.getDouble(name, 0.0);
            }
            return 0.0;
        }

        public float getDefaultFloat(String name) {
            if (this.defaults != null) {
                return this.defaults.getFloat(name, 0.0f);
            }
            return 0.0f;
        }

        public int getDefaultInt(String name) {
            if (this.defaults != null) {
                return this.defaults.getInt(name, 0);
            }
            return 0;
        }

        public long getDefaultLong(String name) {
            if (this.defaults != null) {
                return this.defaults.getLong(name, 0L);
            }
            return 0L;
        }

        public String getDefaultString(String name) {
            if (this.defaults != null) {
                return this.defaults.get(name, null);
            }
            return null;
        }

        public double getDouble(String name) {
            return this.preferences.getDouble(name, this.getDefaultDouble(name));
        }

        public float getFloat(String name) {
            return this.preferences.getFloat(name, this.getDefaultFloat(name));
        }

        public int getInt(String name) {
            return this.preferences.getInt(name, this.getDefaultInt(name));
        }

        public long getLong(String name) {
            return this.preferences.getLong(name, this.getDefaultLong(name));
        }

        public String getString(String name) {
            return this.preferences.get(name, this.getDefaultString(name));
        }

        public boolean isDefault(String name) {
            return !this.contains(name);
        }

        public boolean needsSaving() {
            return this.dirty;
        }

        public void putValue(String name, String value) {
            this.preferences.put(name, value);
            this.dirty = true;
        }

        public void setDefault(String name, double value) {
        }

        public void setDefault(String name, float value) {
        }

        public void setDefault(String name, int value) {
        }

        public void setDefault(String name, long value) {
        }

        public void setDefault(String name, String defaultObject) {
        }

        public void setDefault(String name, boolean value) {
        }

        public void setToDefault(String name) {
            this.preferences.remove(name);
            this.dirty = true;
        }

        public void setValue(String name, double value) {
            this.preferences.putDouble(name, value);
            this.dirty = true;
        }

        public void setValue(String name, float value) {
            this.preferences.putFloat(name, value);
            this.dirty = true;
        }

        public void setValue(String name, int value) {
            this.preferences.putInt(name, value);
            this.dirty = true;
        }

        public void setValue(String name, long value) {
            this.preferences.putLong(name, value);
            this.dirty = true;
        }

        public void setValue(String name, String value) {
            this.putValue(name, value);
        }

        public void setValue(String name, boolean value) {
            this.preferences.putBoolean(name, value);
            this.dirty = true;
        }
    }
}

