/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperManager;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkHelperService {
    private static final ILinkHelper[] CANT_GET_NO_HELP = new ILinkHelper[0];
    private NavigatorContentService contentService;
    private final Map linkHelpers = new HashMap();

    public LinkHelperService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public ILinkHelper[] getLinkHelpersFor(Object anObject) {
        LinkHelperDescriptor[] descriptors = LinkHelperManager.getInstance().getLinkHelpersFor(anObject, (INavigatorContentService)this.contentService);
        if (descriptors.length == 0) {
            return CANT_GET_NO_HELP;
        }
        LinkedHashSet<ILinkHelper> helpers = new LinkedHashSet<ILinkHelper>();
        int i = 0;
        while (i < descriptors.length) {
            helpers.add(this.getLinkHelper(descriptors[i]));
            ++i;
        }
        if (helpers.size() == 0) {
            return CANT_GET_NO_HELP;
        }
        return helpers.toArray(new ILinkHelper[helpers.size()]);
    }

    public ILinkHelper[] getLinkHelpersFor(IEditorInput input) {
        LinkHelperDescriptor[] descriptors = LinkHelperManager.getInstance().getLinkHelpersFor(input, (INavigatorContentService)this.contentService);
        if (descriptors.length == 0) {
            return CANT_GET_NO_HELP;
        }
        LinkedHashSet<ILinkHelper> helpers = new LinkedHashSet<ILinkHelper>();
        int i = 0;
        while (i < descriptors.length) {
            helpers.add(this.getLinkHelper(descriptors[i]));
            ++i;
        }
        if (helpers.size() == 0) {
            return CANT_GET_NO_HELP;
        }
        return helpers.toArray(new ILinkHelper[helpers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILinkHelper getLinkHelper(LinkHelperDescriptor descriptor) {
        ILinkHelper helper = (ILinkHelper)this.linkHelpers.get(descriptor);
        if (helper == null) {
            LinkHelperService linkHelperService = this;
            synchronized (linkHelperService) {
                if (helper == null) {
                    helper = descriptor.createLinkHelper();
                    this.linkHelpers.put(descriptor, helper);
                }
            }
        }
        return helper;
    }
}

