/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.internal.core.ContributedDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationComparator;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchConfigurationType;
import org.eclipse.debug.internal.core.LaunchMode;
import org.eclipse.debug.internal.core.sourcelookup.SourceContainerType;
import org.eclipse.debug.internal.core.sourcelookup.SourcePathComputer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchManager
extends PlatformObject
implements ILaunchManager,
IResourceChangeListener {
    private static final String DEBUG_CORE = "org.eclipse.debug.core";
    private static final String DEBUG_UI = "org.eclipse.debug.ui";
    private static final String EMPTY_STRING = "";
    protected static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    protected static final IStatus deleteAssociatedLaunchConfigs = new Status(1, "org.eclipse.debug.core", 225, "", null);
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    public static final int CHANGED = 2;
    public static final int TERMINATE = 3;
    private static HashMap fgNativeEnv = null;
    private static HashMap fgNativeEnvCasePreserved = null;
    protected static final IPath LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH = DebugPlugin.getDefault().getStateLocation().append(".launches");
    private List fLaunchConfigurationTypes = null;
    private Map fLaunchConfigurations = new HashMap(10);
    private String[] fSortedConfigNames = null;
    private List fLaunchConfigurationIndex = null;
    private Map fComparators = null;
    private Map fLaunchModes = null;
    private List fContributedDelegates = null;
    private List fLaunches = new ArrayList(10);
    private Set fLaunchSet = new HashSet(10);
    private ListenerList fListeners = new ListenerList();
    private ListenerList fLaunchesListeners = new ListenerList();
    private LaunchManagerVisitor fgVisitor;
    private boolean fListening = false;
    private ListenerList fLaunchConfigurationListeners = new ListenerList();
    private Map fSourceLocators = null;
    private ILaunchConfiguration fFrom;
    private ILaunchConfiguration fTo;
    private Map sourceContainerTypes;
    private Map sourcePathComputers;

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public void addLaunch(ILaunch launch) {
        if (this.internalAddLaunch(launch)) {
            this.fireUpdate(launch, 0);
            this.fireUpdate(new ILaunch[]{launch}, 0);
        }
    }

    public void addLaunchConfigurationListener(ILaunchConfigurationListener listener) {
        this.fLaunchConfigurationListeners.add((Object)listener);
    }

    public void addLaunches(ILaunch[] launches) {
        ArrayList<ILaunch> added = new ArrayList<ILaunch>(launches.length);
        int i = 0;
        while (i < launches.length) {
            if (this.internalAddLaunch(launches[i])) {
                added.add(launches[i]);
            }
            ++i;
        }
        if (!added.isEmpty()) {
            ILaunch[] addedLaunches = added.toArray(new ILaunch[added.size()]);
            this.fireUpdate(addedLaunches, 0);
            int i2 = 0;
            while (i2 < addedLaunches.length) {
                this.fireUpdate(launches[i2], 0);
                ++i2;
            }
        }
    }

    public void addLaunchListener(ILaunchesListener listener) {
        this.fLaunchesListeners.add((Object)listener);
    }

    public void addLaunchListener(ILaunchListener listener) {
        this.fListeners.add((Object)listener);
    }

    private void cacheNativeEnvironment(Map cache) {
        try {
            String nativeCommand = null;
            boolean isWin9xME = false;
            String fileName = null;
            if (Platform.getOS().equals("win32")) {
                String osName = System.getProperty("os.name");
                boolean bl = isWin9xME = osName != null && (osName.startsWith("Windows 9") || osName.startsWith("Windows ME"));
                if (isWin9xME) {
                    IPath stateLocation = DebugPlugin.getDefault().getStateLocation();
                    fileName = String.valueOf(stateLocation.toOSString()) + File.separator + "env.txt";
                    nativeCommand = "command.com /C set > " + fileName;
                } else {
                    nativeCommand = "cmd.exe /C set";
                }
            } else if (!Platform.getOS().equals("unknown")) {
                nativeCommand = "env";
            }
            if (nativeCommand == null) {
                return;
            }
            Process process = Runtime.getRuntime().exec(nativeCommand);
            if (isWin9xME) {
                Properties p = new Properties();
                File file = new File(fileName);
                FileInputStream stream = new FileInputStream(file);
                p.load(stream);
                stream.close();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                Enumeration<Object> enumeration = p.keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    cache.put(key, p.get(key));
                }
            } else {
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    int separator = line.indexOf(61);
                    if (separator > 0) {
                        String key = line.substring(0, separator);
                        String value = line.substring(separator + 1);
                        cache.put(key, value);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void clearAllLaunchConfigurations() {
        if (this.fLaunchConfigurationTypes != null) {
            this.fLaunchConfigurationTypes.clear();
        }
        if (this.fLaunchConfigurationIndex != null) {
            this.fLaunchConfigurationIndex.clear();
        }
    }

    protected void clearConfigNameCache() {
        this.fSortedConfigNames = null;
    }

    protected DebugException createDebugException(String message, Throwable throwable) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, message, throwable));
    }

    protected LaunchConfigurationInfo createInfoFromXML(InputStream stream) throws CoreException, ParserConfigurationException, IOException, SAXException {
        Element root = null;
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        parser.setErrorHandler(new DefaultHandler());
        root = parser.parse(new InputSource(stream)).getDocumentElement();
        LaunchConfigurationInfo info = new LaunchConfigurationInfo();
        info.initializeFromXML(root);
        return info;
    }

    protected List findLaunchConfigurations(IContainer container) {
        ArrayList list = new ArrayList(10);
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return list;
        }
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(list);
        try {
            container.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException coreException) {}
        Iterator iter = list.iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(list.size());
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            configs.add(this.getLaunchConfiguration(file));
        }
        return configs;
    }

    protected List findLocalLaunchConfigurations() {
        IPath containerPath = LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH;
        ArrayList<LaunchConfiguration> configs = new ArrayList<LaunchConfiguration>(10);
        final File directory = containerPath.toFile();
        if (directory.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return dir.equals(directory) && name.endsWith("launch");
                }
            };
            String[] files = directory.list(filter);
            int i = 0;
            while (i < files.length) {
                LaunchConfiguration config = new LaunchConfiguration(containerPath.append(files[i]));
                configs.add(config);
                ++i;
            }
        }
        return configs;
    }

    public void fireUpdate(ILaunch launch, int update) {
        this.getLaunchNotifier().notify(launch, update);
    }

    public void fireUpdate(ILaunch[] launches, int update) {
        this.getLaunchesNotifier().notify(launches, update);
    }

    public String generateUniqueLaunchConfigurationNameFrom(String baseName) {
        String trailer;
        int index = 1;
        int length = baseName.length();
        int copyIndex = baseName.lastIndexOf(" (");
        if (copyIndex > -1 && length > copyIndex + 2 && baseName.charAt(length - 1) == ')' && this.isNumber(trailer = baseName.substring(copyIndex + 2, length - 1))) {
            try {
                index = Integer.parseInt(trailer);
                baseName = baseName.substring(0, copyIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String newName = baseName;
        StringBuffer buffer = null;
        while (this.isExistingLaunchConfigurationName(newName)) {
            buffer = new StringBuffer(baseName);
            buffer.append(" (");
            buffer.append(String.valueOf(index));
            ++index;
            buffer.append(')');
            newName = buffer.toString();
        }
        return newName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getAllLaunchConfigurations() {
        if (this.fLaunchConfigurationIndex != null) return this.fLaunchConfigurationIndex;
        try {
            this.fLaunchConfigurationIndex = new ArrayList(20);
            List configs = this.findLocalLaunchConfigurations();
            this.verifyConfigurations(configs, this.fLaunchConfigurationIndex);
            configs = this.findLaunchConfigurations((IContainer)this.getWorkspaceRoot());
            this.verifyConfigurations(configs, this.fLaunchConfigurationIndex);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.hookResourceChangeListener();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.hookResourceChangeListener();
            return this.fLaunchConfigurationIndex;
        }
    }

    protected String[] getAllSortedConfigNames() {
        if (this.fSortedConfigNames == null) {
            ILaunchConfiguration[] configs = this.getLaunchConfigurations();
            this.fSortedConfigNames = new String[configs.length];
            int i = 0;
            while (i < configs.length) {
                this.fSortedConfigNames[i] = configs[i].getName();
                ++i;
            }
            Arrays.sort(this.fSortedConfigNames);
        }
        return this.fSortedConfigNames;
    }

    protected Comparator getComparator(String attributeName) {
        Map map = this.getComparators();
        return (Comparator)map.get(attributeName);
    }

    protected Map getComparators() {
        this.initializeComparators();
        return this.fComparators;
    }

    protected List getConfigsFromXML(Element root) throws CoreException {
        DebugException invalidFormat = new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchManager_Invalid_launch_configuration_index__18, null));
        if (!root.getNodeName().equalsIgnoreCase("launchConfigurations")) {
            throw invalidFormat;
        }
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(4);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element entry = (Element)node;
                String nodeName = entry.getNodeName();
                if (!nodeName.equals("launchConfiguration")) {
                    throw invalidFormat;
                }
                String memento = entry.getAttribute("memento");
                if (memento == null) {
                    throw invalidFormat;
                }
                configs.add(this.getLaunchConfiguration(memento));
            }
            ++i;
        }
        return configs;
    }

    protected ConfigurationNotifier getConfigurationNotifier() {
        return new ConfigurationNotifier();
    }

    protected List getContributedDelegates() {
        this.initializeContributedDelegates();
        return this.fContributedDelegates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDebugTarget[] getDebugTargets() {
        List list = this.fLaunches;
        synchronized (list) {
            ArrayList<IDebugTarget> allTargets = new ArrayList<IDebugTarget>(this.fLaunches.size());
            if (this.fLaunches.size() > 0) {
                Iterator e = this.fLaunches.iterator();
                while (e.hasNext()) {
                    IDebugTarget[] targets = ((ILaunch)e.next()).getDebugTargets();
                    int i = 0;
                    while (i < targets.length) {
                        allTargets.add(targets[i]);
                        ++i;
                    }
                }
            }
            return allTargets.toArray(new IDebugTarget[allTargets.size()]);
        }
    }

    private LaunchManagerVisitor getDeltaVisitor() {
        if (this.fgVisitor == null) {
            this.fgVisitor = new LaunchManagerVisitor();
        }
        return this.fgVisitor;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        Map configEnv = configuration.getAttribute(ATTR_ENVIRONMENT_VARIABLES, (Map)null);
        if (configEnv == null) {
            return null;
        }
        HashMap<String, String> env = null;
        env = new HashMap<String, String>();
        boolean append = configuration.getAttribute(ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        if (append) {
            env.putAll(this.getNativeEnvironmentCasePreserved());
        }
        Iterator iter = configEnv.entrySet().iterator();
        boolean win32 = Platform.getOS().equals("win32");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null) {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
            }
            boolean added = false;
            if (win32) {
                Object nativeValue = env.get(key);
                if (nativeValue != null) {
                    env.put(key, value);
                } else {
                    Iterator envIter = env.entrySet().iterator();
                    while (envIter.hasNext()) {
                        Map.Entry nativeEntry = envIter.next();
                        String nativeKey = (String)nativeEntry.getKey();
                        if (!nativeKey.equalsIgnoreCase(key)) continue;
                        nativeEntry.setValue(value);
                        added = true;
                        break;
                    }
                }
            }
            if (added) continue;
            env.put(key, value);
        }
        iter = env.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(env.size());
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    /*
     * Exception decompiling
     */
    protected LaunchConfigurationInfo getInfo(ILaunchConfiguration config) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 216->222)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ILaunchConfiguration getLaunchConfiguration(IFile file) {
        this.hookResourceChangeListener();
        return new LaunchConfiguration(file.getLocation());
    }

    public ILaunchConfiguration getLaunchConfiguration(String memento) throws CoreException {
        this.hookResourceChangeListener();
        return new LaunchConfiguration(memento);
    }

    public ILaunchConfiguration[] getLaunchConfigurations() {
        List allConfigs = this.getAllLaunchConfigurations();
        return allConfigs.toArray(new ILaunchConfiguration[allConfigs.size()]);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ILaunchConfigurationType type) throws CoreException {
        Iterator iter = this.getAllLaunchConfigurations().iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        while (iter.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iter.next();
            if (!config.getType().equals(type)) continue;
            configs.add(config);
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    protected List getLaunchConfigurations(IProject project) {
        Iterator iter = this.getAllLaunchConfigurations().iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        while (iter.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iter.next();
            IFile file = config.getFile();
            if (file == null || !file.getProject().equals((Object)project)) continue;
            configs.add(config);
        }
        return configs;
    }

    public ILaunchConfigurationType getLaunchConfigurationType(String id) {
        Iterator iter = this.getLaunchConfigurationTypeList().iterator();
        while (iter.hasNext()) {
            ILaunchConfigurationType type = (ILaunchConfigurationType)iter.next();
            if (!type.getIdentifier().equals(id)) continue;
            return type;
        }
        return null;
    }

    private List getLaunchConfigurationTypeList() {
        this.initializeLaunchConfigurationTypes();
        return this.fLaunchConfigurationTypes;
    }

    public ILaunchConfigurationType[] getLaunchConfigurationTypes() {
        List types = this.getLaunchConfigurationTypeList();
        return types.toArray(new ILaunchConfigurationType[types.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILaunch[] getLaunches() {
        List list = this.fLaunches;
        synchronized (list) {
            return this.fLaunches.toArray(new ILaunch[this.fLaunches.size()]);
        }
    }

    private LaunchesNotifier getLaunchesNotifier() {
        return new LaunchesNotifier();
    }

    public ILaunchMode getLaunchMode(String mode) {
        this.initializeLaunchModes();
        return (ILaunchMode)this.fLaunchModes.get(mode);
    }

    public ILaunchMode[] getLaunchModes() {
        this.initializeLaunchModes();
        Collection collection = this.fLaunchModes.values();
        return collection.toArray(new ILaunchMode[collection.size()]);
    }

    private LaunchNotifier getLaunchNotifier() {
        return new LaunchNotifier();
    }

    protected List getLocalLaunchConfigurations() {
        Iterator iter = this.getAllLaunchConfigurations().iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        while (iter.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iter.next();
            if (!config.isLocal()) continue;
            configs.add(config);
        }
        return configs;
    }

    public ILaunchConfiguration[] getMappedConfigurations(IResource resource) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = this.getLaunchConfigurations();
            IResource[] resources = null;
            int i = 0;
            while (i < configs.length) {
                resources = configs[i].getMappedResources();
                if (resources != null) {
                    int j = 0;
                    while (j < resources.length) {
                        if (resources[j].equals((Object)resource)) {
                            configurations.add(configs[i]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
        return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
    }

    public ILaunchConfiguration[] getMigrationCandidates() throws CoreException {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] candidates = this.getLaunchConfigurations();
        int i = 0;
        while (i < candidates.length) {
            if (candidates[i].isMigrationCandidate()) {
                configs.add(candidates[i]);
            }
            ++i;
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    public ILaunchConfiguration getMovedFrom(ILaunchConfiguration addedConfiguration) {
        if (addedConfiguration.equals(this.fTo)) {
            return this.fFrom;
        }
        return null;
    }

    public ILaunchConfiguration getMovedTo(ILaunchConfiguration removedConfiguration) {
        if (removedConfiguration.equals(this.fFrom)) {
            return this.fTo;
        }
        return null;
    }

    public synchronized Map getNativeEnvironment() {
        if (fgNativeEnv == null) {
            Map casePreserved = this.getNativeEnvironmentCasePreserved();
            if (Platform.getOS().equals("win32")) {
                fgNativeEnv = new HashMap();
                Iterator entries = casePreserved.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    String key = ((String)entry.getKey()).toUpperCase();
                    fgNativeEnv.put(key, entry.getValue());
                }
            } else {
                fgNativeEnv = new HashMap(casePreserved);
            }
        }
        return new HashMap(fgNativeEnv);
    }

    public synchronized Map getNativeEnvironmentCasePreserved() {
        if (fgNativeEnvCasePreserved == null) {
            fgNativeEnvCasePreserved = new HashMap();
            this.cacheNativeEnvironment(fgNativeEnvCasePreserved);
        }
        return new HashMap(fgNativeEnvCasePreserved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcess[] getProcesses() {
        List list = this.fLaunches;
        synchronized (list) {
            ArrayList<IProcess> allProcesses = new ArrayList<IProcess>(this.fLaunches.size());
            Iterator e = this.fLaunches.iterator();
            while (e.hasNext()) {
                IProcess[] processes = ((ILaunch)e.next()).getProcesses();
                int i = 0;
                while (i < processes.length) {
                    allProcesses.add(processes[i]);
                    ++i;
                }
            }
            return allProcesses.toArray(new IProcess[allProcesses.size()]);
        }
    }

    public ISourceContainerType getSourceContainerType(String id) {
        this.initializeSourceContainerTypes();
        return (ISourceContainerType)this.sourceContainerTypes.get(id);
    }

    public ISourceContainerType[] getSourceContainerTypes() {
        this.initializeSourceContainerTypes();
        Collection containers = this.sourceContainerTypes.values();
        return containers.toArray(new ISourceContainerType[containers.size()]);
    }

    public ISourcePathComputer getSourcePathComputer(ILaunchConfiguration configuration) throws CoreException {
        String id = null;
        id = configuration.getAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, (String)null);
        if (id == null) {
            return configuration.getType().getSourcePathComputer();
        }
        return this.getSourcePathComputer(id);
    }

    public ISourcePathComputer getSourcePathComputer(String id) {
        this.initializeSourceContainerTypes();
        return (ISourcePathComputer)this.sourcePathComputers.get(id);
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    private synchronized void hookResourceChangeListener() {
        if (!this.fListening) {
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 5);
            this.fListening = true;
        }
    }

    private synchronized void initializeComparators() {
        if (this.fComparators == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchConfigurationComparators");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fComparators = new HashMap(infos.length);
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                String attr = configurationElement.getAttribute("attribute");
                if (attr != null) {
                    this.fComparators.put(attr, new LaunchConfigurationComparator(configurationElement));
                } else {
                    Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format((String)DebugCoreMessages.LaunchManager_Invalid_launch_configuration_comparator_extension_defined_by_plug_in__0____attribute_not_specified_1, (Object[])new String[]{configurationElement.getContributor().getName()}), null);
                    DebugPlugin.log((IStatus)s);
                }
                ++i;
            }
        }
    }

    private synchronized void initializeContributedDelegates() {
        if (this.fContributedDelegates == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchDelegates");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fContributedDelegates = new ArrayList(infos.length);
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                ContributedDelegate delegate = new ContributedDelegate(configurationElement);
                this.fContributedDelegates.add(delegate);
                ++i;
            }
        }
    }

    private synchronized void initializeLaunchConfigurationTypes() {
        if (this.fLaunchConfigurationTypes == null) {
            this.hookResourceChangeListener();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchConfigurationTypes");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchConfigurationTypes = new ArrayList(infos.length);
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                LaunchConfigurationType configType = new LaunchConfigurationType(configurationElement);
                this.fLaunchConfigurationTypes.add(configType);
                ++i;
            }
        }
    }

    private synchronized void initializeLaunchModes() {
        if (this.fLaunchModes == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "launchModes");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchModes = new HashMap();
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                try {
                    LaunchMode mode = new LaunchMode(configurationElement);
                    this.fLaunchModes.put(mode.getIdentifier(), mode);
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
                ++i;
            }
        }
    }

    private synchronized void initializeSourceContainerTypes() {
        if (this.sourceContainerTypes == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "sourceContainerTypes");
            IConfigurationElement[] extensions = extensionPoint.getConfigurationElements();
            this.sourceContainerTypes = new HashMap();
            int i = 0;
            while (i < extensions.length) {
                this.sourceContainerTypes.put(extensions[i].getAttribute("id"), new SourceContainerType(extensions[i]));
                ++i;
            }
            extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "sourcePathComputers");
            extensions = extensionPoint.getConfigurationElements();
            this.sourcePathComputers = new HashMap();
            i = 0;
            while (i < extensions.length) {
                this.sourcePathComputers.put(extensions[i].getAttribute("id"), new SourcePathComputer(extensions[i]));
                ++i;
            }
        }
    }

    private synchronized void initializeSourceLocators() {
        if (this.fSourceLocators == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "sourceLocators");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fSourceLocators = new HashMap(infos.length);
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                String id = configurationElement.getAttribute("id");
                if (id != null) {
                    this.fSourceLocators.put(id, configurationElement);
                } else {
                    Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format((String)DebugCoreMessages.LaunchManager_Invalid_source_locator_extentsion_defined_by_plug_in____0_______id___not_specified_12, (Object[])new String[]{configurationElement.getContributor().getName()}), null);
                    DebugPlugin.log((IStatus)s);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAddLaunch(ILaunch launch) {
        List list = this.fLaunches;
        synchronized (list) {
            block4: {
                if (!this.fLaunches.contains(launch)) break block4;
                return false;
            }
            this.fLaunches.add(launch);
            this.fLaunchSet.add(launch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalRemoveLaunch(ILaunch launch) {
        if (launch == null) {
            return false;
        }
        List list = this.fLaunches;
        synchronized (list) {
            this.fLaunchSet.remove(launch);
            return this.fLaunches.remove(launch);
        }
    }

    public boolean isExistingLaunchConfigurationName(String name) {
        Object[] sortedConfigNames = this.getAllSortedConfigNames();
        int index = Arrays.binarySearch(sortedConfigNames, name);
        return index >= 0;
    }

    private boolean isNumber(String string) {
        int numChars = string.length();
        if (numChars == 0) {
            return false;
        }
        int i = 0;
        while (i < numChars) {
            if (!Character.isDigit(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ILaunch launch) {
        List list = this.fLaunches;
        synchronized (list) {
            return this.fLaunchSet.contains(launch);
        }
    }

    protected boolean isValid(ILaunchConfiguration config) {
        try {
            config.getType();
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 5020) {
                DebugPlugin.log(e);
            }
            return false;
        }
        return true;
    }

    protected void launchConfigurationAdded(ILaunchConfiguration config) {
        if (config.isWorkingCopy()) {
            return;
        }
        if (this.isValid(config)) {
            List allConfigs = this.getAllLaunchConfigurations();
            if (!allConfigs.contains(config)) {
                allConfigs.add(config);
                this.getConfigurationNotifier().notify(config, 0);
                this.clearConfigNameCache();
            }
        } else {
            this.launchConfigurationDeleted(config);
        }
    }

    protected void launchConfigurationChanged(ILaunchConfiguration config) {
        this.removeInfo(config);
        this.clearConfigNameCache();
        if (this.isValid(config)) {
            this.launchConfigurationAdded(config);
            this.getConfigurationNotifier().notify(config, 2);
        } else {
            this.launchConfigurationDeleted(config);
        }
    }

    protected void launchConfigurationDeleted(ILaunchConfiguration config) {
        this.removeInfo(config);
        this.getAllLaunchConfigurations().remove(config);
        this.getConfigurationNotifier().notify(config, 1);
        this.clearConfigNameCache();
    }

    public IPersistableSourceLocator newSourceLocator(String identifier) throws CoreException {
        this.initializeSourceLocators();
        IConfigurationElement config = (IConfigurationElement)this.fSourceLocators.get(identifier);
        if (config == null) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format((String)DebugCoreMessages.LaunchManager_Source_locator_does_not_exist___0__13, (Object[])new String[]{identifier}), null));
        }
        IPersistableSourceLocator sourceLocator = (IPersistableSourceLocator)config.createExecutableExtension("class");
        if (sourceLocator instanceof AbstractSourceLookupDirector) {
            ((AbstractSourceLookupDirector)sourceLocator).setId(identifier);
        }
        return sourceLocator;
    }

    protected void projectClosed(IProject project) {
        List configs = this.getLaunchConfigurations(project);
        if (!configs.isEmpty()) {
            Iterator iterator = configs.iterator();
            while (iterator.hasNext()) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)iterator.next();
                this.launchConfigurationDeleted(configuration);
            }
        }
        this.terminateMappedConfigurations((IResource)project);
    }

    protected void projectOpened(IProject project) {
        List configs = this.findLaunchConfigurations((IContainer)project);
        if (!configs.isEmpty()) {
            Iterator iterator = configs.iterator();
            while (iterator.hasNext()) {
                ILaunchConfiguration config = (ILaunchConfiguration)iterator.next();
                this.launchConfigurationAdded(config);
            }
        }
    }

    private void removeInfo(ILaunchConfiguration configuration) {
        this.fLaunchConfigurations.remove(configuration);
    }

    public void removeLaunch(ILaunch launch) {
        if (this.internalRemoveLaunch(launch)) {
            this.fireUpdate(launch, 1);
            this.fireUpdate(new ILaunch[]{launch}, 1);
        }
    }

    public void removeLaunchConfigurationListener(ILaunchConfigurationListener listener) {
        this.fLaunchConfigurationListeners.remove((Object)listener);
    }

    public void removeLaunches(ILaunch[] launches) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>(launches.length);
        int i = 0;
        while (i < launches.length) {
            if (this.internalRemoveLaunch(launches[i])) {
                removed.add(launches[i]);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            ILaunch[] removedLaunches = removed.toArray(new ILaunch[removed.size()]);
            this.fireUpdate(removedLaunches, 1);
            int i2 = 0;
            while (i2 < removedLaunches.length) {
                this.fireUpdate(removedLaunches[i2], 1);
                ++i2;
            }
        }
    }

    public void removeLaunchListener(ILaunchesListener listener) {
        this.fLaunchesListeners.remove((Object)listener);
    }

    public void removeLaunchListener(ILaunchListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            LaunchManagerVisitor visitor = this.getDeltaVisitor();
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                visitor.preDelete(project);
            }
        } else {
            try {
                IResourceDelta[] children = delta.getAffectedChildren(2);
                if (children.length > 0) {
                    ArrayList<IResource> projs = new ArrayList<IResource>();
                    IResource res = null;
                    int i = 0;
                    while (i < children.length) {
                        if (children[i].getFlags() != 8192 && (res = children[i].getResource()) != null && res instanceof IProject) {
                            projs.add(res);
                        }
                        ++i;
                    }
                    if (projs.size() > 0) {
                        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                        handler.handleStatus(deleteAssociatedLaunchConfigs, projs.toArray(new IProject[projs.size()]));
                        projs.clear();
                    }
                }
                LaunchManagerVisitor visitor = this.getDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                visitor.reset();
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
    }

    protected void setMovedFromTo(ILaunchConfiguration from, ILaunchConfiguration to) {
        this.fFrom = from;
        this.fTo = to;
    }

    public void shutdown() {
        this.fListeners = new ListenerList();
        this.fLaunchesListeners = new ListenerList();
        this.fLaunchConfigurationListeners = new ListenerList();
        ILaunch[] launches = this.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            try {
                IDisconnect disconnect;
                if (launch instanceof IDisconnect && (disconnect = (IDisconnect)((Object)launch)).canDisconnect()) {
                    disconnect.disconnect();
                }
                if (launch.canTerminate()) {
                    launch.terminate();
                }
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)((Object)e));
            }
            ++i;
        }
        this.clearAllLaunchConfigurations();
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void terminateMappedConfigurations(IResource resource) {
        ILaunch[] launches = this.getLaunches();
        ILaunchConfiguration[] configs = this.getMappedConfigurations(resource);
        try {
            int i = 0;
            while (i < launches.length) {
                int j = 0;
                while (j < configs.length) {
                    if (launches[i].getLaunchConfiguration().equals(configs[j]) & launches[i].canTerminate()) {
                        launches[i].terminate();
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
    }

    private void throwException(ILaunchConfiguration config, Throwable e) throws DebugException {
        IPath path = config.getLocation();
        throw this.createDebugException(MessageFormat.format((String)DebugCoreMessages.LaunchManager__0__occurred_while_reading_launch_configuration_file__1___1, (Object[])new String[]{e.toString(), path.toOSString()}), e);
    }

    protected void verifyConfigurations(List verify, List valid) {
        Iterator configs = verify.iterator();
        while (configs.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)configs.next();
            if (!this.isValid(config)) continue;
            valid.add(config);
        }
    }

    class ConfigurationNotifier
    implements ISafeRunnable {
        private ILaunchConfigurationListener fListener;
        private int fType;
        private ILaunchConfiguration fConfiguration;

        ConfigurationNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.LaunchManager_An_exception_occurred_during_launch_configuration_change_notification__3, exception);
            DebugPlugin.log((IStatus)status);
        }

        public void notify(ILaunchConfiguration configuration, int update) {
            this.fConfiguration = configuration;
            this.fType = update;
            if (LaunchManager.this.fLaunchConfigurationListeners.size() > 0) {
                Object[] listeners = LaunchManager.this.fLaunchConfigurationListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    this.fListener = (ILaunchConfigurationListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fConfiguration = null;
            this.fListener = null;
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchConfigurationAdded(this.fConfiguration);
                    break;
                }
                case 1: {
                    this.fListener.launchConfigurationRemoved(this.fConfiguration);
                    break;
                }
                case 2: {
                    this.fListener.launchConfigurationChanged(this.fConfiguration);
                }
            }
        }
    }

    class LaunchesNotifier
    implements ISafeRunnable {
        private ILaunchesListener fListener;
        private int fType;
        private ILaunch[] fNotifierLaunches;
        private ILaunch[] fRegistered;

        LaunchesNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.LaunchManager_An_exception_occurred_during_launch_change_notification__1, exception);
            DebugPlugin.log((IStatus)status);
        }

        public void notify(ILaunch[] launches, int update) {
            this.fNotifierLaunches = launches;
            this.fType = update;
            this.fRegistered = null;
            Object[] copiedListeners = LaunchManager.this.fLaunchesListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (ILaunchesListener)copiedListeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
            this.fNotifierLaunches = null;
            this.fRegistered = null;
            this.fListener = null;
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchesAdded(this.fNotifierLaunches);
                    break;
                }
                case 1: {
                    this.fListener.launchesRemoved(this.fNotifierLaunches);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fRegistered == null) {
                        ArrayList<ILaunch> registered = null;
                        int j = 0;
                        while (j < this.fNotifierLaunches.length) {
                            if (LaunchManager.this.isRegistered(this.fNotifierLaunches[j])) {
                                if (registered != null) {
                                    registered.add(this.fNotifierLaunches[j]);
                                }
                            } else if (registered == null) {
                                registered = new ArrayList<ILaunch>(this.fNotifierLaunches.length);
                                int k = 0;
                                while (k < j) {
                                    registered.add(this.fNotifierLaunches[k]);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        this.fRegistered = registered == null ? this.fNotifierLaunches : registered.toArray(new ILaunch[registered.size()]);
                    }
                    if (this.fRegistered.length <= 0) break;
                    if (this.fType == 2) {
                        this.fListener.launchesChanged(this.fRegistered);
                    }
                    if (this.fType != 3 || !(this.fListener instanceof ILaunchesListener2)) break;
                    ((ILaunchesListener2)this.fListener).launchesTerminated(this.fRegistered);
                }
            }
        }
    }

    class LaunchManagerVisitor
    implements IResourceDeltaVisitor {
        private Map fFileToConfig = new HashMap();

        LaunchManagerVisitor() {
        }

        public void preDelete(IProject project) {
            List list = LaunchManager.this.findLaunchConfigurations((IContainer)project);
            Iterator configs = list.iterator();
            while (configs.hasNext()) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)configs.next();
                IFile file = configuration.getFile();
                if (file == null) continue;
                this.fFileToConfig.put(file, configuration);
            }
        }

        public void reset() {
            this.fFileToConfig.clear();
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0) {
                if (delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    if (project.isOpen()) {
                        LaunchManager.this.projectOpened(project);
                    } else {
                        LaunchManager.this.projectClosed(project);
                    }
                }
                return false;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if ("launch".equals(file.getFileExtension())) {
                    IPath configPath = file.getLocation();
                    ILaunchConfiguration handle = null;
                    handle = configPath == null ? (ILaunchConfiguration)this.fFileToConfig.get(file) : new LaunchConfiguration(configPath);
                    if (handle != null) {
                        switch (delta.getKind()) {
                            case 1: {
                                LaunchManager.this.launchConfigurationAdded(handle);
                                break;
                            }
                            case 2: {
                                LaunchManager.this.launchConfigurationDeleted(handle);
                                break;
                            }
                            case 4: {
                                LaunchManager.this.launchConfigurationChanged(handle);
                            }
                        }
                    }
                }
                return false;
            }
            if (resource instanceof IContainer) {
                return true;
            }
            return true;
        }
    }

    class LaunchNotifier
    implements ISafeRunnable {
        private ILaunchListener fListener;
        private int fType;
        private ILaunch fLaunch;

        LaunchNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.LaunchManager_An_exception_occurred_during_launch_change_notification__1, exception);
            DebugPlugin.log((IStatus)status);
        }

        public void notify(ILaunch launch, int update) {
            this.fLaunch = launch;
            this.fType = update;
            Object[] copiedListeners = LaunchManager.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (ILaunchListener)copiedListeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
            this.fLaunch = null;
            this.fListener = null;
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchAdded(this.fLaunch);
                    break;
                }
                case 1: {
                    this.fListener.launchRemoved(this.fLaunch);
                    break;
                }
                case 2: {
                    if (!LaunchManager.this.isRegistered(this.fLaunch)) break;
                    this.fListener.launchChanged(this.fLaunch);
                }
            }
        }
    }

    class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private List fList;

        protected ResourceProxyVisitor(List list) {
            this.fList = list;
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.getType() == 1) {
                if ("launch".equalsIgnoreCase(proxy.requestFullPath().getFileExtension())) {
                    this.fList.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

