/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.TypeInfo;

public class JarFileEntryTypeInfo
extends TypeInfo {
    private final String fJar;
    private final String fFileName;
    private final String fExtension;
    static /* synthetic */ Class class$0;

    public JarFileEntryTypeInfo(String pkg, String name, char[][] enclosingTypes, int modifiers, String jar, String fileName, String extension) {
        super(pkg, name, enclosingTypes, modifiers);
        this.fJar = jar;
        this.fFileName = fileName;
        this.fExtension = extension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.util.JarFileEntryTypeInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(obj.getClass())) {
            return false;
        }
        JarFileEntryTypeInfo other = (JarFileEntryTypeInfo)obj;
        return this.doEquals(other) && this.fJar.equals(other.fJar) && this.fFileName.equals(other.fFileName) && this.fExtension.equals(other.fExtension);
    }

    public int getElementType() {
        return 2;
    }

    public String getJar() {
        return this.fJar;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public String getExtension() {
        return this.fExtension;
    }

    protected IJavaElement getContainer(IJavaSearchScope scope) throws JavaModelException {
        IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IPath[] enclosedPaths = scope.enclosingProjectsAndJars();
        int i = 0;
        while (i < enclosedPaths.length) {
            IJavaProject jproject;
            IPackageFragmentRoot root;
            IPath curr = enclosedPaths[i];
            if (curr.segmentCount() == 1 && (root = (jproject = jmodel.getJavaProject(curr.segment(0))).getPackageFragmentRoot(this.fJar)).exists()) {
                return this.findElementInRoot(root);
            }
            ++i;
        }
        List<IPath> paths = Arrays.asList(enclosedPaths);
        IJavaProject[] projects = jmodel.getJavaProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            IPackageFragmentRoot root;
            IJavaProject jproject = projects[i2];
            if (!paths.contains(jproject.getPath()) && (root = jproject.getPackageFragmentRoot(this.fJar)).exists()) {
                return this.findElementInRoot(root);
            }
            ++i2;
        }
        return null;
    }

    private IJavaElement findElementInRoot(IPackageFragmentRoot root) {
        IClassFile res;
        IPackageFragment frag = root.getPackageFragment(this.getPackageName());
        String extension = this.getExtension();
        String fullName = String.valueOf(this.getFileName()) + '.' + extension;
        if ("class".equals(extension)) {
            res = frag.getClassFile(fullName);
        } else if (JavaCore.isJavaLikeFileName((String)fullName)) {
            res = frag.getCompilationUnit(fullName);
        } else {
            return null;
        }
        if (res.exists()) {
            return res;
        }
        return null;
    }

    public IPath getPackageFragmentRootPath() {
        return new Path(this.fJar);
    }

    public String getPackageFragmentRootName() {
        return this.fJar;
    }

    public String getPath() {
        StringBuffer result = new StringBuffer(this.fJar);
        result.append("|");
        this.getElementPath(result);
        return result.toString();
    }

    public long getContainerTimestamp() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(this.fJar);
        IResource resource = root.findMember((IPath)path);
        IFileInfo info = null;
        IPackageFragmentRoot element = null;
        if (resource != null && resource.exists()) {
            URI location = resource.getLocationURI();
            if (location != null) {
                try {
                    info = EFS.getStore((URI)location).fetchInfo();
                    if (info.exists() && (element = JavaCore.create((IResource)resource)) != null && !element.exists()) {
                        element = null;
                    }
                }
                catch (CoreException coreException) {}
            }
        } else {
            info = EFS.getLocalFileSystem().getStore(Path.fromOSString((String)this.fJar)).fetchInfo();
            if (info.exists()) {
                element = this.getPackageFragementRootForExternalJar();
            }
        }
        if (info != null && info.exists() && element != null) {
            return info.getLastModified();
        }
        return -1L;
    }

    public boolean isContainerDirty() {
        return false;
    }

    private void getElementPath(StringBuffer result) {
        String pack = this.getPackageName();
        if (pack != null && pack.length() > 0) {
            result.append(pack.replace('.', '/'));
            result.append('/');
        }
        result.append(this.getFileName());
        result.append('.');
        result.append(this.getExtension());
    }

    private IPackageFragmentRoot getPackageFragementRootForExternalJar() {
        try {
            IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] projects = jmodel.getJavaProjects();
            int i = 0;
            while (i < projects.length) {
                IJavaProject project = projects[i];
                IPackageFragmentRoot root = project.getPackageFragmentRoot(this.fJar);
                if (project.isOnClasspath((IJavaElement)root)) {
                    return root;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }
}

