/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;

public class Resources {
    private Resources() {
    }

    public static IStatus checkInSync(IResource resource) {
        return Resources.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = Resources.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public static IStatus makeCommittable(IResource resource, Object context) {
        return Resources.makeCommittable(new IResource[]{resource}, context);
    }

    public static IStatus makeCommittable(IResource[] resources, Object context) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1 && Resources.isReadOnly(resource)) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        if (readOnlyFiles.size() == 0) {
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
        Map oldTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), context);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        Map newTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        Iterator iter = oldTimeStamps.keySet().iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            modified = Resources.addModified(modified, file);
        }
        if (modified != null) {
            return modified;
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addModified(IStatus status, IFile file) {
        IStatus entry = JavaUIStatus.createError(10003, Messages.format(CorextMessages.Resources_fileModified, file.getFullPath().toString()), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(JavaPlugin.getPluginId(), 10003, CorextMessages.Resources_modifiedResources, null);
        result.add(status);
        result.add(entry);
        return result;
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, Messages.format(CorextMessages.Resources_outOfSync, resource.getFullPath().toString()), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, CorextMessages.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    public static String[] getLocationOSStrings(IResource[] resources) {
        ArrayList<String> result = new ArrayList<String>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                result.add(location.toOSString());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getLocationString(IResource resource) {
        URI uri = resource.getLocationURI();
        if (uri == null) {
            return null;
        }
        return "file".equalsIgnoreCase(uri.getScheme()) ? new File(uri).getAbsolutePath() : uri.toString();
    }

    public static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    static void setReadOnly(IResource resource, boolean readOnly) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return;
        }
        resourceAttributes.setReadOnly(readOnly);
        try {
            resource.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }
}

