/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.MessageWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DeleteWizard
extends RefactoringWizard {
    public DeleteWizard(Refactoring refactoring) {
        super(refactoring, 92);
        this.setDefaultPageTitle(RefactoringMessages.DeleteWizard_1);
        ((JavaDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor()).setQueries(new ReorgQueries((Wizard)this));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new DeleteInputPage());
    }

    public int getMessageLineWidthInChars() {
        return 0;
    }

    public boolean needsProgressMonitor() {
        DeleteRefactoring refactoring = (DeleteRefactoring)this.getRefactoring();
        RefactoringProcessor processor = refactoring.getProcessor();
        if (processor instanceof JavaDeleteProcessor) {
            return ((JavaDeleteProcessor)processor).needsProgressMonitor();
        }
        return super.needsProgressMonitor();
    }

    private static class DeleteInputPage
    extends MessageWizardPage {
        private static final String PAGE_NAME = "DeleteInputPage";
        private static final String DIALOG_SETTINGS_DELETE_SUB_PACKAGES = "deleteSubPackages";
        private Button fDeleteSubPackagesCheckBox;

        public DeleteInputPage() {
            super(PAGE_NAME, true, 2);
        }

        protected String getMessageString() {
            try {
                if (1 == this.numberOfSelectedElements()) {
                    String pattern = this.createConfirmationStringForOneElement();
                    String name = this.getNameOfSingleSelectedElement();
                    return Messages.format(pattern, new String[]{name});
                }
                String pattern = this.createConfirmationStringForManyElements();
                return Messages.format(pattern, new String[]{String.valueOf(this.numberOfSelectedElements())});
            }
            catch (JavaModelException e) {
                if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                    JavaPlugin.log(e);
                }
                this.setPageComplete(false);
                if (e.isDoesNotExist()) {
                    return RefactoringMessages.DeleteWizard_12;
                }
                return RefactoringMessages.DeleteWizard_2;
            }
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (this.getDeleteProcessor().hasSubPackagesToDelete()) {
                this.addDeleteSubPackagesCheckBox();
            }
        }

        private void addDeleteSubPackagesCheckBox() {
            Composite c = new Composite((Composite)this.getControl(), 0);
            GridLayout gd = new GridLayout();
            gd.horizontalSpacing = 10;
            c.setLayout((Layout)gd);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            c.setLayoutData((Object)data);
            boolean selection = this.getRefactoringSettings().getBoolean(DIALOG_SETTINGS_DELETE_SUB_PACKAGES);
            this.fDeleteSubPackagesCheckBox = new Button(c, 32);
            this.fDeleteSubPackagesCheckBox.setText(RefactoringMessages.DeleteWizard_also_delete_sub_packages);
            this.fDeleteSubPackagesCheckBox.setSelection(selection);
            this.fDeleteSubPackagesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DeleteInputPage this$1;
                {
                    this.this$1 = deleteInputPage;
                }

                public void widgetSelected(SelectionEvent event) {
                    DeleteInputPage.access$0(this.this$1).setDeleteSubPackages(DeleteInputPage.access$1(this.this$1).getSelection());
                }
            });
            this.getDeleteProcessor().setDeleteSubPackages(this.fDeleteSubPackagesCheckBox.getSelection());
        }

        private String getNameOfSingleSelectedElement() throws JavaModelException {
            if (this.getSingleSelectedResource() != null) {
                return ReorgUtils.getName(this.getSingleSelectedResource());
            }
            return ReorgUtils.getName(this.getSingleSelectedJavaElement());
        }

        private IJavaElement getSingleSelectedJavaElement() {
            IJavaElement[] elements = this.getSelectedJavaElements();
            return elements.length == 1 ? elements[0] : null;
        }

        private IResource getSingleSelectedResource() {
            IResource[] resources = this.getSelectedResources();
            return resources.length == 1 ? resources[0] : null;
        }

        private int numberOfSelectedElements() {
            return this.getSelectedJavaElements().length + this.getSelectedResources().length;
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getDeleteProcessor().wasCanceled();
        }

        protected boolean saveSettings() {
            if (this.getContainer() instanceof Dialog) {
                return ((Dialog)this.getContainer()).getReturnCode() == 0;
            }
            return true;
        }

        public void dispose() {
            if (this.fDeleteSubPackagesCheckBox != null && this.saveSettings()) {
                this.getRefactoringSettings().put(DIALOG_SETTINGS_DELETE_SUB_PACKAGES, this.fDeleteSubPackagesCheckBox.getSelection());
            }
            super.dispose();
        }

        private String createConfirmationStringForOneElement() throws JavaModelException {
            IJavaElement[] elements = this.getSelectedJavaElements();
            if (elements.length == 1) {
                IJavaElement element = elements[0];
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(element)) {
                    return RefactoringMessages.DeleteWizard_3;
                }
                if (!DeleteInputPage.isLinkedResource(element)) {
                    return RefactoringMessages.DeleteWizard_4;
                }
                if (DeleteInputPage.isLinkedPackageOrPackageFragmentRoot(element)) {
                    return RefactoringMessages.DeleteWizard_6;
                }
                return RefactoringMessages.DeleteWizard_5;
            }
            if (DeleteInputPage.isLinked(this.getSelectedResources()[0])) {
                return RefactoringMessages.DeleteWizard_7;
            }
            return RefactoringMessages.DeleteWizard_8;
        }

        private String createConfirmationStringForManyElements() throws JavaModelException {
            IJavaElement[] javaElements;
            IResource[] resources = this.getSelectedResources();
            if (!DeleteInputPage.containsLinkedResources(resources, javaElements = this.getSelectedJavaElements())) {
                return RefactoringMessages.DeleteWizard_9;
            }
            if (!DeleteInputPage.containsLinkedPackagesOrPackageFragmentRoots(javaElements)) {
                return RefactoringMessages.DeleteWizard_10;
            }
            return RefactoringMessages.DeleteWizard_11;
        }

        private static boolean isLinkedPackageOrPackageFragmentRoot(IJavaElement element) {
            if (element instanceof IPackageFragment || element instanceof IPackageFragmentRoot) {
                return DeleteInputPage.isLinkedResource(element);
            }
            return false;
        }

        private static boolean containsLinkedPackagesOrPackageFragmentRoots(IJavaElement[] javaElements) {
            int i = 0;
            while (i < javaElements.length) {
                IJavaElement element = javaElements[i];
                if (DeleteInputPage.isLinkedPackageOrPackageFragmentRoot(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean containsLinkedResources(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
            int i = 0;
            while (i < javaElements.length) {
                IJavaElement element = javaElements[i];
                if (DeleteInputPage.isLinkedResource(element)) {
                    return true;
                }
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(element)) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (DeleteInputPage.isLinked(resource)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isDefaultPackageWithLinkedFiles(Object firstElement) throws JavaModelException {
            if (!JavaElementUtil.isDefaultPackage(firstElement)) {
                return false;
            }
            IPackageFragment defaultPackage = (IPackageFragment)firstElement;
            ICompilationUnit[] cus = defaultPackage.getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                if (DeleteInputPage.isLinkedResource((IJavaElement)cus[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isLinkedResource(IJavaElement element) {
            return DeleteInputPage.isLinked(ReorgUtils.getResource(element));
        }

        private static boolean isLinked(IResource resource) {
            return resource != null && resource.isLinked();
        }

        private IJavaElement[] getSelectedJavaElements() {
            return this.getDeleteProcessor().getJavaElementsToDelete();
        }

        private IResource[] getSelectedResources() {
            return this.getDeleteProcessor().getResourcesToDelete();
        }

        private JavaDeleteProcessor getDeleteProcessor() {
            return (JavaDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor();
        }

        static /* synthetic */ JavaDeleteProcessor access$0(DeleteInputPage deleteInputPage) {
            return deleteInputPage.getDeleteProcessor();
        }

        static /* synthetic */ Button access$1(DeleteInputPage deleteInputPage) {
            return deleteInputPage.fDeleteSubPackagesCheckBox;
        }
    }
}

