/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

class RenameTypeWizardSimilarElementsPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "SimilarElementSelectionPage";
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private Label fSimilarElementsLabel;
    private SourceViewer fSourceViewer;
    private ContainerCheckedTreeViewer fTreeViewer;
    private SimilarLabelProvider fTreeViewerLabelProvider;
    private Map fSimilarElementsToNewName;
    private Button fEditElementButton;
    private boolean fWasInitialized;
    private CLabel fCurrentElementLabel;

    public RenameTypeWizardSimilarElementsPage() {
        super(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        ViewForm viewForm = new ViewForm(parent, 0x800800);
        Composite inner = new Composite((Composite)viewForm, 0);
        GridLayout layout = new GridLayout();
        inner.setLayout((Layout)layout);
        this.createTreeAndSourceViewer(inner);
        this.createButtonComposite(inner);
        viewForm.setContent((Control)inner);
        this.setControl((Control)viewForm);
        Dialog.applyDialogFont((Control)viewForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.rename_type_wizard_page_context");
    }

    private void createTreeAndSourceViewer(Composite superComposite) {
        SashForm composite = new SashForm(superComposite, 256);
        this.initializeDialogUnits((Control)superComposite);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createSimilarElementTreeComposite((Composite)composite);
        this.createSourceViewerComposite((Composite)composite);
        composite.setWeights(new int[]{50, 50});
    }

    private void createSimilarElementTreeComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createTypeHierarchyLabel(composite);
        this.createTreeViewer(composite);
    }

    private void createTypeHierarchyLabel(Composite composite) {
        this.fSimilarElementsLabel = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.heightHint = JavaElementImageProvider.SMALL_SIZE.x;
        this.fSimilarElementsLabel.setLayoutData((Object)gd);
        this.fSimilarElementsLabel.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_review_similar_elements);
    }

    private void createTreeViewer(Composite composite) {
        Tree tree = new Tree(composite, 2852);
        tree.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new ContainerCheckedTreeViewer(tree);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setSorter((ViewerSorter)new SimilarElementSorter());
        this.fTreeViewer.setContentProvider((IContentProvider)new SimilarElementTreeContentProvider());
        this.fTreeViewerLabelProvider = new SimilarLabelProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeViewerLabelProvider);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RenameTypeWizardSimilarElementsPage.this.treeViewerSelectionChanged(event);
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RenameTypeWizardSimilarElementsPage.this.editCurrentElement();
            }
        });
    }

    private void createSourceViewerComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        this.createSourceViewerLabel(c);
        this.createSourceViewer(c);
    }

    private void createSourceViewerLabel(Composite c) {
        this.fCurrentElementLabel = new CLabel(c, 0);
        GridData gd = new GridData(768);
        gd.heightHint = JavaElementImageProvider.SMALL_SIZE.x;
        this.fCurrentElementLabel.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_select_element_to_view_source);
        this.fCurrentElementLabel.setLayoutData((Object)gd);
    }

    private void createSourceViewer(Composite c) {
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fSourceViewer = new JavaSourceViewer(c, null, null, false, 68354, store);
        this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(RenameTypeWizardSimilarElementsPage.getJavaTextTools().getColorManager(), store, null, null));
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        Document document = new Document();
        RenameTypeWizardSimilarElementsPage.getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
        this.fSourceViewer.setDocument((IDocument)document);
    }

    private static JavaTextTools getJavaTextTools() {
        return JavaPlugin.getDefault().getJavaTextTools();
    }

    private void createButtonComposite(Composite superComposite) {
        Composite buttonComposite = new Composite(superComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        Button returnToDefaults = new Button(buttonComposite, 8);
        returnToDefaults.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_restore_defaults);
        returnToDefaults.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(returnToDefaults);
        returnToDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameTypeWizardSimilarElementsPage.this.resetDataInRefAndUI();
            }
        });
        this.fEditElementButton = new Button(buttonComposite, 8);
        this.fEditElementButton.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_change_name);
        this.fEditElementButton.setLayoutData((Object)new GridData());
        this.fEditElementButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fEditElementButton);
        this.fEditElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameTypeWizardSimilarElementsPage.this.editCurrentElement();
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeUIFromRef();
        }
        super.setVisible(visible);
        this.selectFirstElement();
    }

    private void selectFirstElement() {
        TreeItem item;
        if (this.fTreeViewer.getTree().getItemCount() > 0 && (item = this.fTreeViewer.getTree().getItem(0)).getData() != null) {
            this.fTreeViewer.reveal(item.getData());
            Object data = this.getFirstSimilarElement(item);
            if (data != null) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(data));
            }
        }
        this.fTreeViewer.getTree().setFocus();
    }

    private Object getFirstSimilarElement(TreeItem item) {
        Object data = item.getData();
        if (this.isSimilarElement(data)) {
            return data;
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            Object childData = this.getFirstSimilarElement(children[i]);
            if (childData != null) {
                return childData;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeUIFromRef() {
        Map elementsToNewNames = this.getRenameTypeProcessor().getSimilarElementsToNewNames();
        try {
            this.getShell().setRedraw(false);
            if (this.fSimilarElementsToNewName == null || elementsToNewNames != this.fSimilarElementsToNewName) {
                this.fSimilarElementsToNewName = elementsToNewNames;
                this.fTreeViewerLabelProvider.initialize(this.fSimilarElementsToNewName);
                this.fTreeViewer.setInput((Object)this.fSimilarElementsToNewName);
            }
            this.fTreeViewer.expandAll();
            this.restoreSelectionAndNames(this.getRenameTypeProcessor().getSimilarElementsToSelection());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getShell().setRedraw(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getShell().setRedraw(true);
        this.fWasInitialized = true;
    }

    private void initializeRefFromUI() {
        IJavaElement[] selected = this.getCheckedSimilarElements();
        Map selection = this.getRenameTypeProcessor().getSimilarElementsToSelection();
        Iterator iter = selection.keySet().iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            selection.put(element, Boolean.FALSE);
        }
        int i = 0;
        while (i < selected.length) {
            selection.put(selected[i], Boolean.TRUE);
            ++i;
        }
    }

    private void resetDataInRefAndUI() {
        this.getRenameTypeProcessor().resetSelectedSimilarElements();
        this.restoreSelectionAndNames(this.getRenameTypeProcessor().getSimilarElementsToSelection());
    }

    protected void editCurrentElement() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection != null && this.isSimilarElement(selection.getFirstElement())) {
            String changedName;
            IJavaElement element = (IJavaElement)selection.getFirstElement();
            String newName = (String)this.fSimilarElementsToNewName.get(element);
            if (newName == null) {
                return;
            }
            EditElementDialog dialog = new EditElementDialog(this.getShell(), element, newName);
            if (dialog.open() == 0 && !(changedName = dialog.getNewName()).equals(newName)) {
                this.fSimilarElementsToNewName.put(element, changedName);
                this.fTreeViewer.update((Object)element, null);
            }
        }
    }

    private void restoreSelectionAndNames(Map selection) {
        Map selectedElements = selection;
        Iterator iter = selectedElements.keySet().iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            boolean isSelected = (Boolean)selectedElements.get(element);
            this.fTreeViewer.setChecked((Object)element, isSelected);
            this.fTreeViewer.update((Object)element, null);
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage;
        if (this.fWasInitialized) {
            this.initializeRefFromUI();
        }
        if ((nextPage = super.getNextPage()) != this) {
            nextPage.setPreviousPage((IWizardPage)this);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage() {
        if (this.fWasInitialized) {
            this.initializeRefFromUI();
        }
        return super.getPreviousPage();
    }

    protected boolean performFinish() {
        this.initializeRefFromUI();
        return super.performFinish();
    }

    private boolean isSimilarElement(Object element) {
        if (!this.fWasInitialized) {
            return false;
        }
        return this.fSimilarElementsToNewName.containsKey(element);
    }

    private void treeViewerSelectionChanged(SelectionChangedEvent event) {
        try {
            IJavaElement selection = this.getFirstSelectedSourceReference(event);
            this.setSourceViewerContents(selection);
            this.fEditElementButton.setEnabled(selection != null && this.isSimilarElement(selection));
            this.fCurrentElementLabel.setText(selection != null ? JavaElementLabels.getElementLabel(selection, this.LABEL_FLAGS) : RefactoringMessages.RenameTypeWizardSimilarElementsPage_select_element_to_view_source);
            this.fCurrentElementLabel.setImage(selection != null ? this.fTreeViewerLabelProvider.getJavaImage(selection) : null);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.RenameTypeWizard_defaultPageTitle, RefactoringMessages.RenameTypeWizard_unexpected_exception);
        }
    }

    private IJavaElement getFirstSelectedSourceReference(SelectionChangedEvent event) {
        ISelection s = event.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection strSel = (IStructuredSelection)s;
        if (strSel.size() != 1) {
            return null;
        }
        Object first = strSel.getFirstElement();
        if (!(first instanceof IJavaElement)) {
            return null;
        }
        return (IJavaElement)first;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSourceViewerContents(IJavaElement el) throws JavaModelException {
        String EMPTY = "";
        if (el == null) {
            this.fSourceViewer.getDocument().set(EMPTY);
            return;
        }
        ICompilationUnit element = (ICompilationUnit)el.getAncestor(5);
        if (element == null) {
            this.fSourceViewer.getDocument().set(EMPTY);
            return;
        }
        String contents = element.getSource();
        try {
            this.fSourceViewer.setRedraw(false);
            this.fSourceViewer.getDocument().set(contents == null ? EMPTY : contents);
            ISourceRange sr = this.getNameRange(el);
            if (sr != null) {
                this.fSourceViewer.setSelectedRange(sr.getOffset(), sr.getLength());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fSourceViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.fSourceViewer.setRedraw(true);
    }

    private ISourceRange getNameRange(IJavaElement element) throws JavaModelException {
        if (element instanceof IMember) {
            return ((IMember)element).getNameRange();
        }
        if (element instanceof ILocalVariable) {
            return ((ILocalVariable)element).getNameRange();
        }
        return null;
    }

    private IJavaElement[] getCheckedSimilarElements() {
        Object[] checked = this.fTreeViewer.getCheckedElements();
        ArrayList<Object> elements = new ArrayList<Object>(checked.length);
        int i = 0;
        while (i < checked.length) {
            if (this.isSimilarElement(checked[i])) {
                elements.add(checked[i]);
            }
            ++i;
        }
        return elements.toArray(new IJavaElement[elements.size()]);
    }

    public RenameTypeProcessor getRenameTypeProcessor() {
        RefactoringProcessor proc = ((RenameRefactoring)this.getRefactoring()).getProcessor();
        if (proc instanceof RenameTypeProcessor) {
            return (RenameTypeProcessor)proc;
        }
        if (proc instanceof RenameCompilationUnitProcessor) {
            RenameCompilationUnitProcessor rcu = (RenameCompilationUnitProcessor)proc;
            return rcu.getRenameTypeProcessor();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static class EditElementDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fNameField;
        private IJavaElement fElementToEdit;

        public EditElementDialog(Shell parent, IJavaElement elementToEdit, String newName) {
            super(parent);
            this.setTitle(RefactoringMessages.RenameTypeWizardSimilarElementsPage_change_element_name);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fElementToEdit = elementToEdit;
            this.fNameField = new StringDialogField();
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_enter_new_name);
            this.fNameField.setText(newName);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fNameField}, true, -1, -1);
            this.fNameField.postSetFocusOnDialogField(parent.getDisplay());
            LayoutUtil.setWidthHint((Control)this.fNameField.getLabelControl(null), this.convertHorizontalDLUsToPixels(300));
            Text text = this.fNameField.getTextControl(null);
            LayoutUtil.setHorizontalGrabbing((Control)text);
            TextFieldNavigationHandler.install(text);
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fNameField) {
                this.updateStatus(this.validateSettings());
            }
        }

        private IStatus validateSettings() {
            String name = this.fNameField.getText();
            if (name.length() == 0) {
                return new StatusInfo(4, RefactoringMessages.RenameTypeWizardSimilarElementsPage_name_empty);
            }
            IStatus status = JavaConventions.validateIdentifier((String)name);
            if (status.matches(4)) {
                return status;
            }
            if (!Checks.startsWithLowerCase(name)) {
                return new StatusInfo(2, RefactoringMessages.RenameTypeWizardSimilarElementsPage_name_should_start_lowercase);
            }
            if (this.fElementToEdit instanceof IMember && ((IMember)this.fElementToEdit).getDeclaringType() != null) {
                IMethod m;
                IField f;
                IType type = ((IMember)this.fElementToEdit).getDeclaringType();
                if (this.fElementToEdit instanceof IField && (f = type.getField(name)).exists()) {
                    return new StatusInfo(4, RefactoringMessages.RenameTypeWizardSimilarElementsPage_field_exists);
                }
                if (this.fElementToEdit instanceof IMethod && (m = type.getMethod(name, ((IMethod)this.fElementToEdit).getParameterTypes())).exists()) {
                    return new StatusInfo(4, RefactoringMessages.RenameTypeWizardSimilarElementsPage_method_exists);
                }
            }
            return StatusInfo.OK_STATUS;
        }

        public String getNewName() {
            return this.fNameField.getText();
        }
    }

    private static class SimilarElementTreeContentProvider
    implements ITreeContentProvider {
        private Map fTreeElementMap;
        private Set fTopLevelElements;

        private SimilarElementTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Set children = (Set)this.fTreeElementMap.get(parentElement);
            if (children != null) {
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IMember || element instanceof ILocalVariable) {
                return ((IJavaElement)element).getParent();
            }
            if (element instanceof ICompilationUnit) {
                return null;
            }
            Assert.isTrue((boolean)false, (String)"Should not get here");
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.fTreeElementMap.containsKey(element);
        }

        public Object[] getElements(Object inputElement) {
            Assert.isTrue((inputElement == null || inputElement instanceof Map ? 1 : 0) != 0);
            return this.fTopLevelElements.toArray();
        }

        public void dispose() {
            this.fTreeElementMap.clear();
            this.fTreeElementMap = null;
            this.fTopLevelElements = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Assert.isTrue((newInput == null || newInput instanceof Map ? 1 : 0) != 0);
            if (newInput == null) {
                return;
            }
            Map similarElementsMap = (Map)newInput;
            IJavaElement[] similarElements = similarElementsMap.keySet().toArray(new IJavaElement[0]);
            this.fTreeElementMap = new HashMap();
            this.fTopLevelElements = new HashSet();
            int i = 0;
            while (i < similarElements.length) {
                IType declaring = (IType)similarElements[i].getAncestor(7);
                if (similarElements[i] instanceof IMember) {
                    this.addToMap((IJavaElement)declaring, similarElements[i]);
                } else {
                    IJavaElement parent = similarElements[i].getParent();
                    if (parent instanceof IMember) {
                        this.addToMap(parent, similarElements[i]);
                        this.addToMap((IJavaElement)declaring, parent);
                    }
                }
                this.handleDeclaring((IJavaElement)declaring);
                ++i;
            }
        }

        private void handleDeclaring(IJavaElement someType) {
            IJavaElement enclosing = someType.getParent();
            if (enclosing instanceof ICompilationUnit) {
                this.fTopLevelElements.add(someType.getParent());
                this.addToMap(someType.getParent(), someType);
            } else {
                this.addToMap(enclosing, someType);
                this.handleDeclaring(enclosing);
            }
        }

        private void addToMap(IJavaElement key, IJavaElement element) {
            HashSet<IJavaElement> elements = (HashSet<IJavaElement>)this.fTreeElementMap.get(key);
            if (elements == null) {
                elements = new HashSet<IJavaElement>();
                this.fTreeElementMap.put(key, elements);
            }
            elements.add(element);
        }
    }

    private static class SimilarLabelProvider
    extends JavaElementLabelProvider {
        private Map fDescriptorImageMap = new HashMap();
        private Map fElementToNewName;

        public SimilarLabelProvider() {
            super(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);
        }

        public void initialize(Map elementToNewName) {
            this.fElementToNewName = elementToNewName;
        }

        public void dispose() {
            Iterator iter = this.fDescriptorImageMap.values().iterator();
            while (iter.hasNext()) {
                Image image = (Image)iter.next();
                image.dispose();
            }
            super.dispose();
        }

        private Image manageImageDescriptor(ImageDescriptor descriptor) {
            Image image = (Image)this.fDescriptorImageMap.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.fDescriptorImageMap.put(descriptor, image);
            }
            return image;
        }

        public Image getImage(Object element) {
            if (this.isSimilarElement(element)) {
                return this.manageImageDescriptor(JavaPluginImages.DESC_OBJS_DEFAULT_CHANGE);
            }
            return super.getImage(element);
        }

        public Image getJavaImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (this.isSimilarElement(element)) {
                return Messages.format(RefactoringMessages.RenameTypeWizardSimilarElementsPage_rename_to, new String[]{super.getText(element), (String)this.fElementToNewName.get(element)});
            }
            return super.getText(element);
        }

        private boolean isSimilarElement(Object element) {
            return this.fElementToNewName.containsKey(element);
        }
    }

    private static class SimilarElementSorter
    extends JavaElementSorter {
        private SimilarElementSorter() {
        }

        public int category(Object element) {
            ISourceRange sourceRange = null;
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                try {
                    sourceRange = member.getNameRange();
                }
                catch (JavaModelException javaModelException) {}
            }
            if (element instanceof ILocalVariable) {
                ILocalVariable var = (ILocalVariable)element;
                sourceRange = var.getNameRange();
            }
            if (sourceRange != null) {
                return 100 + sourceRange.getOffset();
            }
            return super.category(element);
        }
    }
}

