/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.SearchMessages;

public class BreakContinueTargetFinder
extends ASTVisitor {
    private ASTNode fSelected;
    private boolean fIsBreak;
    private SimpleName fLabel;
    private String fContents;
    private static final Class[] STOPPERS;
    private static final Class[] BREAKTARGETS;
    private static final Class[] CONTINUETARGETS;
    private static final int BRACE_LENGTH = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.Initializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        STOPPERS = classArray;
        Class[] classArray2 = new Class[5];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.ForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jdt.core.dom.EnhancedForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jdt.core.dom.WhileStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.jdt.core.dom.DoStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.jdt.core.dom.SwitchStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[4] = clazz7;
        BREAKTARGETS = classArray2;
        Class[] classArray3 = new Class[4];
        Class<?> clazz8 = class$2;
        if (clazz8 == null) {
            try {
                clazz8 = class$2 = Class.forName("org.eclipse.jdt.core.dom.ForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz8;
        Class<?> clazz9 = class$3;
        if (clazz9 == null) {
            try {
                clazz9 = class$3 = Class.forName("org.eclipse.jdt.core.dom.EnhancedForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz9;
        Class<?> clazz10 = class$4;
        if (clazz10 == null) {
            try {
                clazz10 = class$4 = Class.forName("org.eclipse.jdt.core.dom.WhileStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[2] = clazz10;
        Class<?> clazz11 = class$5;
        if (clazz11 == null) {
            try {
                clazz11 = class$5 = Class.forName("org.eclipse.jdt.core.dom.DoStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[3] = clazz11;
        CONTINUETARGETS = classArray3;
    }

    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        ASTNode controlNode = this.getBreakOrContinueNode(node);
        if (controlNode != null) {
            this.fContents = this.getContents(root);
            if (this.fContents == null) {
                return SearchMessages.BreakContinueTargetFinder_cannot_highlight;
            }
            this.fSelected = controlNode;
            this.fIsBreak = this.fSelected instanceof BreakStatement;
            this.fLabel = this.getLabel();
            return null;
        }
        return SearchMessages.BreakContinueTargetFinder_no_break_or_continue_selected;
    }

    private String getContents(CompilationUnit root) {
        try {
            IJavaElement rootElem = root.getJavaElement();
            if (rootElem instanceof ISourceReference) {
                return ((ISourceReference)rootElem).getSource();
            }
            return null;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private ASTNode getBreakOrContinueNode(ASTNode selectedNode) {
        if (selectedNode instanceof BreakStatement) {
            return selectedNode;
        }
        if (selectedNode instanceof ContinueStatement) {
            return selectedNode;
        }
        if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof BreakStatement) {
            return selectedNode.getParent();
        }
        if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof ContinueStatement) {
            return selectedNode.getParent();
        }
        return null;
    }

    public List perform() {
        return this.getNodesToHighlight();
    }

    private SimpleName getLabel() {
        if (this.fIsBreak) {
            BreakStatement bs = (BreakStatement)this.fSelected;
            return bs.getLabel();
        }
        ContinueStatement cs = (ContinueStatement)this.fSelected;
        return cs.getLabel();
    }

    private List getNodesToHighlight() {
        ASTNode targetNode = this.findTargetNode(this.fSelected);
        if (!this.isEnclosingStatement(targetNode)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ASTNode> list = new ArrayList<ASTNode>();
        ASTNode node = this.makeFakeNodeForFirstToken(targetNode);
        if (node != null) {
            list.add(node);
        }
        if (this.fIsBreak && (node = this.makeFakeNodeForClosingBrace(targetNode)) != null) {
            list.add(node);
        }
        return list;
    }

    private boolean isEnclosingStatement(ASTNode targetNode) {
        return targetNode != null && !(targetNode instanceof MethodDeclaration) && !(targetNode instanceof Initializer);
    }

    private ASTNode findTargetNode(ASTNode node) {
        while (this.keepWalkingUp(node = node.getParent())) {
        }
        return node;
    }

    private ASTNode makeFakeNodeForFirstToken(ASTNode node) {
        try {
            int length = this.getLengthOfFirstTokenOf(node);
            if (length < 1) {
                return node;
            }
            return this.makeFakeNode(node.getStartPosition(), length, node.getAST());
        }
        catch (InvalidInputException invalidInputException) {
            return node;
        }
    }

    private SimpleName makeFakeNode(int start, int length, AST ast) {
        String fakeName = BreakContinueTargetFinder.makeStringOfLength(length);
        SimpleName name = ast.newSimpleName(fakeName);
        name.setSourceRange(start, length);
        return name;
    }

    private ASTNode makeFakeNodeForClosingBrace(ASTNode targetNode) {
        ASTNode maybeBlock = this.getOptionalBlock(targetNode);
        if (maybeBlock == null) {
            return null;
        }
        return this.makeFakeNode(ASTNodes.getExclusiveEnd(maybeBlock) - 1, 1, targetNode.getAST());
    }

    private ASTNode getOptionalBlock(ASTNode targetNode) {
        final ASTNode[] maybeBlock = new ASTNode[1];
        targetNode.accept(new ASTVisitor(){

            public boolean visit(ForStatement node) {
                if (node.getBody() instanceof Block) {
                    maybeBlock[0] = node.getBody();
                }
                return false;
            }

            public boolean visit(EnhancedForStatement node) {
                if (node.getBody() instanceof Block) {
                    maybeBlock[0] = node.getBody();
                }
                return false;
            }

            public boolean visit(WhileStatement node) {
                if (node.getBody() instanceof Block) {
                    maybeBlock[0] = node.getBody();
                }
                return false;
            }

            public boolean visit(DoStatement node) {
                if (node.getBody() instanceof Block) {
                    maybeBlock[0] = node.getBody();
                }
                return false;
            }

            public boolean visit(SwitchStatement node) {
                maybeBlock[0] = node;
                return false;
            }
        });
        return maybeBlock[0];
    }

    private static String makeStringOfLength(int length) {
        char[] chars = new char[length];
        Arrays.fill(chars, 'x');
        return new String(chars);
    }

    private int getLengthOfFirstTokenOf(ASTNode node) throws InvalidInputException {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        scanner.setSource(this.getSource(node).toCharArray());
        scanner.getNextToken();
        return scanner.getRawTokenSource().length;
    }

    private String getSource(ASTNode node) {
        return this.fContents.substring(node.getStartPosition(), ASTNodes.getInclusiveEnd(node));
    }

    private boolean keepWalkingUp(ASTNode node) {
        if (node == null) {
            return false;
        }
        if (BreakContinueTargetFinder.isAnyInstanceOf(STOPPERS, node)) {
            return false;
        }
        if (this.fLabel != null) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.jdt.core.dom.LabeledStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(node)) {
                LabeledStatement ls = (LabeledStatement)node;
                return !BreakContinueTargetFinder.areEqualLabels(ls.getLabel(), this.fLabel);
            }
        }
        if (this.fLabel == null && this.fIsBreak && BreakContinueTargetFinder.isAnyInstanceOf(BREAKTARGETS, node)) {
            return false;
        }
        return this.fLabel != null || this.fIsBreak || !BreakContinueTargetFinder.isAnyInstanceOf(CONTINUETARGETS, node);
    }

    private static boolean areEqualLabels(SimpleName labelToMatch, SimpleName labelSelected) {
        return labelSelected.getIdentifier().equals(labelToMatch.getIdentifier());
    }

    private static boolean isAnyInstanceOf(Class[] continueTargets, ASTNode node) {
        int i = 0;
        while (i < continueTargets.length) {
            if (continueTargets[i].isInstance(node)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

