/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.ui.JavadocContentAccess;

public class ProposalInfo {
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;
    protected IJavaElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IJavaElement getJavaElement() throws JavaModelException {
        return this.fElement;
    }

    public final String getInfo(IProgressMonitor monitor) {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo(monitor);
        }
        return this.fJavadoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            IJavaElement javaElement = this.getJavaElement();
            if (javaElement instanceof IMember) {
                IMember member = (IMember)javaElement;
                return this.extractJavadoc(member, monitor);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private String extractJavadoc(IMember member, IProgressMonitor monitor) throws JavaModelException, IOException {
        Reader reader;
        if (member != null && (reader = this.getHTMLContentReader(member, monitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private Reader getHTMLContentReader(IMember member, IProgressMonitor monitor) throws JavaModelException {
        String s;
        Reader contentReader = JavadocContentAccess.getContentReader(member, true);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        if (member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(monitor)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

