/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.PreferenceConstants;

public class ClassPathDetector
implements IResourceProxyVisitor {
    private HashMap fSourceFolders = new HashMap();
    private List fClassFiles;
    private HashSet fJARFiles = new HashSet(10);
    private IProject fProject;
    private IPath fResultOutputFolder;
    private IClasspathEntry[] fResultClasspath;
    private IProgressMonitor fMonitor;

    public ClassPathDetector(IProject project, IProgressMonitor monitor) throws CoreException {
        this.fClassFiles = new ArrayList(100);
        this.fProject = project;
        this.fResultClasspath = null;
        this.fResultOutputFolder = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.detectClasspath(monitor);
    }

    private boolean isNested(IPath path, Iterator iter) {
        while (iter.hasNext()) {
            IPath other = (IPath)iter.next();
            if (!other.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void detectClasspath(IProgressMonitor monitor) throws CoreException {
        block11: {
            block10: {
                try {
                    monitor.beginTask(NewWizardMessages.ClassPathDetector_operation_description, 4);
                    this.fMonitor = monitor;
                    this.fProject.accept((IResourceProxyVisitor)this, 0);
                    monitor.worked(1);
                    cpEntries = new ArrayList<IClasspathEntry>();
                    this.detectSourceFolders(cpEntries);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    outputLocation = this.detectOutputFolder(cpEntries);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    this.detectLibraries(cpEntries, outputLocation);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    if (cpEntries.isEmpty() && this.fClassFiles.isEmpty()) {
lbl21:
                        // 2 sources

                        while (true) {
                            var6_4 = null;
                            break block10;
                            break;
                        }
                    }
                    jreEntries = PreferenceConstants.getDefaultJRELibrary();
                    i = 0;
                    while (true) {
                        if (i >= jreEntries.length) {
                            entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                            if (JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)this.fProject), (IClasspathEntry[])entries, (IPath)outputLocation).isOK()) break;
                            ** continue;
                        }
                        cpEntries.add(jreEntries[i]);
                        ++i;
                    }
                    this.fResultClasspath = entries;
                    this.fResultOutputFolder = outputLocation;
                    break block11;
                }
                catch (Throwable var7_10) {
                    var6_5 = null;
                    monitor.done();
                    throw var7_10;
                }
            }
            monitor.done();
            return;
        }
        var6_6 = null;
        monitor.done();
    }

    private IPath findInSourceFolders(IPath path) {
        Iterator iter = this.fSourceFolders.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            List cus = (List)this.fSourceFolders.get(key);
            if (!cus.contains(path)) continue;
            return (IPath)key;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPath detectOutputFolder(List entries) throws CoreException {
        IPath projPath;
        HashSet<IPath> classFolders = new HashSet<IPath>();
        Iterator iter = this.fClassFiles.iterator();
        while (true) {
            IOException e2;
            Object var7_7;
            if (!iter.hasNext()) {
                projPath = this.fProject.getFullPath();
                if (this.fSourceFolders.size() != 1 || !classFolders.isEmpty() || this.fSourceFolders.get(projPath) == null) break;
                return projPath;
            }
            IFile file = (IFile)iter.next();
            IClassFileReader reader = null;
            InputStream content = null;
            try {
                content = file.getContents();
                reader = ToolFactory.createDefaultClassFileReader((InputStream)content, (int)17);
            }
            catch (Throwable throwable) {
                var7_7 = null;
                try {
                    if (content == null) throw throwable;
                    content.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(NewWizardMessages.ClassPathDetector_error_closing_file, file.getFullPath().toString()), (Throwable)e2));
                }
            }
            {
                var7_7 = null;
            }
            try {}
            catch (IOException e2) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(NewWizardMessages.ClassPathDetector_error_closing_file, file.getFullPath().toString()), (Throwable)e2));
            }
            if (content != null) {
                content.close();
            }
            if (reader == null) continue;
            char[] className = reader.getClassName();
            ISourceAttribute sourceAttribute = reader.getSourceFileAttribute();
            if (className == null || sourceAttribute == null || sourceAttribute.getSourceFileName() == null) continue;
            IPath packPath = file.getParent().getFullPath();
            int idx = CharOperation.lastIndexOf((char)'/', (char[])className) + 1;
            Path relPath = new Path(new String(className, 0, idx));
            IPath cuPath = relPath.append(new String(sourceAttribute.getSourceFileName()));
            IPath resPath = null;
            if (idx == 0) {
                resPath = packPath;
            } else {
                IPath folderPath = this.getFolderPath(packPath, (IPath)relPath);
                if (folderPath != null) {
                    resPath = folderPath;
                }
            }
            if (resPath == null) continue;
            IPath path = this.findInSourceFolders(cuPath);
            if (path != null) {
                return resPath;
            }
            classFolders.add(resPath);
        }
        IPath path = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
        while (classFolders.contains(path)) {
            path = new Path(String.valueOf(path.toString()) + '1');
        }
        return path;
    }

    private void detectLibraries(ArrayList cpEntries, IPath outputLocation) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        Iterator iter = this.fJARFiles.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            if (this.isNested(path, sourceFolderSet.iterator()) || outputLocation != null && outputLocation.isPrefixOf(path)) continue;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        cpEntries.addAll(res);
    }

    private void detectSourceFolders(ArrayList resEntries) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        Iterator iter = sourceFolderSet.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            Iterator inner = sourceFolderSet.iterator();
            while (inner.hasNext()) {
                IPath other = (IPath)inner.next();
                if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
                IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                excluded.add(pathToExclude);
            }
            IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        resEntries.addAll(res);
    }

    /*
     * Exception decompiling
     */
    private void visitCompilationUnit(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 150->154)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IPath getPackagePath(String source) throws InvalidInputException {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(0, source.length() - 1);
        int tok = scanner.getNextToken();
        if (tok != 214) {
            return null;
        }
        Path res = Path.EMPTY;
        do {
            if ((tok = scanner.getNextToken()) != 5) {
                return res;
            }
            res = res.append(new String(scanner.getCurrentTokenSource()));
        } while ((tok = scanner.getNextToken()) == 6);
        return res;
    }

    private void addToMap(HashMap map, IPath folderPath, IPath relPath) {
        ArrayList<IPath> list = (ArrayList<IPath>)map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    private IPath getFolderPath(IPath packPath, IPath relpath) {
        IPath common;
        int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
        if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals((Object)relpath)) {
            return packPath.uptoSegment(remainingSegments);
        }
        return null;
    }

    private boolean hasExtension(String name, String ext) {
        return name.endsWith(ext) && ext.length() != name.length();
    }

    private boolean isValidCUName(String name) {
        return !JavaConventions.validateCompilationUnitName((String)name).matches(4);
    }

    public boolean visit(IResourceProxy proxy) {
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            if (this.isValidCUName(name)) {
                this.visitCompilationUnit((IFile)proxy.requestResource());
            } else if (this.hasExtension(name, ".class")) {
                this.fClassFiles.add(proxy.requestResource());
            } else if (this.hasExtension(name, ".jar")) {
                this.fJARFiles.add(proxy.requestFullPath());
            }
            return false;
        }
        return true;
    }

    public IPath getOutputLocation() {
        return this.fResultOutputFolder;
    }

    public IClasspathEntry[] getClasspath() {
        return this.fResultClasspath;
    }

    private static class CPSorter
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        private CPSorter() {
        }

        public int compare(Object o1, Object o2) {
            IClasspathEntry e1 = (IClasspathEntry)o1;
            IClasspathEntry e2 = (IClasspathEntry)o2;
            return this.fCollator.compare(e1.getPath().toString(), e2.getPath().toString());
        }
    }
}

