/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddFolderToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private final List fSelectedElements;
    static /* synthetic */ Class class$0;

    public AddFolderToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label, JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            boolean removeOldClassFiles;
            boolean removeProjectFromClasspath;
            IPath newDefaultOutputLocation;
            IJavaProject project;
            Object object = this.fSelectedElements.get(0);
            if (object instanceof IJavaProject) {
                project = (IJavaProject)object;
            } else if (object instanceof IPackageFragment) {
                project = ((IPackageFragment)object).getJavaProject();
            } else {
                IFolder folder = (IFolder)object;
                project = JavaCore.create((IProject)folder.getProject());
                if (project == null) {
                    return;
                }
            }
            Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : JavaPlugin.getActiveWorkbenchShell();
            IPath outputLocation = project.getOutputLocation();
            IPath defaultOutputLocation = outputLocation.makeRelative();
            IPath projPath = project.getProject().getFullPath();
            if (!(this.fSelectedElements.size() == 1 && this.fSelectedElements.get(0) instanceof IJavaProject || !outputLocation.equals((Object)projPath) && defaultOutputLocation.segmentCount() != 1)) {
                ClasspathModifierQueries.OutputFolderQuery outputFolderQuery = ClasspathModifierQueries.getDefaultFolderQuery(shell, defaultOutputLocation);
                if (!outputFolderQuery.doQuery(true, ClasspathModifier.getValidator(this.fSelectedElements, project), project)) return;
                newDefaultOutputLocation = outputFolderQuery.getOutputLocation();
                removeProjectFromClasspath = outputFolderQuery.removeProjectFromClasspath();
                if (BuildPathsBlock.hasClassfiles((IResource)project.getProject()) && outputLocation.equals((Object)projPath)) {
                    String title = NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_title;
                    String message = Messages.format(NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_description, projPath.toString());
                    MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int answer = dialog.open();
                    if (answer == 0) {
                        removeOldClassFiles = true;
                    } else {
                        if (answer != 1) return;
                        removeOldClassFiles = false;
                    }
                } else {
                    removeOldClassFiles = false;
                }
            } else {
                removeProjectFromClasspath = false;
                removeOldClassFiles = false;
                newDefaultOutputLocation = defaultOutputLocation;
            }
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            List result = AddFolderToBuildpathAction.this.addToClasspath(AddFolderToBuildpathAction.this.fSelectedElements, project, newDefaultOutputLocation.makeAbsolute(), removeProjectFromClasspath, removeOldClassFiles, monitor);
                            AddFolderToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
                return;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    this.showExceptionDialog((CoreException)e.getCause());
                    return;
                }
                JavaPlugin.log(e);
                return;
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
        catch (CoreException e) {
            this.showExceptionDialog(e);
        }
    }

    private List addToClasspath(List elements, IJavaProject project, IPath outputLocation, boolean removeProjectFromClasspath, boolean removeOldClassFiles, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        ArrayList<IJavaProject> arrayList;
        if (!project.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.ClasspathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        try {
            IResource res;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, elements.size() + 4);
            IWorkspaceRoot workspaceRoot = JavaPlugin.getWorkspace().getRoot();
            if (removeOldClassFiles && (res = workspaceRoot.findMember(project.getOutputLocation())) instanceof IContainer && BuildPathsBlock.hasClassfiles(res)) {
                BuildPathsBlock.removeOldClassfiles(res);
            }
            if (!project.getOutputLocation().equals((Object)outputLocation)) {
                project.setOutputLocation(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            if (removeProjectFromClasspath) {
                ClasspathModifier.removeFromClasspath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                CPListElement entry = element instanceof IResource ? ClasspathModifier.addToClasspath((IResource)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : ClasspathModifier.addToClasspath((IJavaElement)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                newEntries.add(entry);
                ++i;
            }
            HashSet modifiedSourceEntries = new HashSet();
            BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existingEntries.toArray(new CPListElement[existingEntries.size()]), modifiedSourceEntries);
            ClasspathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
            int i2 = 0;
            while (i2 < newEntries.size()) {
                IClasspathEntry entry = ((CPListElement)newEntries.get(i2)).getClasspathEntry();
                Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findPackageFragmentRoot(entry.getPath());
                if (root != null) {
                    result.add((IJavaProject)root);
                }
                ++i2;
            }
            arrayList = result;
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return arrayList;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                this.fSelectedElements.add(element);
                if (element instanceof IJavaProject) {
                    if (!ClasspathModifier.isSourceFolder((IJavaProject)element)) continue;
                    return false;
                }
                if (element instanceof IPackageFragment) {
                    int type = DialogPackageExplorerActionGroup.getType(element, ((IPackageFragment)element).getJavaProject());
                    if (type == 3 || type == 11) continue;
                    return false;
                }
                if (!(element instanceof IFolder)) {
                    return false;
                }
                IProject project = ((IFolder)element).getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject == null || !javaProject.exists()) break;
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddSourceFolderToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

