/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;

class QueryManager {
    private List fQueries = new ArrayList();
    private List fLRU;
    private List fListeners = new ArrayList();

    public QueryManager() {
        this.fLRU = new ArrayList();
    }

    boolean hasQueries() {
        return !this.fQueries.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISearchQuery[] getQueries() {
        List list = this.fQueries;
        synchronized (list) {
            ISearchQuery[] result = new ISearchQuery[this.fQueries.size()];
            return this.fQueries.toArray(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQuery(ISearchQuery query) {
        List list = this.fQueries;
        synchronized (list) {
            this.fQueries.remove(query);
            this.fLRU.remove(query);
        }
        this.fireRemoved(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQuery(ISearchQuery query) {
        List list = this.fQueries;
        synchronized (list) {
            if (this.fQueries.contains(query)) {
                return;
            }
            this.fQueries.add(0, query);
            this.fLRU.add(0, query);
        }
        this.fireAdded(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueryListener(IQueryListener l) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQueryListener(IQueryListener l) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAdded(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryAdded(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRemoved(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryRemoved(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStarting(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryStarting(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFinished(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryFinished(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAll() {
        HashSet copiedSearches = new HashSet();
        List list = this.fQueries;
        synchronized (list) {
            copiedSearches.addAll(this.fQueries);
            this.fQueries.clear();
            this.fLRU.clear();
            Iterator iter = copiedSearches.iterator();
            while (iter.hasNext()) {
                ISearchQuery element = (ISearchQuery)iter.next();
                this.fireRemoved(element);
            }
        }
    }

    void queryFinished(ISearchQuery query) {
        this.fireFinished(query);
    }

    void queryStarting(ISearchQuery query) {
        this.fireStarting(query);
    }

    void touch(ISearchQuery query) {
        if (this.fLRU.contains(query)) {
            this.fLRU.remove(query);
            this.fLRU.add(0, query);
        }
    }
}

