/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.IDebugContextListenerExtension;
import org.eclipse.debug.internal.ui.contexts.IDebugContextService;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class DebugWindowContextService
implements IDebugContextService,
IPartListener2,
IDebugContextListener,
IDebugContextListenerExtension {
    private Map fListenersByPartId = new HashMap();
    private Map fProvidersByPartId = new HashMap();
    private IWorkbenchWindow fWindow;
    private List fProviders = new ArrayList();
    private static final int ACTIVATED = 1;
    private static final int CHANGED = 2;
    private static final int IMPLICIT_EVALUATION = 3;

    public DebugWindowContextService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fWindow.getPartService().addPartListener((IPartListener2)this);
    }

    public void dispose() {
        this.fWindow.getPartService().removePartListener((IPartListener2)this);
        this.fWindow = null;
    }

    protected synchronized void addProvider(IDebugContextProvider provider) {
        IWorkbenchPart part = provider.getPart();
        String id = null;
        if (part != null) {
            id = part.getSite().getId();
        }
        this.fProvidersByPartId.put(id, provider);
        this.fProviders.add(provider);
        IWorkbenchPart active = null;
        IWorkbenchPage activePage = this.fWindow.getActivePage();
        if (activePage != null) {
            active = activePage.getActivePart();
        }
        if (this.fProviders.size() == 1 && (part == null || part.equals(active))) {
            this.notify(1);
        }
        provider.addDebugContextListener(this);
    }

    protected synchronized void removeProvider(IDebugContextProvider provider) {
        int index = this.fProviders.indexOf(provider);
        if (index >= 0) {
            IWorkbenchPart part = provider.getPart();
            String id = null;
            if (part != null) {
                id = part.getSite().getId();
            }
            this.fProvidersByPartId.remove(id);
            this.fProviders.remove(index);
            if (index == 0) {
                this.notify(1);
            }
        }
        provider.removeDebugContextListener(this);
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.addDebugContextListener(listener, null);
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.removeDebugContextListener(listener, null);
    }

    protected void notify(int type) {
        if (this.fProviders.isEmpty()) {
            this.notify(type, (ISelection)new StructuredSelection(), null);
        } else {
            IDebugContextProvider provider = (IDebugContextProvider)this.fProviders.get(0);
            this.notify(type, provider.getActiveContext(), provider.getPart());
        }
    }

    protected void notify(int type, ISelection context, IWorkbenchPart part) {
        this.notify(type, this.getListeners(null), context, part);
        if (part != null) {
            this.notify(type, this.getListeners(part), context, part);
        }
    }

    protected void notify(final int type, ListenerList list, final ISelection context, final IWorkbenchPart part) {
        if (list != null) {
            Object[] listeners = list.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IDebugContextListener listener = (IDebugContextListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 1: {
                                listener.contextActivated(context, part);
                                break;
                            }
                            case 2: {
                                listener.contextChanged(context, part);
                                break;
                            }
                            case 3: {
                                if (!(listener instanceof IDebugContextListenerExtension)) break;
                                ((IDebugContextListenerExtension)((Object)listener)).contextImplicitEvaluationComplete(context, part);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    protected ListenerList getListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = part.getSite().getId();
        }
        return (ListenerList)this.fListenersByPartId.get(id);
    }

    public synchronized void addDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fListenersByPartId.put(partId, list);
        }
        list.add((Object)listener);
    }

    public void removeDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
        }
    }

    public ISelection getActiveContext(String partId) {
        IDebugContextProvider provider = (IDebugContextProvider)this.fProvidersByPartId.get(partId);
        if (provider != null) {
            return provider.getActiveContext();
        }
        return null;
    }

    public ISelection getActiveContext() {
        if (!this.fProviders.isEmpty()) {
            return ((IDebugContextProvider)this.fProviders.get(0)).getActiveContext();
        }
        return null;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        int index;
        Object provider = this.fProvidersByPartId.get(partRef.getId());
        if (provider != null && (index = this.fProviders.indexOf(provider)) > 0) {
            this.fProviders.remove(index);
            this.fProviders.add(0, provider);
            this.notify(1);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public synchronized void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public synchronized void contextActivated(ISelection context, IWorkbenchPart part) {
        IDebugContextProvider provider;
        if (!this.fProviders.isEmpty() && (provider = (IDebugContextProvider)this.fProviders.get(0)).getPart() == part) {
            this.notify(1);
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
        IDebugContextProvider provider;
        if (!this.fProviders.isEmpty() && (provider = (IDebugContextProvider)this.fProviders.get(0)).getPart() == part) {
            this.notify(2);
        }
    }

    public void contextImplicitEvaluationComplete(ISelection selection, IWorkbenchPart part) {
        IDebugContextProvider provider;
        if (!this.fProviders.isEmpty() && (provider = (IDebugContextProvider)this.fProviders.get(0)).getPart() == part) {
            this.notify(3);
        }
    }
}

