/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.SuspendTriggerAdapterFactory;
import org.eclipse.debug.internal.ui.contexts.provisional.ISuspendTriggerAdapter;
import org.eclipse.debug.internal.ui.contexts.provisional.ISuspendTriggerListener;

public class LaunchSuspendTrigger
implements ISuspendTriggerAdapter,
IDebugEventSetListener {
    private ListenerList fListeners = new ListenerList();
    private SuspendTriggerAdapterFactory fFactory = null;
    private ILaunch fLaunch = null;
    static /* synthetic */ Class class$0;

    public LaunchSuspendTrigger(ILaunch launch, SuspendTriggerAdapterFactory factory) {
        this.fFactory = factory;
        this.fLaunch = launch;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fListeners = null;
        this.fFactory.dispose(this);
    }

    public void addSuspendTriggerListener(ISuspendTriggerListener listener) {
        if (this.fListeners != null) {
            this.fListeners.add((Object)listener);
        }
    }

    public void removeSuspendTriggerListener(ISuspendTriggerListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
        if (this.fListeners.size() == 0) {
            this.dispose();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object source;
            DebugEvent event = events[i];
            if (event.getKind() == 2 && !event.isEvaluation() && event.getDetail() != 8 && (source = event.getSource()) instanceof IAdaptable) {
                ILaunch launch;
                IAdaptable adaptable = (IAdaptable)source;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.debug.core.ILaunch");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.fLaunch.equals(launch = (ILaunch)adaptable.getAdapter((Class)clazz))) {
                    this.notifySuspend(event);
                }
            }
            ++i;
        }
    }

    private void notifySuspend(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugElement) {
            final ILaunch launch = ((IDebugElement)source).getLaunch();
            Object context = null;
            if (source instanceof IThread) {
                try {
                    context = ((IThread)source).getTopStackFrame();
                }
                catch (DebugException debugException) {}
            } else if (source instanceof IDebugTarget) {
                context = source;
            }
            final IStackFrame temp = context;
            ListenerList list = this.fListeners;
            if (list != null) {
                Object[] listeners = list.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    final ISuspendTriggerListener listener = (ISuspendTriggerListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            listener.suspended(launch, temp);
                        }

                        public void handleException(Throwable exception) {
                            DebugUIPlugin.log(exception);
                        }
                    });
                    ++i;
                }
            }
        }
    }
}

