/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.TableAddRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableInsertRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableRemoveRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableReplaceRequestMonitor;

public class AsynchronousTableModel
extends AsynchronousModel {
    public AsynchronousTableModel(AsynchronousViewer viewer) {
        super(viewer);
    }

    protected void add(ModelNode parent, Object element) {
    }

    public void add(Object[] elements) {
        TableAddRequestMonitor update = new TableAddRequestMonitor(this.getRootNode(), elements, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void added(Object[] elements) {
        ArrayList<Object> kids = null;
        boolean changed = false;
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            int i;
            ModelNode[] childrenNodes = this.getRootNode().getChildrenNodes();
            if (childrenNodes == null) {
                kids = new ArrayList<Object>(elements.length);
            } else {
                kids = new ArrayList(elements.length + childrenNodes.length);
                i = 0;
                while (i < childrenNodes.length) {
                    kids.add(childrenNodes[i].getElement());
                    ++i;
                }
            }
            i = 0;
            while (i < elements.length) {
                if (!kids.contains(elements[i])) {
                    kids.add(elements[i]);
                    changed = true;
                }
                ++i;
            }
        }
        if (changed) {
            this.setChildren(this.getRootNode(), kids);
        }
    }

    public void insert(Object[] elements, int index) {
        TableInsertRequestMonitor update = new TableInsertRequestMonitor(this.getRootNode(), elements, index, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inserted(Object[] elements, int index) {
        ArrayList<Object> kids = null;
        boolean changed = false;
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            int i;
            ModelNode[] childrenNodes = this.getRootNode().getChildrenNodes();
            if (childrenNodes == null) {
                kids = new ArrayList<Object>(elements.length);
            } else {
                kids = new ArrayList(elements.length + childrenNodes.length);
                i = 0;
                while (i < childrenNodes.length) {
                    kids.add(childrenNodes[i].getElement());
                    ++i;
                }
            }
            i = 0;
            while (i < elements.length) {
                if (!kids.contains(elements[i])) {
                    kids.add(index, elements[i]);
                    ++index;
                    changed = true;
                }
                ++i;
            }
        }
        if (changed) {
            this.setChildren(this.getRootNode(), kids);
        }
    }

    public void remove(Object[] elements) {
        TableRemoveRequestMonitor update = new TableRemoveRequestMonitor(this.getRootNode(), elements, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removed(Object[] elements) {
        ArrayList<Object> kids = null;
        boolean changed = false;
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            int i;
            ModelNode[] childrenNodes = this.getRootNode().getChildrenNodes();
            if (childrenNodes != null) {
                kids = new ArrayList<Object>(childrenNodes.length);
                i = 0;
                while (i < childrenNodes.length) {
                    kids.add(childrenNodes[i].getElement());
                    ++i;
                }
            }
            i = 0;
            while (i < elements.length) {
                if (kids.remove(elements[i])) {
                    changed = true;
                }
                ++i;
            }
        }
        if (changed) {
            this.setChildren(this.getRootNode(), kids);
        }
    }

    public void replace(Object element, Object replacement) {
        TableReplaceRequestMonitor update = new TableReplaceRequestMonitor(this.getRootNode(), element, replacement, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaced(Object element, Object replacement) {
        Object[] filtered = this.filter(this.getRootNode().getElement(), new Object[]{replacement});
        if (filtered.length == 0) {
            this.remove(new Object[]{element});
            return;
        }
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            ModelNode[] nodes = this.getNodes(element);
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                node.remap(replacement);
                list.add(node);
                ++i;
            }
        }
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ModelNode node = (ModelNode)iterator.next();
                this.getViewer().nodeChanged(node);
            }
        }
    }
}

