/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class EnvironmentTab
extends AbstractLaunchConfigurationTab {
    protected TableViewer environmentTable;
    protected String[] envTableColumnHeaders = new String[]{LaunchConfigurationsMessages.EnvironmentTab_Variable_1, LaunchConfigurationsMessages.EnvironmentTab_Value_2};
    protected ColumnLayoutData[] envTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(50), new ColumnWeightData(50)};
    private static final String NAME_LABEL = LaunchConfigurationsMessages.EnvironmentTab_8;
    private static final String VALUE_LABEL = LaunchConfigurationsMessages.EnvironmentTab_9;
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";
    protected static String[] envTableColumnProperties = new String[]{"variable", "value"};
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected Button appendEnvironment;
    protected Button replaceEnvironment;
    protected Button envSelectButton;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_ENVIRONMENT_TAB);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createEnvironmentTable(mainComposite);
        this.createTableButtons(mainComposite);
        this.createAppendReplace(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
    }

    protected void createAppendReplace(Composite parent) {
        Composite appendReplaceComposite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout layout = new GridLayout();
        appendReplaceComposite.setLayoutData((Object)gridData);
        appendReplaceComposite.setLayout((Layout)layout);
        appendReplaceComposite.setFont(parent.getFont());
        this.appendEnvironment = this.createRadioButton(appendReplaceComposite, LaunchConfigurationsMessages.EnvironmentTab_16);
        this.appendEnvironment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.replaceEnvironment = this.createRadioButton(appendReplaceComposite, LaunchConfigurationsMessages.EnvironmentTab_17);
    }

    protected void updateAppendReplace() {
        boolean enable = this.environmentTable.getTable().getItemCount() > 0;
        this.appendEnvironment.setEnabled(enable);
        this.replaceEnvironment.setEnabled(enable);
    }

    protected void createEnvironmentTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        Label label = new Label(tableComposite, 0);
        label.setFont(font);
        label.setText(LaunchConfigurationsMessages.EnvironmentTab_Environment_variables_to_set__3);
        this.environmentTable = new TableViewer(tableComposite, 68354);
        Table table = this.environmentTable.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.environmentTable.getControl().setLayoutData((Object)gridData);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentVariableContentProvider());
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.setColumnProperties(envTableColumnProperties);
        this.environmentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnvironmentTab.this.handleTableSelectionChanged(event);
            }
        });
        this.environmentTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!EnvironmentTab.this.environmentTable.getSelection().isEmpty()) {
                    EnvironmentTab.this.handleEnvEditButtonSelected();
                }
            }
        });
        int i = 0;
        while (i < this.envTableColumnHeaders.length) {
            tableLayout.addColumnData(this.envTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.envTableColumnLayouts[i].resizable);
            tc.setText(this.envTableColumnHeaders[i]);
            ++i;
        }
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(130);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.createVerticalSpacer(buttonComposite, 1);
        this.envAddButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_New_4, null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvAddButtonSelected();
            }
        });
        this.envSelectButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_18, null);
        this.envSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvSelectButtonSelected();
            }
        });
        this.envEditButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Edit_5, null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Remove_6, null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    protected void handleEnvAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_22);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value.trim()));
            this.updateAppendReplace();
        }
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        String name = variable.getName();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)items[i].getData();
            if (existingVariable.getName().equals(name)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_12, (String)MessageFormat.format((String)LaunchConfigurationsMessages.EnvironmentTab_13, (Object[])new String[]{name}));
                if (!overWrite) {
                    return false;
                }
                this.environmentTable.remove((Object)existingVariable);
                break;
            }
            ++i;
        }
        this.environmentTable.add((Object)variable);
        this.updateLaunchConfigurationDialog();
        return true;
    }

    private void handleEnvSelectButtonSelected() {
        Map envVariables = this.getNativeEnvironment();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
            envVariables.remove(var.getName());
            ++i;
        }
        NativeEnvironmentDialog dialog = new NativeEnvironmentDialog(this.getShell(), envVariables, this.createSelectionDialogContentProvider(), this.createSelectionDialogLabelProvider(), LaunchConfigurationsMessages.EnvironmentTab_19);
        dialog.setTitle(LaunchConfigurationsMessages.EnvironmentTab_20);
        int button = dialog.open();
        if (button == 0) {
            Object[] selected = dialog.getResult();
            int i2 = 0;
            while (i2 < selected.length) {
                this.environmentTable.add(selected[i2]);
                ++i2;
            }
        }
        this.updateAppendReplace();
        this.updateLaunchConfigurationDialog();
    }

    private ILabelProvider createSelectionDialogLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return DebugPluginImages.getImage("IMG_OBJS_ENVIRONMENT");
            }

            public String getText(Object element) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                return String.valueOf(var.getName()) + " [" + var.getValue() + "]";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] elements = null;
                if (inputElement instanceof HashMap) {
                    Comparator comparator = new Comparator(this){
                        final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            String s1 = (String)o1;
                            String s2 = (String)o2;
                            return s1.compareTo(s2);
                        }
                    };
                    TreeMap envVars = new TreeMap(comparator);
                    envVars.putAll((Map)inputElement);
                    elements = new EnvironmentVariable[envVars.size()];
                    int index = 0;
                    Iterator iterator = envVars.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object key = iterator.next();
                        elements[index] = (EnvironmentVariable)envVars.get(key);
                        ++index;
                    }
                }
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private Map getNativeEnvironment() {
        Map stringVars = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        Iterator i = stringVars.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)stringVars.get(key);
            vars.put(key, new EnvironmentVariable(key, value));
        }
        return vars;
    }

    private void handleEnvEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_11);
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addVariablesField(VALUE_LABEL, value, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name, value))) {
                this.environmentTable.remove((Object)var);
            }
        } else {
            var.setValue(value);
            this.environmentTable.update((Object)var, null);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        this.environmentTable.getControl().setRedraw(false);
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            EnvironmentVariable var = (EnvironmentVariable)i.next();
            this.environmentTable.remove((Object)var);
        }
        this.environmentTable.getControl().setRedraw(true);
        this.updateAppendReplace();
        this.updateLaunchConfigurationDialog();
    }

    protected void updateEnvironment(ILaunchConfiguration configuration) {
        this.environmentTable.setInput((Object)configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean append = true;
        try {
            append = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
        if (append) {
            this.appendEnvironment.setSelection(true);
            this.replaceEnvironment.setSelection(false);
        } else {
            this.replaceEnvironment.setSelection(true);
            this.appendEnvironment.setSelection(false);
        }
        this.updateEnvironment(configuration);
        this.updateAppendReplace();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TableItem[] items = this.environmentTable.getTable().getItems();
        HashMap<String, String> map = new HashMap<String, String>(items.length);
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
            map.put(var.getName(), var.getValue());
            ++i;
        }
        if (map.size() == 0) {
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        } else {
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
        }
        configuration.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, this.appendEnvironment.getSelection());
    }

    public String getName() {
        return LaunchConfigurationsMessages.EnvironmentTab_Environment_7;
    }

    public Image getImage() {
        return DebugPluginImages.getImage("IMG_OBJS_ENVIRONMENT");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected class EnvironmentVariableContentProvider
    implements IStructuredContentProvider {
        protected EnvironmentVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Map m;
            Object[] elements = new EnvironmentVariable[]{};
            ILaunchConfiguration config = (ILaunchConfiguration)inputElement;
            try {
                m = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            }
            catch (CoreException e) {
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 4, "Error reading configuration", (Throwable)e));
                return elements;
            }
            if (m != null && !m.isEmpty()) {
                elements = new EnvironmentVariable[m.size()];
                String[] varNames = new String[m.size()];
                m.keySet().toArray(varNames);
                int i = 0;
                while (i < m.size()) {
                    elements[i] = new EnvironmentVariable(varNames[i], (String)m.get(varNames[i]));
                    ++i;
                }
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setSorter(new ViewerSorter(this){
                    final /* synthetic */ EnvironmentVariableContentProvider this$1;
                    {
                        this.this$1 = environmentVariableContentProvider;
                    }

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                    }
                });
            }
        }
    }

    public class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return DebugPluginImages.getImage("IMG_OBJS_ENV_VAR");
            }
            return null;
        }
    }

    private class NativeEnvironmentDialog
    extends ListSelectionDialog {
        public NativeEnvironmentDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected String getDialogSettingsSectionName() {
            return String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".ENVIRONMENT_TAB.NATIVE_ENVIROMENT_DIALOG";
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
            if (section == null) {
                section = settings.addNewSection(this.getDialogSettingsSectionName());
            }
            return section;
        }
    }
}

