/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ProjectLocationMoveDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class MoveProjectAction
extends CopyProjectAction {
    private static String MOVE_TOOL_TIP = IDEWorkbenchMessages.MoveProjectAction_toolTip;
    private static String MOVE_TITLE = IDEWorkbenchMessages.MoveProjectAction_text;
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.MoveProjectAction_dialogTitle;
    private static String MOVE_PROGRESS_TITLE = IDEWorkbenchMessages.MoveProjectAction_progressMessage;
    public static final String ID = "org.eclipse.ui.MoveProjectAction";

    public MoveProjectAction(Shell shell) {
        super(shell, MOVE_TITLE);
        this.setToolTipText(MOVE_TOOL_TIP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_project_action_context");
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    boolean performMove(final IProject project, final String projectName, final IPath newLocation) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.setTaskName(MOVE_PROGRESS_TITLE);
                        IProjectDescription newDescription = MoveProjectAction.this.createDescription(project, projectName, newLocation);
                        project.move(newDescription, 33, monitor);
                    }
                    catch (CoreException e) {
                        MoveProjectAction.this.recordError(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "performMove()", e.getTargetException());
            this.displayError(NLS.bind((String)IDEWorkbenchMessages.MoveProjectAction_internalError, (Object)e.getTargetException().getMessage()));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject project) {
        ProjectLocationMoveDialog dialog = new ProjectLocationMoveDialog(this.shell, project);
        dialog.setTitle(IDEWorkbenchMessages.MoveProjectAction_moveTitle);
        dialog.open();
        return dialog.getResult();
    }

    public void run() {
        this.errorStatus = null;
        IProject project = (IProject)this.getSelectedResources().get(0);
        Object[] destinationPaths = this.queryDestinationParameters(project);
        if (destinationPaths == null) {
            return;
        }
        String projectName = (String)destinationPaths[0];
        Path newLocation = new Path((String)destinationPaths[1]);
        if (!this.validateMove(project, projectName)) {
            return;
        }
        boolean completed = this.performMove(project, projectName, (IPath)newLocation);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shell, (String)PROBLEMS_TITLE, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private boolean validateMove(IProject project, String newName) {
        if (project.getName().equals(newName)) {
            return true;
        }
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        factory.move((IResource)project, (IPath)new Path(newName));
        return IDE.promptToConfirm(this.shell, IDEWorkbenchMessages.CopyProjectAction_confirm, NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_warning, (Object)project.getName()), factory.getDelta(), this.getModelProviderIds(), false);
    }
}

