/*
 * Created on 11.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import de.ssfuture.tools.updater.DefaultConsoleLogging;
import de.ssfuture.tools.updater.Pack;
import de.ssfuture.tools.updater.UpdateBrowser;

/**
 * @author Sebastian Schleemilch
 */
public class JFontTools extends JFrame implements ActionListener, MouseListener {
	public static final long serialVersionUID = 1105;
	public static final String softwareServiceURL = "http://jfonttools.sourceforge.net";
	JCheckBox[] labels; Box box;
	JButton selectall = new JButton("Select all");
	JButton disselectall = new JButton("Disselect all");
	JMenuBar menubar = new JMenuBar();
	JMenu actions = new JMenu("Actions");
	JMenuItem fontanalyse = new JMenuItem("Font analyse");
	JMenuItem fontcompare = new JMenuItem("Font comparison");
	JMenu sort = new JMenu("Sort");
	JMenuItem sortbyname = new JMenuItem("By name");
	JMenuItem sortbyfontfamily = new JMenuItem("By font family");
	JMenuItem fontmanager_btn = new JMenuItem("De-/Install fonts");
	JMenuItem exit = new JMenuItem("Exit", 'x');
	JMenu info = new JMenu("?");
	JMenuItem help = new JMenuItem("Help");
	JMenuItem reportbug = new JMenuItem("Report a bug");
	JMenuItem license = new JMenuItem("License");
	JMenuItem update = new JMenuItem("Update");
	JMenuItem about = new JMenuItem("About");
	JLabel checkall = new JLabel(" all ");
	JLabel checknone = new JLabel("o none");
	
	FontManager fontmanager = new FontManager();
	
	public JFontTools() {
		super("JFontTools " + ((float)serialVersionUID/1000));
		
		
		box = Box.createVerticalBox();
		
		Font[] fontlist = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
		ProgressWindow progress = new ProgressWindow(0, fontlist.length);
		labels = new JCheckBox[fontlist.length];
		for(int i = 0; i < fontlist.length; i++) {
			progress.setValue(i);
			System.out.println((i+1) + " of " + fontlist.length);
			labels[i] = new JCheckBox(fontlist[i].getName());
			fontlist[i] = fontlist[i].deriveFont((float)14.0);
			labels[i].setFont(fontlist[i]);
			box.add(labels[i]);
			labels[i].setToolTipText("<html>" +
					"<h1>" + fontlist[i].getName() + "</h1>" +
					"Font famlily: " + fontlist[i].getFamily() + "<br>" +
					"<br>" +
					"<font face=\"" + fontlist[i].getName() + "\">ABCDEFGHIJKLMNOPQRSTUVWXYZ<br>" +
					"abcdefghijklmnopqrstuvwxyz<br>" +
					"1234567890<br>" +
					"|,;.:-_#'+*~!\"$%&/()=?@{}[]\\*+</font><br><hr>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=1>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=2>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=1>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=3>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=4>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=5>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=6>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"<font face=\"" + fontlist[i].getName() + "\" size=7>This font is \"" + fontlist[i].getName() + "\"</font><br>" +
					"</html>");
		}
		getContentPane().setBackground(SystemColor.window);
		
		getContentPane().add(new JScrollPane(box), "Center");
		
		constructMenu();
		construceAllOther();
		
		WindowPositionTools.west(this);
		setVisible(true);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		progress.setVisible(false);
	}

	private void constructMenu() {
		fontanalyse.addActionListener(this);
		actions.add(fontanalyse);
		
		fontcompare.addActionListener(this);
		actions.add(fontcompare);
		
		actions.addSeparator();
		sort.add(sortbyname);
		sortbyname.addActionListener(this);
		sort.add(sortbyfontfamily);
		sortbyfontfamily.addActionListener(this);
		actions.add(sort);
		
		actions.add(fontmanager_btn);
		fontmanager_btn.addActionListener(this);
		
		actions.addSeparator();
		
		exit.setAccelerator( KeyStroke.getKeyStroke('X', InputEvent.CTRL_MASK) );
		exit.addActionListener(this);
		actions.add(exit);
		
		info.add(help);
		help.addActionListener(this);
		info.addSeparator();
		info.add(reportbug);
		reportbug.addActionListener(this);
		info.add(license);
		license.addActionListener(this);
		info.add(update);
		update.addActionListener(this);
		info.addSeparator();
		info.add(about);
		about.addActionListener(this);
		
		menubar.add(actions);
		menubar.add(info);
		setJMenuBar(menubar);
	}
	
	private void construceAllOther() {
		Box b = Box.createHorizontalBox();
		b.add(checkall);
		checkall.addMouseListener(this);
		checkall.setToolTipText("Select all fonts");
		b.add(checknone);
		checknone.addMouseListener(this);
		checknone.setToolTipText("Select none fonts");
		getContentPane().add(b, "South");
	}
	
	public void actionPerformed(ActionEvent e) {
		Object src = e.getSource();
		if(src.equals(fontanalyse)) {
			int selectedIndex = -1;
			for(int i = 0; i < labels.length; i++) {
				if(labels[i].isSelected()) {
					if(selectedIndex == -1)
						selectedIndex = i;
					else if(selectedIndex != -2) {
						selectedIndex = -2;
						JOptionPane.showMessageDialog(this, "<html><center>You just can select one Font<br>" +
								"if you want to use this function!</center></html>", 
								"Just select one Font", JOptionPane.ERROR_MESSAGE);
						i = labels.length;
					}
				}
			}
			// Make info dialog
			if(selectedIndex > -1) {
				// Show it
				new FontAnalyser(labels[selectedIndex].getFont());
			}
			else if(selectedIndex == -1) {
					JOptionPane.showMessageDialog(this, "<html><center>You must select one Font<br>" +
							"if you want to use this function!</center></html>", 
							"Select one Font", JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(src.equals(fontcompare)) {
			int selectionCount = 0;
			for(int i = 0; i < labels.length; i++) {
				if(labels[i].isSelected())
					selectionCount++;
			}
			if(selectionCount > 0) {
				Font[] f = new Font[selectionCount];
				int counter = 0;
				for(int i = 0; i < labels.length; i++) {
					if(labels[i].isSelected()) {
						f[counter] = labels[i].getFont();
						counter++;
					}
				}
				new FontComparisonDialog(this, f);
			}
			else{
				JOptionPane.showMessageDialog(this, "<html><center>You must select one Font or more<br>" +
						"if you want to use this function!</center></html>", 
						"Select one Font or more", JOptionPane.ERROR_MESSAGE);
			}
		}
		else if(src.equals(sortbyname)) {
			ProgressWindow progress = new ProgressWindow(0, labels.length);
			ArrayList alist = new ArrayList(labels.length);
			for(int i = 0; i < labels.length; i++) {
				box.remove(labels[i]);
				alist.add(labels[i].getText());
			}
			Collections.sort(alist);
			for(int i = 0; i < labels.length; i++) {
				progress.setValue(i);
				for(int y = 0; y < labels.length; y++) {
					if(labels[i].getText().equals(alist.get(y))) {
						box.add(labels[i]);
					}
				}
			}
			progress.setVisible(false);
		}
		else if(src.equals(sortbyfontfamily)) {
			ProgressWindow progress = new ProgressWindow(0, labels.length);
			ArrayList alist = new ArrayList(labels.length);
			for(int i = 0; i < labels.length; i++) {
				box.remove(labels[i]);
				alist.add(labels[i].getFont().getFamily());
			}
			Collections.sort(alist);
			for(int i = 0; i < labels.length; i++) {
				progress.setValue(i);
				for(int y = 0; y < labels.length; y++) {
					if(labels[i].getFont().getFamily().equals(alist.get(y))) {
						box.add(labels[i]);
						// Exit loop
						y = labels.length;
					}
				}
			}
			progress.setVisible(false);
		}
		else if(src.equals(license)) {
			new LicenseDialog(this);
		}
		else if(src.equals(update)) {
			new UpdateBrowser(this, softwareServiceURL + "/update/" + serialVersionUID + ".html");
		}
		else if(src.equals(reportbug))
			new ReportBugDialog(this);
		else if(src.equals(help))
			JOptionPane.showMessageDialog(this, 
					"<html>Sorry, help ist just online available.<br>" +
					"Please have a look at: " + softwareServiceURL + "/help/", "Help</html>", JOptionPane.PLAIN_MESSAGE);
		else if(src.equals(about))
			JOptionPane.showMessageDialog(this, 
					"<html><center><h1>About JFontTools</h1></center>" +
					"Version: " + ((float)serialVersionUID/1000) +  "<br>" +
					"Autor: Sebastian Schleemilch (schleemilch @ gmail.com)<br>" +
					"Homepage: jfonttools.sourceforge.net<br>" +
					"<br>" +
					"Thanks to:<br>" +
					"Sun (sun.com)<br>" +
					"JSmooth (jsmooth.sourceforge.net)<br>" +
					"Inno Setup (jrsoftware.org)" +
					"</html>", "About", JOptionPane.PLAIN_MESSAGE);
		else if(src.equals(fontmanager_btn)) {
			fontmanager.refreshItems();
			fontmanager.setVisible(true);
		}
		else if(src.equals(exit)) {
			System.exit(0);
		}
	}
	
	public void mouseClicked(MouseEvent e) {
		if( e.getSource().equals(checkall) ) {
			for(int i = 0; i < labels.length; i++)
				labels[i].setSelected(true);
		}
		else if ( e.getSource().equals(checknone) ) {
			for(int i = 0; i < labels.length; i++)
				labels[i].setSelected(false);
		}
	}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	
	public static void main(String[] args) {
		if(args.length > 0 && args[0].equals("-compress")) {
			if(args.length != 4) {
				System.out.println("USEAGE: -compress <target jar name> <mainclass> <compression leven(1-9)>");
				System.out.println("Sourcedir: " + System.getProperty("user.home") + "/ssfupdater/");
				System.exit(1);
			}
			try {
				Pack p = new Pack(args[1], args[2], Integer.parseInt(args[3]), new DefaultConsoleLogging());
			} catch (NumberFormatException e) {
				e.printStackTrace();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			System.exit(0);
		}
		new JFontTools();
	}
}
