/*
 * Created on 14.09.2006
 */
package de.ssfuture.tools.jfonttools.comparison;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;

/**
 * @author Sebastian Schleemilch
 */
public class FontPrinter {
	PrintJob pj;
	Graphics gfx;
	Font fontname_font = new Font("Arial", Font.BOLD+Font.ITALIC, 14);
	Font pageid_font = new Font("Arial", Font.PLAIN, 10);
	int currentPagePos, currentPageID;
	int pageHight, pageWidth;
	
	public FontPrinter(Font[] fonts, Color bg, Color fg, float size, int style, String text, Frame parent) {
		pj = Toolkit.getDefaultToolkit().getPrintJob(parent, "Font comparison", null);
		currentPageID = 1;
		if(pj != null) {
			pageHight = pj.getPageDimension().height - 10;
			pageWidth = pj.getPageDimension().width - 10;
			nextPage();
			
			addFont(new Font(fonts[0].getName(), Font.BOLD, 20), Color.white, Color.black, "JFontTools - Font comparison");
			
			for(int i = 0; i < fonts.length; i++) {
				System.err.println(">>Adding " + fonts[i].getName());
				if(i != 0)
					addSeparator();
				addFontName(fonts[i].getName());
				addFont(fonts[i].deriveFont(style, size), bg, fg, text);
			}
			
			pj.end();
		}
	}
	
	void nextPage() {
		gfx = pj.getGraphics();
		addPageID(currentPageID);
		currentPageID++;
		currentPagePos = 10; // 10 cause a little white stripe should be!
	}
	
	void addPageID(int id) {
		gfx.setFont(pageid_font);
		gfx.setColor(Color.black);
		gfx.drawString(
				"Page " + id, 
				pj.getPageDimension().width - gfx.getFontMetrics().stringWidth("Page_" + id + "___"), 
				gfx.getFontMetrics().getHeight() + 10);
	}

	void addSeparator() {
		if( ((currentPagePos + 50) >= pageHight))
			nextPage();
		
		currentPagePos += 20;
		gfx.setColor(Color.black);
		gfx.fillRect(10, currentPagePos, pageWidth, 10);
		currentPagePos += 20;
	}

	void addFontName(String name) {
		gfx.setFont(fontname_font);
		if((gfx.getFontMetrics().getHeight() + currentPagePos + 20) >= pageHight)
			nextPage();
		
		gfx.setColor(Color.black);
		gfx.drawString(name, 20, currentPagePos + gfx.getFontMetrics().getHeight());
		currentPagePos += gfx.getFontMetrics().getHeight() + 20;
	}
	
	void addFont(Font font, Color bg, Color fg, String text) {
		gfx.setFont(font);
		if ((gfx.getFontMetrics().getHeight() + 30 + currentPagePos) >= pageHight)
			nextPage();
		gfx.setColor(bg);
		gfx.fillRect(10, currentPagePos, 
				gfx.getFontMetrics().stringWidth(text) + 20, 
				gfx.getFontMetrics().getHeight() + 20);
		currentPagePos += 10;
		gfx.setColor(fg);
		gfx.drawString(text, 20, currentPagePos + gfx.getFontMetrics().getHeight());
		currentPagePos += gfx.getFontMetrics().getHeight() + 10;
	}
	
	public static void main(String[] args) {
		PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(
				new java.awt.Frame(), "Font comparison", null);
		if(pj != null) {
			Graphics gfx = pj.getGraphics();
			gfx.drawString("Page 1", pj.getPageDimension().width - gfx.getFontMetrics().stringWidth("Page 1  "), gfx.getFontMetrics().getHeight() + 10);
			for(int r = 0; r < 255; r = r + 5) {
				for(int g = 0; g < 255; g = g + 5) {
					gfx.setColor(new Color(r, g, 20));
					gfx.drawRect(r+40, g+270, 1, 1);
				}
			}
			gfx.setColor(Color.MAGENTA);
			gfx.drawRoundRect(30, 30, pj.getPageDimension().width - 60, pj.getPageDimension().height - 60, 30, 30);
			pj.end();
		}
		System.out.println("END");
		System.exit(0);
	}
}
