/*
 * Created on 13.09.2006
 */
package de.ssfuture.tools.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;

/**
 * @author Sebastian Schleemilch
 */
public class Unpack {
	JarFile srcjar;
	String unpackdir;
	LoggingInterface log;
	
	public Unpack(String srcjarfile, LoggingInterface logging) throws IOException {
		log = logging;
		File dir = new File(System.getProperty("user.home"), "ssfupdater");
		if(! dir.exists())
			dir.mkdirs();
		unpackdir = dir.getPath();
		log.defaultLog( "Working dir:" + unpackdir );
		
		srcjar = new JarFile(srcjarfile);
		Enumeration entries = srcjar.entries();
		ArrayList alist = new ArrayList();
		while(entries.hasMoreElements()) {
			alist.add(entries.nextElement());
		}
		log.progressStatusInit("Unpacking files", 0, alist.size());
		for(int i = 0; i < alist.size(); i++) {
			log.progressStatus(i);
			JarEntry trgt = (JarEntry) alist.get(i);
			extractEntry(trgt);
		}
		log.progressStatusExit();
	}
	
	private void extractEntry(JarEntry entry) 
		throws JarException, IOException {
		File f = new File(unpackdir, entry.getName());
		if(entry.isDirectory()) {
			f.mkdirs();
		}
		else {
			InputStream ins = srcjar.getInputStream(entry);
			BufferedInputStream bis = new BufferedInputStream(ins);
			new File(f.getParent()).mkdirs();
			FileOutputStream fos = new FileOutputStream(f);
			BufferedOutputStream bos = new BufferedOutputStream(fos);
			
			for(int d ; (d = bis.read()) != -1; )
				bos.write( (byte)d );
			
			bos.close();
			fos.close();
		}
	}

	public static void main(String[] args) {
		try {
			Unpack up = new Unpack("ComS-CMS.jar", new DefaultConsoleLogging());
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
