/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mom_bitstream_d.h
 *
 * Author:	Paulo Nunes (IST) - Paulo.Nunes@lx.it.pt
 * Created:	1-Mar-96
 *                                                                         
 * Description: Header file for the the module "bitsdec", it contains data
 *		structures and function prototypes for module which deals
 *		with bitstreams in the decoder. 
 *
 * Notes: 	The bitstream structure is based on the structure of the
 *		tmndecode program
 * 		Written by Karl Olav Lillevold <kol@nta.no>,
 *					1995 Telenor R&D.
 * 		Donated to the Momusys-project as background code by
 *		Telenor. 
 *
 *		based on mpeg2decode, (C) 1994, MPEG Software Simulation Group
 *		and mpeg2play, (C) 1994 Stefan Eckart
 *                         <stefan@lis.e-technik.tu-muenchen.de>
 *
 *
 * Modified:	9-May-96 Paulo Nunes: Reformatted. New headers.
 *	       21-May-97 Paulo Nunes: Changed Bitstream structure to allow
 *				      look ahead up to 64 bits.
 *
 ***********************************************************HeaderEnd*********/


/************************    INCLUDE FILES    ********************************/

#ifndef _MOM_BITSTREAM_D_H_
#define _MOM_BITSTREAM_D_H_

#include "momusys.h"
#include "mom_structs.h"
#include "mom_access.h"
#include "mom_image.h"

typedef struct {
  Int val, len;
} VLCtab;

#include "mom_trace.h"

#define BFR_SIZE		2048

#define INBFR_BYTES		8
#define INBFR_TOTAL_BITS	3*INBFR_BYTES*8

#define SE_CODE                 31

struct bitstream
{
    File *fptr;			/* pointer to input file */
    UChar rdbfr[BFR_SIZE+4];	/* bitstream data */
    UChar *rdptr;
    UChar inbfr[3*INBFR_BYTES];
    Int incnt;
    Int bitcnt;
};
typedef struct bitstream Bitstream;


#include "mom_bitstream_d.p"


#endif /* _MOM_BITSTREAM_D_H_ */
