/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by                                 */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation  and Texas Instruments            */ 
/****************************************************************************/

/****************************************************************************/
/*     Texas Instruments Predictive Embedded Zerotree (PEZW) Image Codec    */
/*     Copyright 1996, 1997, 1998 Texas Instruments	      		    */
/****************************************************************************/

#ifndef _WVTPEZW_H_
#define _WVTPEZW_H_
#include "momusys.h"

typedef struct array_2D {
   Int width;
   Int height;
   Void *data;
   UChar *mask;
} Array_2D;

typedef struct array_1D {
  Int length;
  Void *data;
#ifdef _SA_DWT_
   UChar *mask;
#endif
} Array_1D;

typedef struct pezw_snr_layer {
  Int       Quant;
  Int       allzero;
  Array_2D  snr_image;
  Array_1D  snr_bitstream;
} PEZW_SNR_LAYER;

typedef struct pezw_spatial_layer {
  Int           spatial_bitstream_length;
  Int           SNR_scalability_levels;
  PEZW_SNR_LAYER    *SNRlayer;
} PEZW_SPATIAL_LAYER;


/* data type used for store wavelet coefficients */
typedef short WINT;   

/* maximum number of zero runs for start code violation checking */
#define MAXRUNZERO    22
#define DEBUG_BILEVEL 0
#define DEBUG_DEC_BS  0

#include "PEZW_utils.p"
#include "wvtpezw_spatial_snr.p"
#include "wvtdecodepezw_spatial_snr.p"
#endif
 
