/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Noel O'Connor (Teltec DCU / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mom_vo.c
 *
 * Author:	Noel O'Connor Teltec Irl.
 * Created:	23-07-96
 *                                                                         
 * Description: 
 *	Functions related to VO structure (except access functions)
 *
 * Notes: 	
 *
 * Modified:	
 *	29.11.96 Noel O'Connor : new function GetVOById() to return a pointer
 *		to a particular VO in a linked list of VOs.
 * 
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/
#include <stdio.h>
#include <stdlib.h>
#include "momusys.h"
#include "mom_access.h"
#include "mom_image.h"
#include "mom_vop.h"
#include "mom_vol.h"
#include "mom_vo.h"

/***********************************************************CommentBegin******
 *
 * -- SallocVO -- Allocates memory for a VO structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 * 	Allocates memory for a VO structure. Memory is NOT allocated for
 *	VOLs field of the structure.
 *
 * Arguments in : 	
 *	none
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VO *vo - pointer to allocated VO.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

VO *
SallocVO()
{
	VO *vo;

	vo = (VO *)malloc(sizeof(VO));

	PutVOLayers(NULL,vo);
	PutVONext(NULL,vo);

	return(vo);
}

/***********************************************************CommentBegin******
 *
 * -- FreeVOList -- Deallocates all memory associated with a linked list
 *	of VOs.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 * 	Deallocates all memory associated with a linked list of VOs.
 *
 * Arguments in : 	
 *	VO *list - pointer to linked list
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	-
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

Void
FreeVOList(VO *list)
{
	VO 	*curr,
			*next;

	curr = list;

	while(curr != NULL)
	{
		next = GetVONext(curr);

		FreeVO(curr);

		curr = next;
	}

	return;
}

/***********************************************************CommentBegin******
 *
 * -- FreeVO -- Deallocates all memory associated with a VO
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 * 	Deallocates all memory asociated with a VO (incl. linked list of VOLs)
 *
 * Arguments in : 	
 *	VO *vo - pointer to vo
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

Void
FreeVO(VO *vo)
{
	Vol *vol_list;

	vol_list = GetVOLayers(vo);

	FreeVolList(vol_list);

	free((Char *)vo);

	return;
}

/***********************************************************CommentBegin******
 *
 * -- AddVOToList -- Adds a VO structure to a linked list VOs.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 * 	Adds a VO to a linked list of VOs. It is assumed that the list is NOT
 *	empty. (As usual, the new VO is added to the END of the list).
 *
 * Arguments in : 	
 *	VO *newvo - new VO to be added
 *
 * Arguments in/out :	
 *	VO *list - linked list
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	-
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	15.01.97 Robert Danielsen: Changed new to newvo to avoid C++
 *			reserved word. Solution by Fernando Jaureguizar.
 *	
 *
 ***********************************************************CommentEnd********/
Void
AddVOToList(VO *newvo, VO *list)
{
	VO 	*curr,
			*prev;

	prev = list;
	curr = GetVONext(prev);

	while(curr != NULL)
	{
		prev = curr;
		curr = GetVONext(curr);
	}

	PutVONext(newvo, prev);

	return;
}


/***********************************************************CommentBegin******
 *
 * -- GetVOById -- Returns a pointer to a VO in a linked list of VOs,
 *						identified by it's Id.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-11-96
 *
 * Purpose :		
 * 	Returns a pointer to a VO in a linked list of VOs,
 *		identified by it's Id.
 *
 * Arguments in : 	
 *	VO *list - linked list of VOs
 * Int vo_id - VO Id
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	-
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
	
VO *
GetVOById(VO *list,Int vo_id)
{
	VO		*curr;

	Int	id;

	curr = list;

	while(curr != NULL)
	{
		id = GetVOId(curr);
		if(id != vo_id)
			curr = GetVONext(curr);
		else
			break;
	}

	return(curr);
}


/***********************************************************CommentBegin******
 *
 * -- RoundTime -- Specific rounding function for time values
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	29-11-96
 *
 * Purpose :		
 *	Given a floating point time value, this function determines whether the
 *	value should be rounded up or down to aninteger value. The criterion is:
 *	val = (Int)time	if time - val < 0.001 => time = (Float)val 
 *	val = (Int)(time + 1) if val - time < 0.001 => time = (Float)val
 * 
 * Arguments in : 	
 *	Float time - time to be rounded
 *	
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	Float int_time - rounded time value
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

Float
RoundTime(Float time)
{
	Float	time_inc, time_diff;

	Int	int_time;

	/*
	 * time > .999 -> 1.000
	 *
	 */
	time_inc = time + 1;
	int_time = (Int)time_inc;
	time_diff = (Float)int_time - time;

	if(time_diff < 0.001)
		return((Float)int_time);

	/* 
	 * time < .001 -> .000
	 *
	 */
	int_time = (Int)time;
	time_diff = time - (Float)int_time;

	if(time_diff < 0.001)
		return((Float)int_time);

	return(time);
}
