/* Example of the REXX interface to ExCal                             */
/*                                                                    */
/* Those setting up many ExCal users (e.g., a LAN administrator) may  */
/* want to use REXX to create an ExCal with their own places and      */
/* event objects.  This REXX command file creates the same objects as */
/* does the EXCINST installation routine.  The primary difference is  */
/* this command file has no error checking and only does              */
/* installations.  See "Programming API" in the ExCal online help for */
/* more details.                                                      */
/*                                                                    */

signal on novalue

say 'Please enter the full path you copied EXCAL.DLL (e.g. C:\OS2\DLL) '
parse upper pull excalDLLpath .

if right(excalDLLpath,1) <> "\" then excalDLLpath = excalDLLpath || "\"
excalDLL = excalDLLpath || "EXCAL.DLL";

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;           

/* start by creating the ExCal folders */

rc = SysCreateObject("WPFolder", "ExCal Folder", ,
    "<WP_DESKTOP>", "OBJECTID=<EXCAL_INSTALLFOLDER>", "Update");
rc = SysCreateObject("WPFolder", "Event Templates", ,
    "<EXCAL_INSTALLFOLDER>", "OBJECTID=<EXCAL_EVENTSFOLDER>", "Update");
rc = SysCreateObject("WPFolder", "Places", ,
    "<EXCAL_INSTALLFOLDER>", "OBJECTID=<EXCAL_PLACESFOLDER>", "Update");

/* Register superclass of ExEvent and ExPlace */

rc = SysRegisterObjectClass("ExTransient", excalDLL);

/* create the event alarm and time class */

rc = SysRegisterObjectClass("ExTime", excalDLL);
rc = SysRegisterObjectClass("ExAlarm", excalDLL);
rc = SysCreateObject("ExAlarm", "ExCal.ALM", ,
    "<WP_DESKTOP>", "OBJECTID=<EXCAL_ALARM>", "Update");

/* create places */

rc = SysRegisterObjectClass("ExPlace", excalDLL);

rc = SysCreateObject("ExPlace", "Favorite Place", ,
    "<EXCAL_PLACESFOLDER>", "MAKEDEFAULT=YES", "Update");
rc = SysCreateObject("ExPlace", "Office", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=12 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "Restaurant", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=9 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "Tourist Spot", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=10 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "Vacation Spot", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=11 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "Classroom", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=13 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "Doctor's Office", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=14 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "Home", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=8 " || excalDLL, "Update");
rc = SysCreateObject("ExPlace", "None", ,
    "<EXCAL_PLACESFOLDER>", "ICONRESOURCE=20 " || excalDLL, "Update");

/* create events */

rc = SysRegisterObjectClass("ExEvent", excalDLL);

rc = SysCreateObject("ExEvent", "Morning Meeting", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=9:00;ENDTIME=10:00;PLACE=Office;ALARM=ON;", ,
     "Update");
rc = SysCreateObject("ExEvent", "Afternoon Meeting", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=13:00;ENDTIME=14:00;PLACE=Office;ALARM=ON;", ,
     "Update");
rc = SysCreateObject("ExEvent", "Vacation", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=9:00;ENDTIME=17:00;" || ,
     "PLACE=Vacation Spot;PERSONAL=YES;", ,
     "Update");
rc = SysCreateObject("ExEvent", "Seminar", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=13:00;ENDTIME=17:00;PLACE=Classroom;", ,
     "Update");
rc = SysCreateObject("ExEvent", "Chores", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=19:00;ENDTIME=21:00;PLACE=Home;", ,
     "Update");
rc = SysCreateObject("ExEvent", "Lunch", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=12:00;ENDTIME=13:00;PLACE=Restaurant;", ,
     "Update");
rc = SysCreateObject("ExEvent", "Medical Appointment", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=10:00;ENDTIME=11:00;PLACE=Doctor's Office;", ,
     "Update");
rc = SysCreateObject("ExEvent", "To-do (High Priority)", ,
     "TEMPLATE=YES;PRIORITY=1;STARTTIME=9:00", "Update");
rc = SysCreateObject("ExEvent", "To-do (Medium-High Priority)", ,
     "TEMPLATE=YES;PRIORITY=2;STARTTIME=9:00", "Update");
rc = SysCreateObject("ExEvent", "To-do (Medium Priority)", ,
     "TEMPLATE=YES;PRIORITY=3;STARTTIME=9:00", "Update");
rc = SysCreateObject("ExEvent", "To-do (Low Priority)", ,
     "TEMPLATE=YES;PRIORITY=4;STARTTIME=9:00", "Update");

rc = SysCreateObject("ExEvent", "Travel", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=12:00;ENDTIME=15:00;PLACE=None;" || ,
     "ICONRESOURCE=15 " || excalDLL, "Update");
rc = SysCreateObject("ExEvent", "Conference Call", "<EXCAL_EVENTSFOLDER>", ,
    "TEMPLATE=YES;STARTTIME=8:30;ENDTIME=9:30;PLACE=Office;" || ,
     "ICONRESOURCE=16 " || excalDLL, "Update");
rc = SysCreateObject("ExEvent", "Urgent!", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=12:00;ENDTIME=12:00;PLACE=None;ALARM=ON;" || ,
     "ICONRESOURCE=18 " || excalDLL, "Update");
rc = SysCreateObject("ExEvent", "Reminder", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=9:00;ENDTIME=9:00;PLACE=None;ALARM=ON;" || ,
     "PERSONAL=YES;ICONRESOURCE=23 " || excalDLL, "Update");
rc = SysCreateObject("ExEvent", "Special", "<EXCAL_EVENTSFOLDER>", ,
     "TEMPLATE=YES;STARTTIME=12:00;ENDTIME=12:00;PLACE=None;" || ,
     "ICONRESOURCE=17 " || excalDLL, "Update");

/* create calendar */

rc = SysRegisterObjectClass("ExCalendar", excalDLL);

rc = SysCreateObject("ExCalendar", "ExCal", "<EXCAL_INSTALLFOLDER>", ,
     "OBJECTID=<EXCAL_CALENDAR>", "Update");
rc = SysCreateObject("ExCalendar", "ExCal To-do List", "<EXCAL_INSTALLFOLDER>", ,
     "DEFAULTVIEW=TODO;OBJECTID=<EXCAL_CALENDARTODO>", "Update");

/* create address book */

rc = SysRegisterObjectClass("ExPerson", excalDLL);
rc = SysRegisterObjectClass("ExAddressBook", excalDLL);

rc = SysCreateObject("ExAddressBook", "Address Book", "<EXCAL_INSTALLFOLDER>", ,
     "ALWAYSSORT=YES;OBJECTID=<EXCAL_ADDRESSBOOK>", "Update");

/* done, open the install folder */

rc = SysSetObjectData("<EXCAL_INSTALLFOLDER>", ,
     "ICONRESOURCE=19 " || excalDLL);
rc = SysSetObjectData("<EXCAL_INSTALLFOLDER>", "OPEN=DEFAULT");
