/*
 * vPICdisasm - PIC program disassembler.
 * Written by Vanya A. Sergeev - <vsergeev@gmail.com>
 *
 * Copyright (C) 2007-2011 Vanya A. Sergeev
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 *
 * pic_instructionset.c - PIC instruction set data structure stored in an
 *  array of instruction info structures, as defined in pic_disasm.h.
 *
 */

#include "pic_disasm.h"

/* I decided to have the operand masks and types here in the
 * main instruction set data structure of the disassembler for clean
 * opcode recognition and operand extraction. It's much more straight
 * forward to work with numbers then manipulating ugly operand 
 * strings such as "000011rdddddrrrr" for the add instruction. */
/* This was my first disassembler, and my program ended evolving with this
 * data structure. Turns out it makes code pretty clear, and it generalizes the
 * entire disassembly process, but development probably took about 2x longer
 * instead of hard coding the disassembly for different types of operands. */
/* But this disassembler model can be applied to virtually any 16-bit
 * or less opcode architecture, making it very flexible in nature--I don't
 * have to rewrite all of the operand disassembly code for interpreting 
 * different r, d, K, k, s, etc. characters in the opcode, which all stand 
 * for a different operand type, because they are written out 
 * in the instruction set data structure.
 */
instructionInfo instructionSet_Baseline[PIC_TOTAL_BASELINE_INSTRUCTIONS] = {
	{"addwf", 0x01c0, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"andwf", 0x0140, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"clrf", 0x0060, 1, {0x001f, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"clrw", 0x0040, 0, {0x001f, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"comf", 0x0240, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decf", 0x00c0, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decfsz", 0x02c0, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"incf", 0x0280, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"incfsz", 0x03c0, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"iorwf", 0x0100, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movf", 0x0200, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movwf", 0x0020, 1, {0x001f, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"nop", 0x0000, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"rlf", 0x0340, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"rrf", 0x0300, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"subwf", 0x0080, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"swapf", 0x0380, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"xorwf", 0x0180, 2, {0x001f, 0x0020, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"bcf", 0x0400, 2, {0x001f, 0x00e0, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"bsf", 0x0500, 2, {0x001f, 0x00e0, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"btfsc", 0x0600, 2, {0x001f, 0x00e0, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"btfss", 0x0700, 2, {0x001f, 0x00e0, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"andlw", 0x0e00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"call", 0x0900, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_ABSOLUTE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"clrwdt", 0x0004, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"goto", 0x0a00, 1, {0x01ff, 0x0000, 0x0000}, {OPERAND_ABSOLUTE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"iorlw", 0x0d00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"movlw", 0x0c00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"option", 0x0002, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"retlw", 0x0800, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"sleep", 0x0003, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tris", 0x0000, 1, {0x0007, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"xorlw", 0x0f00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"data", 0x0000, 1, {0x3fff, 0x0000, 0x0000}, {OPERAND_WORD_DATA, OPERAND_NONE, OPERAND_NONE}},
};

instructionInfo instructionSet_MidRange[PIC_TOTAL_MIDRANGE_INSTRUCTIONS] = {
	{"addwf", 0x0700, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"andwf", 0x0500, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"clrf", 0x0180, 1, {0x007f, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"clrw", 0x0100, 0, {0x007f, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"comf", 0x0900, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decf", 0x0300, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decfsz", 0x0b00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"incf", 0x0a00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"incfsz", 0x0f00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"iorwf", 0x0400, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movf", 0x0800, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movwf", 0x0080, 1, {0x007f, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"nop", 0x0000, 0, {0x0060, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"option", 0x0062, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"rlf", 0x0d00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"rrf", 0x0c00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"subwf", 0x0200, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"swapf", 0x0e00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"tris", 0x0060, 1, {0x0007, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"xorwf", 0x0600, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"bcf", 0x1000, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"bsf", 0x1400, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"btfsc", 0x1800, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"btfss", 0x1c00, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"addlw", 0x3e00, 1, {0x00ff, 0x0100, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"andlw", 0x3900, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"call", 0x2000, 1, {0x07ff, 0x0000, 0x0000}, {OPERAND_ABSOLUTE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"clrwdt", 0x0064, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"goto", 0x2800, 1, {0x07ff, 0x0000, 0x0000}, {OPERAND_ABSOLUTE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"iorlw", 0x3800, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"movlw", 0x3000, 1, {0x00ff, 0x0300, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"retfie", 0x0009, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"retlw", 0x3400, 1, {0x00ff, 0x0300, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"return", 0x0008, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"sleep", 0x0063, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"sublw", 0x3c00, 1, {0x00ff, 0x0100, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"xorlw", 0x3a00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"data", 0x0000, 1, {0x3fff, 0x0000, 0x0000}, {OPERAND_WORD_DATA, OPERAND_NONE, OPERAND_NONE}},
};

instructionInfo instructionSet_MidRange_Enhanced[PIC_TOTAL_MIDRANGE_ENHANCED_INSTRUCTIONS] = {
	{"addwfc", 0x3d00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"subwfb", 0x3b00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"lslf", 0x3500, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"lsrf", 0x3600, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"asrf", 0x3700, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movlb", 0x0020, 1, {0x001f, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"movlp", 0x3180, 1, {0x007f, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"bra", 0x3200, 1, {0x01ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"brw", 0x000b, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"callw", 0x000a, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"addfsr", 0x3100, 2, {0x0040, 0x003f, 0x0000}, {OPERAND_FSR_INDEX, OPERAND_SIGNED_LITERAL, OPERAND_NONE}},
	{"moviw", 0x0010, 2, {0x0004, 0x0003, 0x0000}, {OPERAND_INDF_INDEX, OPERAND_INCREMENT_MODE, OPERAND_NONE}},
	{"moviw", 0x3f00, 2, {0x0040, 0x003f, 0x0000}, {OPERAND_INDF_INDEX, OPERAND_SIGNED_LITERAL, OPERAND_NONE}},
	{"movwi", 0x0018, 2, {0x0004, 0x0003, 0x0000}, {OPERAND_INDF_INDEX, OPERAND_INCREMENT_MODE, OPERAND_NONE}},
	{"movwi", 0x3f80, 2, {0x0040, 0x003f, 0x0000}, {OPERAND_INDF_INDEX, OPERAND_SIGNED_LITERAL, OPERAND_NONE}},
	{"reset", 0x0001, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"addwf", 0x0700, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"andwf", 0x0500, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"clrf", 0x0180, 1, {0x007f, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"clrw", 0x0100, 0, {0x007f, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"comf", 0x0900, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decf", 0x0300, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decfsz", 0x0b00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"incf", 0x0a00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"incfsz", 0x0f00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"iorwf", 0x0400, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movf", 0x0800, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"movwf", 0x0080, 1, {0x007f, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"nop", 0x0000, 0, {0x0060, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"option", 0x0062, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"rlf", 0x0d00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"rrf", 0x0c00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"subwf", 0x0200, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"swapf", 0x0e00, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"tris", 0x0060, 1, {0x0007, 0x0000, 0x0000}, {OPERAND_REGISTER, OPERAND_NONE, OPERAND_NONE}},
	{"xorwf", 0x0600, 2, {0x007f, 0x0080, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"bcf", 0x1000, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"bsf", 0x1400, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"btfsc", 0x1800, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"btfss", 0x1c00, 2, {0x007f, 0x0380, 0x0000}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_NONE}},
	{"addlw", 0x3e00, 1, {0x00ff, 0x0100, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"andlw", 0x3900, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"call", 0x2000, 1, {0x07ff, 0x0000, 0x0000}, {OPERAND_ABSOLUTE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"clrwdt", 0x0064, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"goto", 0x2800, 1, {0x07ff, 0x0000, 0x0000}, {OPERAND_ABSOLUTE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"iorlw", 0x3800, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"movlw", 0x3000, 1, {0x00ff, 0x0300, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"retfie", 0x0009, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"retlw", 0x3400, 1, {0x00ff, 0x0300, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"return", 0x0008, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"sleep", 0x0063, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"sublw", 0x3c00, 1, {0x00ff, 0x0100, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"xorlw", 0x3a00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"data", 0x0000, 1, {0x3fff, 0x0000, 0x0000}, {OPERAND_WORD_DATA, OPERAND_NONE, OPERAND_NONE}},
};

instructionInfo instructionSet_PIC18[PIC_TOTAL_PIC18_INSTRUCTIONS] = {
	{"addwf", 0x2400, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"addwfc", 0x2000, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"andwf", 0x1400, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"clrf", 0x6a00, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"comf", 0x1c00, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"cpfseq", 0x6200, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"cpfsgt", 0x6400, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"cpfslt", 0x6000, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"decf", 0x0400, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"decfsz", 0x2c00, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"dcfsnz", 0x4c00, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"incf", 0x2800, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"incfsz", 0x3c00, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"infsnz", 0x4800, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"iorwf", 0x1000, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"movf", 0x5000, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"movwf", 0x6e00, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"mulwf", 0x0200, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"negf", 0x6c00, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"rlcf", 0x3400, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"rlncf", 0x4400, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"rrcf", 0x3000, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"rrncf", 0x4000, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"setf", 0x6800, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"subfwb", 0x5400, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"subwf", 0x5c00, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"subwfb", 0x5800, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"swapf", 0x3800, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"tstfsz", 0x6600, 2, {0x00ff, 0x0100, 0x0000}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_NONE}},
	{"xorwf", 0x1800, 3, {0x00ff, 0x0200, 0x0100}, {OPERAND_REGISTER, OPERAND_REGISTER_DEST, OPERAND_REGISTER_DEST}},
	{"bcf", 0x9000, 3, {0x00ff, 0x0e00, 0x0100}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_REGISTER_DEST}},
	{"bsf", 0x8000, 3, {0x00ff, 0x0e00, 0x0100}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_REGISTER_DEST}},
	{"btfsc", 0xb000, 3, {0x00ff, 0x0e00, 0x0100}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_REGISTER_DEST}},
	{"btfss", 0xa000, 3, {0x00ff, 0x0e00, 0x0100}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_REGISTER_DEST}},
	{"btg", 0x7000, 3, {0x00ff, 0x0e00, 0x0100}, {OPERAND_REGISTER, OPERAND_BIT, OPERAND_REGISTER_DEST}},
	{"bc", 0xe200, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bn", 0xe600, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bnc", 0xe300, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bnn", 0xe700, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bnov", 0xe500, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bnz", 0xe100, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bov", 0xe400, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bra", 0xd000, 1, {0x07ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"bz", 0xe000, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"clrwdt", 0x0004, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"daw", 0x0007, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"nop", 0x0000, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"nop", 0xf000, 0, {0x0000, 0x0fff, 0x0fff}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"pop", 0x0006, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"push", 0x0005, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"rcall", 0xd800, 1, {0x07ff, 0x0000, 0x0000}, {OPERAND_RELATIVE_ADDRESS, OPERAND_NONE, OPERAND_NONE}},
	{"reset", 0x00ff, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"retfie", 0x0010, 1, {0x0001, 0x0000, 0x0000}, {OPERAND_REGISTER_DEST, OPERAND_NONE, OPERAND_NONE}},
	{"retlw", 0x0c00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"return", 0x0012, 1, {0x0001, 0x0000, 0x0000}, {OPERAND_REGISTER_DEST, OPERAND_NONE, OPERAND_NONE}},
	{"sleep", 0x0003, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"addlw", 0x0f00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"andlw", 0x0b00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"iorlw", 0x0900, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"movlb", 0x0100, 1, {0x000f, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"movlw", 0x0e00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"mullw", 0x0d00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"retlw", 0x0c00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"sublw", 0x0800, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"xorlw", 0x0a00, 1, {0x00ff, 0x0000, 0x0000}, {OPERAND_LITERAL, OPERAND_NONE, OPERAND_NONE}},
	{"tblrd*", 0x0008, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblrd*+", 0x0009, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblrd*-", 0x000a, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblrd+*", 0x000b, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblwt*", 0x000c, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblwt*+", 0x000d, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblwt*-", 0x000e, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"tblwt+*", 0x000f, 0, {0x0000, 0x0000, 0x0000}, {OPERAND_NONE, OPERAND_NONE, OPERAND_NONE}},
	{"data", 0x0000, 1, {0xffff, 0x0000, 0x0000}, {OPERAND_WORD_DATA, OPERAND_NONE, OPERAND_NONE}},
};

instructionSetInfo allInstructionSets[] = {
	{instructionSet_Baseline, PIC_TOTAL_BASELINE_INSTRUCTIONS},
	{instructionSet_MidRange, PIC_TOTAL_MIDRANGE_INSTRUCTIONS},
	{instructionSet_MidRange_Enhanced, PIC_TOTAL_MIDRANGE_ENHANCED_INSTRUCTIONS},
	{instructionSet_PIC18, PIC_TOTAL_PIC18_INSTRUCTIONS},
};

